/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Point;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public class PointRegistry {
    private ArrayList pointList_ = new ArrayList();
    private IdentifiedPoint[] points_;
    private boolean ready_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$PointRegistry;

    public void addPoint(int ip, Point p) {
        if (this.ready_) {
            throw new IllegalStateException("Too late to add new points");
        }
        this.pointList_.add(new IdentifiedPoint(ip, p));
    }

    public void ready() {
        this.points_ = this.pointList_.toArray(new IdentifiedPoint[0]);
        this.pointList_ = null;
        Arrays.sort(this.points_);
        this.ready_ = true;
    }

    public BitSet getContainedPoints(Shape shape) {
        if (!this.ready_) {
            throw new IllegalStateException("Not ready!");
        }
        BitSet inside = new BitSet();
        int npoint = this.points_.length;
        int lastX = Integer.MIN_VALUE;
        int lastY = Integer.MIN_VALUE;
        boolean lastIn = false;
        int i = 0;
        while (i < npoint) {
            boolean in;
            IdentifiedPoint ipoint = this.points_[i];
            int px = ipoint.x_;
            int py = ipoint.y_;
            boolean bl = in = px == lastX && py == lastY ? lastIn : shape.contains(px, py);
            if (in) {
                inside.set(ipoint.id_);
            }
            lastX = px;
            lastY = py;
            lastIn = in;
            ++i;
        }
        return inside;
    }

    public int[] getNearbyPoints(Point p, int error) {
        IdentifiedPoint[] ipoints = this.getNearbyIPoints(p, error);
        int npoint = ipoints.length;
        int[] pointIndices = new int[npoint];
        int i = 0;
        while (i < npoint) {
            pointIndices[i] = ipoints[i].id_;
            ++i;
        }
        return pointIndices;
    }

    public int getClosestPoint(Point p, int error) {
        IdentifiedPoint[] ipoints = this.getNearbyIPoints(p, error);
        int npoint = ipoints.length;
        if (npoint == 0) {
            return -1;
        }
        if (npoint == 1) {
            return ipoints[0].id_;
        }
        if (!$assertionsDisabled && npoint <= 1) {
            throw new AssertionError();
        }
        int x = p.x;
        int y = p.y;
        int maxr2 = Integer.MAX_VALUE;
        IdentifiedPoint closest = null;
        int i = 0;
        while (i < npoint) {
            IdentifiedPoint ipoint = ipoints[i];
            int dx = x - ipoint.x_;
            int dy = y - ipoint.y_;
            int r2 = dx * dx + dy + dy;
            if (r2 < maxr2) {
                maxr2 = r2;
                closest = ipoint;
            }
            ++i;
        }
        if (!$assertionsDisabled && closest == null) {
            throw new AssertionError();
        }
        return closest.id_;
    }

    private IdentifiedPoint[] getNearbyIPoints(Point p, int error) {
        if (!this.ready_) {
            throw new IllegalStateException("Not ready!");
        }
        int px = p.x;
        int py = p.y;
        int loX = px - error;
        int hiX = px + error;
        int loY = py - error;
        int hiY = py + error;
        Point loPoint = new Point(loX, Integer.MIN_VALUE);
        IdentifiedPoint dummyPoint = new IdentifiedPoint(-1, loPoint);
        int loIndex = -Arrays.binarySearch(this.points_, dummyPoint) - 1;
        int np = this.points_.length;
        ArrayList<IdentifiedPoint> foundPoints = new ArrayList<IdentifiedPoint>(100);
        int i = loIndex;
        while (i < np) {
            IdentifiedPoint point = this.points_[i];
            int x = point.x_;
            if (x > hiX) break;
            int y = point.y_;
            if (y >= loY && y <= hiY) {
                foundPoints.add(point);
            }
            ++i;
        }
        return foundPoints.toArray(new IdentifiedPoint[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$PointRegistry == null ? (class$uk$ac$starlink$topcat$plot$PointRegistry = PointRegistry.class$("uk.ac.starlink.topcat.plot.PointRegistry")) : class$uk$ac$starlink$topcat$plot$PointRegistry).desiredAssertionStatus();
    }

    private static class IdentifiedPoint
    implements Comparable {
        final int id_;
        final int x_;
        final int y_;

        IdentifiedPoint(int id, Point p) {
            this.id_ = id;
            this.x_ = p.x;
            this.y_ = p.y;
        }

        public int compareTo(Object o) {
            IdentifiedPoint other = (IdentifiedPoint)o;
            int x1 = this.x_;
            int x2 = other.x_;
            if (x1 == x2) {
                int y1 = this.y_;
                int y2 = other.y_;
                if (y1 == y2) {
                    return 0;
                }
                return y1 < y2 ? -1 : 1;
            }
            return x1 < x2 ? -1 : 1;
        }

        public String toString() {
            return "#" + this.id_ + ": (" + this.x_ + ", " + this.y_ + ")";
        }
    }
}

