/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.OverlayLayout;
import javax.swing.table.AbstractTableModel;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.plot.MarkStyle;
import uk.ac.starlink.topcat.plot.PlotState;
import uk.ac.starlink.topcat.plot.PlotSurface;
import uk.ac.starlink.topcat.plot.Points;
import uk.ac.starlink.topcat.plot.XYStats;

public class ScatterPlot
extends JComponent
implements Printable {
    private Points points_;
    private PlotState state_;
    private PlotSurface surface_;
    private Annotations annotations_;
    private Points lastPoints_;
    private PlotState lastState_;
    private PlotSurface lastSurface_;
    private int lastWidth_;
    private int lastHeight_;
    private Image image_;
    private XYStats[] statSets_;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$ScatterPlot;

    public ScatterPlot(PlotSurface surface) {
        this.setLayout(new OverlayLayout(this));
        this.setOpaque(false);
        this.add(new ScatterDataPanel());
        this.annotations_ = new Annotations();
        this.setSurface(surface);
    }

    public void setSurface(PlotSurface surface) {
        if (this.surface_ != null) {
            this.remove(this.surface_.getComponent());
        }
        this.surface_ = surface;
        this.surface_.setState(this.state_);
        this.surface_.getComponent().setOpaque(false);
        this.add(this.surface_.getComponent());
    }

    public PlotSurface getSurface() {
        return this.surface_;
    }

    public void setPoints(Points points) {
        this.points_ = points;
    }

    public Points getPoints() {
        return this.points_;
    }

    public void setState(PlotState state) {
        this.state_ = state;
        this.annotations_.validate();
        if (this.surface_ != null) {
            this.surface_.setState(this.state_);
        }
    }

    public PlotState getState() {
        return this.state_;
    }

    public void setActivePoint(int ip) {
        this.annotations_.setActivePoint(ip);
    }

    public void rescale() {
        boolean xlog = this.state_.isXLog();
        boolean ylog = this.state_.isYLog();
        double xlo = Double.POSITIVE_INFINITY;
        double xhi = xlog ? Double.MIN_VALUE : Double.NEGATIVE_INFINITY;
        double ylo = Double.POSITIVE_INFINITY;
        double yhi = ylog ? Double.MIN_VALUE : Double.NEGATIVE_INFINITY;
        int nok = 0;
        Points points = this.points_;
        if (points != null) {
            RowSubset[] rsets = this.getState().getSubsets();
            int nrset = rsets.length;
            int np = points.getCount();
            double[] xv = points.getXVector();
            double[] yv = points.getYVector();
            int ip = 0;
            while (ip < np) {
                boolean use = false;
                long lp = ip;
                int is = 0;
                while (!use && is < nrset) {
                    use = use || rsets[is].isIncluded(lp);
                    ++is;
                }
                if (use) {
                    double xp = xv[ip];
                    double yp = yv[ip];
                    if (!(Double.isNaN(xp) || Double.isNaN(yp) || Double.isInfinite(xp) || Double.isInfinite(yp) || xlog && !(xp > 0.0) || ylog && !(yp > 0.0))) {
                        ++nok;
                        if (xp < xlo) {
                            xlo = xp;
                        }
                        if (xp > xhi) {
                            xhi = xp;
                        }
                        if (yp < ylo) {
                            ylo = yp;
                        }
                        if (yp > yhi) {
                            yhi = yp;
                        }
                    }
                }
                ++ip;
            }
        }
        if (nok == 0) {
            xlo = xlog ? 0.1 : -1.0;
            xhi = xlog ? 10.0 : 1.0;
            ylo = ylog ? 0.1 : -1.0;
            yhi = ylog ? 10.0 : 1.0;
        }
        this.surface_.setDataRange(xlo, ylo, xhi, yhi);
    }

    private void drawData(Graphics graphics) {
        Points points = this.points_;
        PlotState state = this.state_;
        Graphics2D g = (Graphics2D)graphics.create();
        g.setClip(this.surface_.getClip());
        double[] xv = points.getXVector();
        double[] yv = points.getYVector();
        int np = points.getCount();
        RowSubset[] sets = state.getSubsets();
        MarkStyle[] styles = state.getStyles();
        boolean[] regressions = state.getRegressions();
        int nset = sets.length;
        this.statSets_ = new XYStats[nset];
        int is = 0;
        while (is < nset) {
            MarkStyle style = styles[is];
            boolean regress = regressions[is];
            XYStats stats = null;
            if (regress) {
                this.statSets_[is] = stats = new XYStats(this.state_.isXLog(), this.state_.isYLog());
            }
            int maxr = style.getMaximumRadius();
            int ip = 0;
            while (ip < np) {
                int yp;
                int xp;
                double y;
                double x;
                Point point;
                if (sets[is].isIncluded(ip) && (point = this.surface_.dataToGraphics(x = xv[ip], y = yv[ip], true)) != null && g.hitClip(xp = point.x, yp = point.y, maxr, maxr)) {
                    style.drawMarker(g, xp, yp);
                    if (regress) {
                        stats.addPoint(x, y);
                    }
                }
                ++ip;
            }
            ++is;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(2.0f, 1, 1));
        int is2 = 0;
        while (is2 < nset) {
            double[] ends;
            XYStats stats = this.statSets_[is2];
            if (stats != null && (ends = stats.linearRegressionLine()) != null) {
                Point p1 = this.surface_.dataToGraphics(ends[0], ends[1], false);
                Point p2 = this.surface_.dataToGraphics(ends[2], ends[3], false);
                if (p1 != null && p2 != null) {
                    Color styleColor = styles[is2].getColor();
                    g.setColor(new Color(styleColor.getRed(), styleColor.getGreen(), styleColor.getBlue(), 160));
                    g.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
            }
            ++is2;
        }
    }

    private void drawAnnotations(Graphics g) {
        this.annotations_.draw(g);
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            double compHeight;
            double yscale;
            Graphics2D g2 = (Graphics2D)g.create();
            int gap = 70;
            double pageWidth = pf.getImageableWidth() - 2.0 * (double)gap;
            double pageHeight = pf.getImageableHeight() - 2.0 * (double)gap;
            double xinset = pf.getImageableX() + (double)gap;
            double yinset = pf.getImageableY() + (double)gap;
            double compWidth = this.getWidth();
            double xscale = pageWidth / compWidth;
            if (xscale < (yscale = pageHeight / (compHeight = (double)this.getHeight()))) {
                yscale = xscale;
            } else {
                xscale = yscale;
            }
            g2.translate(xinset, yinset);
            g2.scale(xscale, yscale);
            this.print(g2);
            return 0;
        }
        return 1;
    }

    public boolean isIncluded(int ip) {
        RowSubset[] sets = this.state_.getSubsets();
        int nset = sets.length;
        int is = 0;
        while (is < nset) {
            if (sets[is].isIncluded(ip)) {
                return true;
            }
            ++is;
        }
        return false;
    }

    public void displayRegressionCoefficients() {
        final RowSubset[] sets = this.state_.getSubsets();
        boolean[] regressions = this.state_.getRegressions();
        AbstractTableModel tmodel = new AbstractTableModel(){

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                return sets.length;
            }

            public String getColumnName(int icol) {
                switch (icol) {
                    case 0: {
                        return "Subset";
                    }
                    case 1: {
                        return "Gradient";
                    }
                    case 2: {
                        return "Intercept";
                    }
                    case 3: {
                        return "Correlation";
                    }
                }
                throw new IllegalArgumentException();
            }

            public Object getValueAt(int irow, int icol) {
                if (icol == 0) {
                    return sets[irow].getName();
                }
                XYStats stats = ScatterPlot.this.statSets_[irow];
                if (stats == null) {
                    return null;
                }
                switch (icol) {
                    case 1: {
                        double m = stats.getLinearCoefficients()[1];
                        return new Float((float)m);
                    }
                    case 2: {
                        double c = stats.getLinearCoefficients()[0];
                        return new Float((float)c);
                    }
                    case 3: {
                        double r = stats.getCorrelation();
                        return new Float((float)r);
                    }
                }
                throw new IllegalArgumentException();
            }
        };
        JTable jtab = new JTable(tmodel);
        JScrollPane tscroller = new JScrollPane(jtab);
        tscroller.setPreferredSize(new Dimension(450, 100));
        Object[] msg = new Object[]{"Coefficients for plotted regression lines", tscroller};
        JOptionPane.showMessageDialog(this, msg, "Linear Regression Coefficients", 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ScatterDataPanel
    extends JComponent {
        static final /* synthetic */ boolean $assertionsDisabled;

        ScatterDataPanel() {
            this.setOpaque(false);
        }

        protected void paintComponent(Graphics g) {
            int width = this.getBounds().width;
            int height = this.getBounds().height;
            if (ScatterPlot.this.state_ == ScatterPlot.this.lastState_ && ScatterPlot.this.surface_ == ScatterPlot.this.lastSurface_ && ScatterPlot.this.points_ == ScatterPlot.this.lastPoints_ && width == ScatterPlot.this.lastWidth_ && height == ScatterPlot.this.lastHeight_) {
                if (!$assertionsDisabled && ScatterPlot.this.image_ == null) {
                    throw new AssertionError();
                }
            } else {
                ScatterPlot.this.image_ = this.createImage(width, height);
                Graphics ig = ScatterPlot.this.image_.getGraphics();
                ScatterPlot.this.surface_.paintSurface(ig);
                ScatterPlot.this.drawData(ig);
                ScatterPlot.this.lastState_ = ScatterPlot.this.state_;
                ScatterPlot.this.lastSurface_ = ScatterPlot.this.surface_;
                ScatterPlot.this.lastPoints_ = ScatterPlot.this.points_;
                ScatterPlot.this.lastWidth_ = width;
                ScatterPlot.this.lastHeight_ = height;
            }
            boolean done = g.drawImage(ScatterPlot.this.image_, 0, 0, null);
            if (!$assertionsDisabled && !done) {
                throw new AssertionError();
            }
            ScatterPlot.this.drawAnnotations(g);
        }

        protected void printComponent(Graphics g) {
            ScatterPlot.this.drawData(g);
            ScatterPlot.this.drawAnnotations(g);
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$ScatterPlot == null ? (class$uk$ac$starlink$topcat$plot$ScatterPlot = ScatterPlot.class$("uk.ac.starlink.topcat.plot.ScatterPlot")) : class$uk$ac$starlink$topcat$plot$ScatterPlot).desiredAssertionStatus();
        }
    }

    private class Annotations {
        int activePoint_ = -1;

        private Annotations() {
        }

        void setActivePoint(int ip) {
            int oldActivePoint = this.activePoint_;
            int n = this.activePoint_ = ip >= 0 && ScatterPlot.this.isIncluded(ip) ? ip : -1;
            if (oldActivePoint != this.activePoint_) {
                ScatterPlot.this.repaint();
            }
        }

        void draw(Graphics graphics) {
            Point p;
            Graphics2D g2 = (Graphics2D)graphics.create();
            if (this.activePoint_ >= 0 && (p = ScatterPlot.this.surface_.dataToGraphics(ScatterPlot.this.points_.getXVector()[this.activePoint_], ScatterPlot.this.points_.getYVector()[this.activePoint_], true)) != null) {
                Graphics2D g = (Graphics2D)g2.create();
                g.setColor(new Color(0, 0, 0, 192));
                g.setStroke(new BasicStroke(2.0f, 1, 1));
                g.translate(p.x, p.y);
                g.drawOval(-6, -6, 13, 13);
                g.drawLine(0, 4, 0, 8);
                g.drawLine(0, -4, 0, -8);
                g.drawLine(4, 0, 8, 0);
                g.drawLine(-4, 0, -8, 0);
            }
        }

        void validate() {
            if (this.activePoint_ >= 0 && !ScatterPlot.this.isIncluded(this.activePoint_)) {
                this.activePoint_ = -1;
            }
        }
    }
}

