/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ant.tasks;

import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ExtdirProperty
extends Task {
    protected String name;
    protected StringBuffer value;
    protected Path path;
    protected Reference ref;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
        this.setPath((Path)ref.getReferencedObject(this.getProject()));
    }

    public Reference getRefid() {
        return this.ref;
    }

    public void setPath(Path path) {
        if (this.path == null) {
            this.path = path;
        } else {
            this.path.append(path);
        }
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.project);
        }
        return this.path.createPath();
    }

    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.value == null ? "" : this.value.toString();
    }

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new BuildException("You must specify a name for the property that will contain the CLASSPATH");
        }
        if (this.path == null || this.ref == null) {
            throw new BuildException("You must specify a path that contains the extension directories");
        }
        this.resolveClassPath();
        this.project.setProperty(this.name, this.value.toString());
    }

    protected void resolveClassPath() {
        String[] dirs = this.path.list();
        ArrayList elements = new ArrayList();
        int i = 0;
        while (i < dirs.length) {
            File dir = this.getProject().resolveFile(dirs[i]);
            if (dir.exists() && dir.isDirectory()) {
                FileSet fs = new FileSet();
                fs.setDir(dir);
                fs.setIncludes("*.jar");
                fs.setIncludes("*.zip");
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                String[] s = ds.getIncludedFiles();
                if (s != null && s.length > 0) {
                    this.addFiles(dir.getAbsolutePath(), s);
                }
            }
            ++i;
        }
    }

    protected void addFiles(String dir, String[] s) {
        int start = 0;
        if (this.value == null) {
            this.value = new StringBuffer(dir + File.separatorChar + s[0]);
            start = 1;
        }
        int i = start;
        while (i < s.length) {
            this.value.append(File.pathSeparatorChar);
            this.value.append(dir + File.separatorChar + s[i]);
            ++i;
        }
    }
}

