/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ant.types;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class ExtClasspath
extends Path {
    protected String name;
    protected StringBuffer value;
    protected Path path;
    protected Path resultPath;
    protected Reference ref;
    private Vector jarsDone = new Vector();

    public ExtClasspath(Project p) {
        super(p);
    }

    public ExtClasspath(Project p, String path) {
        super(p, path);
    }

    public String[] list() {
        if (JavaEnvUtils.isJavaVersion("1.4")) {
            String[] jars = super.list();
            int i = 0;
            while (i < jars.length) {
                File jarFile = this.project.resolveFile(jars[i]);
                if (jarFile.exists() && "jar".equals(this.getExtension(jarFile))) {
                    this.addDownloads(jarFile);
                }
                ++i;
            }
        } else {
            this.log("[extclasspath] not required for this compiler", 3);
        }
        return super.list();
    }

    protected void addDownloads(File jarFile) {
        this.log("[extclasspath] adding extension jar files from " + jarFile, 3);
        File jarBase = jarFile.getParentFile();
        File newJarFile = null;
        String[] s = this.getDownloads(jarFile);
        if (s != null && s.length > 0) {
            int j = 0;
            while (j < s.length) {
                newJarFile = new File(jarBase, s[j]);
                try {
                    newJarFile = newJarFile.getCanonicalFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (newJarFile.exists()) {
                    if ("jar".equals(this.getExtension(newJarFile))) {
                        if (this.jarsDone.indexOf(newJarFile) == -1) {
                            this.setLocation(newJarFile);
                            this.jarsDone.add(newJarFile);
                            this.addDownloads(newJarFile);
                            this.log("[extclasspath] adding " + newJarFile + " to extension jar files", 3);
                        } else {
                            this.log("[extclasspath] dropping " + newJarFile + " from extension jar files as already done", 3);
                        }
                    } else {
                        this.log("[extclasspath] dropping " + newJarFile + " from extension jar files as not jar file", 3);
                    }
                } else {
                    this.log("[extclasspath] dropping " + newJarFile + " from extension jar files as does not exist", 3);
                }
                ++j;
            }
        }
    }

    protected String[] getDownloads(File jarFile) {
        ArrayList<String> results = new ArrayList<String>();
        JarFile jarFileFile = null;
        Manifest manifest = null;
        try {
            jarFileFile = new JarFile(jarFile);
            manifest = jarFileFile.getManifest();
            if (manifest == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        Attributes.Name pathKey = Attributes.Name.CLASS_PATH;
        String path = attributes.getValue(pathKey);
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, " ");
            String[] result = new String[tokenizer.countTokens()];
            int i = 0;
            while (i < result.length) {
                results.add(tokenizer.nextToken());
                ++i;
            }
        }
        return results.toArray(new String[0]);
    }

    public String getExtension(File file) {
        String filename;
        int i;
        if (file != null && (i = (filename = file.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }
}

