/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.us_vo.www.SimpleResource;
import uk.ac.starlink.vo.MetaColumnModel;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryPanel;
import uk.ac.starlink.vo.RegistryTable;

public class RegistryPanel
extends JPanel {
    private Thread queryWorker_;
    protected Action submitQueryAction_;
    protected Action cancelQueryAction_;
    protected JScrollPane scroller_;
    protected RegistryTable regTable_;
    private final RegistryQueryPanel queryPanel_;
    private final JComponent qBox_;
    private JComponent workingPanel_;
    private JComponent dataPanel_;
    private List activeItems_ = new ArrayList();
    private String workingMessage_;

    public RegistryPanel() {
        super(new BorderLayout());
        this.cancelQueryAction_ = new AbstractAction("Cancel Query"){

            public void actionPerformed(ActionEvent evt) {
                RegistryPanel.this.cancelQuery();
            }
        };
        this.submitQueryAction_ = new AbstractAction("Submit Query"){

            public void actionPerformed(ActionEvent evt) {
                RegistryPanel.this.submitQuery();
            }
        };
        this.activeItems_.add(this.submitQueryAction_);
        this.qBox_ = Box.createVerticalBox();
        this.queryPanel_ = new RegistryQueryPanel();
        this.activeItems_.add(this.queryPanel_);
        this.qBox_.add(this.queryPanel_);
        this.qBox_.add(Box.createVerticalStrut(5));
        Box controlLine = Box.createHorizontalBox();
        controlLine.add(Box.createHorizontalGlue());
        controlLine.add(new JButton(this.cancelQueryAction_));
        controlLine.add(Box.createHorizontalStrut(5));
        controlLine.add(new JButton(this.submitQueryAction_));
        this.qBox_.add(controlLine);
        this.qBox_.add(Box.createVerticalStrut(5));
        this.scroller_ = new JScrollPane();
        this.scroller_.setBorder(BorderFactory.createEtchedBorder());
        this.workingPanel_ = new JPanel(new BorderLayout());
        this.regTable_ = new RegistryTable();
        this.regTable_.setColumnSelectionAllowed(false);
        this.regTable_.setRowSelectionAllowed(true);
        this.dataPanel_ = this.regTable_;
        this.setWorking(null);
        this.add((Component)this.qBox_, "North");
        this.add((Component)this.scroller_, "Center");
    }

    public RegistryQueryPanel getQueryPanel() {
        return this.queryPanel_;
    }

    public void performAutoQuery(String query, String workingMsg) {
        this.workingMessage_ = workingMsg;
        this.queryPanel_.getQuerySelector().setSelectedItem(query);
        this.remove(this.qBox_);
        this.submitQuery();
    }

    protected void gotData(SimpleResource[] resources) {
    }

    public SimpleResource[] getResources() {
        return this.regTable_.getData();
    }

    public SimpleResource[] getSelectedResources() {
        ListSelectionModel smodel = this.getResourceSelectionModel();
        ArrayList<SimpleResource> sres = new ArrayList<SimpleResource>();
        SimpleResource[] data = this.getResources();
        int i = smodel.getMinSelectionIndex();
        while (i <= smodel.getMaxSelectionIndex()) {
            if (smodel.isSelectedIndex(i)) {
                sres.add(data[i]);
            }
            ++i;
        }
        return sres.toArray(new SimpleResource[0]);
    }

    public void submitQuery() {
        Thread worker;
        RegistryQuery query;
        try {
            query = this.queryPanel_.getRegistryQuery();
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Query Error", 0);
            return;
        }
        this.setWorking(this.workingMessage_);
        this.queryWorker_ = worker = new Thread("Registry query"){
            SimpleResource[] data;
            String errmsg;
            Thread wk;
            {
                super(x0);
                this.wk = this;
            }

            public void run() {
                try {
                    SimpleResource[] dat = query.performQuery();
                    if (dat == null || dat.length == 0) {
                        this.errmsg = "No resources found for query";
                    } else {
                        this.data = dat;
                    }
                }
                catch (Throwable th) {
                    this.errmsg = th.getMessage();
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (RegistryPanel.access$100(3.access$000(this.this$1)) == this.this$1.wk) {
                            if (this.this$1.errmsg != null) {
                                JOptionPane.showMessageDialog(3.access$000(this.this$1), this.this$1.errmsg, "Query Error", 0);
                            } else {
                                3.access$000(this.this$1).regTable_.setData(this.this$1.data);
                                3.access$000(this.this$1).gotData(this.this$1.data);
                            }
                            RegistryPanel.access$200(3.access$000(this.this$1), null);
                        }
                    }
                });
            }

            static /* synthetic */ RegistryPanel access$000(3 x0) {
                return x0.RegistryPanel.this;
            }
        };
        worker.start();
    }

    public void cancelQuery() {
        if (this.queryWorker_ != null) {
            this.queryWorker_.interrupt();
            this.queryWorker_ = null;
        }
        this.setWorking(null);
    }

    public ListSelectionModel getResourceSelectionModel() {
        return this.regTable_.getSelectionModel();
    }

    public JMenu makeColumnVisibilityMenu(String name) {
        return ((MetaColumnModel)this.regTable_.getColumnModel()).makeCheckBoxMenu(name);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator it = this.activeItems_.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof Action) {
                ((Action)item).setEnabled(enabled);
                continue;
            }
            if (!(item instanceof Component)) continue;
            ((Component)item).setEnabled(enabled);
        }
    }

    private void setWorking(String message) {
        boolean working;
        boolean bl = working = message != null;
        if (!working) {
            this.scroller_.setViewportView(this.dataPanel_);
        } else {
            Box msgLine = Box.createHorizontalBox();
            msgLine.add(Box.createHorizontalGlue());
            msgLine.add(new JLabel(message));
            msgLine.add(Box.createHorizontalGlue());
            Box progLine = Box.createHorizontalBox();
            JProgressBar progBar = new JProgressBar();
            progBar.setIndeterminate(true);
            progLine.add(Box.createHorizontalGlue());
            progLine.add(progBar);
            progLine.add(Box.createHorizontalGlue());
            Box workBox = Box.createVerticalBox();
            workBox.add(Box.createVerticalGlue());
            workBox.add(msgLine);
            workBox.add(Box.createVerticalStrut(5));
            workBox.add(progLine);
            workBox.add(Box.createVerticalGlue());
            this.workingPanel_.removeAll();
            this.workingPanel_.add(workBox);
            this.scroller_.setViewportView(this.workingPanel_);
        }
        this.setEnabled(!working);
        this.cancelQueryAction_.setEnabled(working);
    }

    static /* synthetic */ Thread access$100(RegistryPanel x0) {
        return x0.queryWorker_;
    }

    static /* synthetic */ void access$200(RegistryPanel x0, String x1) {
        x0.setWorking(x1);
    }
}

