/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.vo.RegistryPanel;

public abstract class RegistryServiceTableLoadDialog
extends BasicTableLoadDialog {
    private final JComponent controlBox_;
    private final RegistryPanel regPanel_;
    private final String queryString_;
    private final String name_;
    private boolean setup_;
    private static Boolean available_;
    private static final Logger logger_;

    public RegistryServiceTableLoadDialog(String name, String description, String queryString) {
        super(name, description);
        this.name_ = name;
        this.queryString_ = queryString;
        final Action okAction = this.getOkAction();
        okAction.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.regPanel_ = new RegistryPanel();
        this.regPanel_.getResourceSelectionModel().setSelectionMode(0);
        this.regPanel_.getResourceSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                okAction.setEnabled(RegistryServiceTableLoadDialog.this.regPanel_.getSelectedResources().length == 1);
            }
        });
        this.add(this.regPanel_, "Center");
        this.controlBox_ = Box.createVerticalBox();
        this.add(this.controlBox_, "South");
        Border lineBorder = BorderFactory.createLineBorder(Color.BLACK);
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.regPanel_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), "Available " + name + " Services"));
        this.controlBox_.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(lineBorder, gapBorder), name + " Parameters"));
        this.setBorder(gapBorder);
        this.setPreferredSize(new Dimension(600, 450));
    }

    public boolean isAvailable() {
        block2: {
            if (available_ != null) break block2;
            try {
                Class<?> c = ((Object)((Object)this)).getClass();
                Class.forName("net.ivoa.www.xml.VORegistry.v0_3.Registry");
                Class.forName("org.us_vo.www.Registry");
                available_ = Boolean.TRUE;
            }
            catch (Throwable th) {
                logger_.info("WSDL classes unavailable (" + th + ")");
                available_ = Boolean.FALSE;
            }
        }
        return available_;
    }

    protected JComponent getControlBox() {
        return this.controlBox_;
    }

    protected RegistryPanel getRegistryPanel() {
        return this.regPanel_;
    }

    protected JDialog createDialog(Component parent) {
        JDialog dia;
        if (!this.setup_) {
            this.setup_ = true;
            boolean interactive = false;
            if (interactive) {
                this.regPanel_.getQueryPanel().setPresetQueries(new String[]{this.queryString_});
            } else {
                String msg = "Searching registry for " + this.name_ + " services";
                this.regPanel_.performAutoQuery(this.queryString_, msg);
            }
        }
        if ((dia = super.createDialog(parent)).getJMenuBar() == null) {
            dia.setJMenuBar(new JMenuBar());
        }
        JMenu metaMenu = this.regPanel_.makeColumnVisibilityMenu("Columns");
        metaMenu.setMnemonic(67);
        dia.getJMenuBar().add(metaMenu);
        return dia;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.regPanel_.setEnabled(enabled);
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.vo");
    }
}

