/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import uk.ac.starlink.table.BeanStarTable;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.vo.RegistryInterrogator;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryPanel;

public class RegistryTableLoadDialog
extends BasicTableLoadDialog {
    private final RegistryQueryPanel rqPanel_ = new RegistryQueryPanel();
    private static Boolean available_;
    public static String[] defaultQueries_;
    static /* synthetic */ Class class$org$us_vo$www$SimpleResource;

    public RegistryTableLoadDialog() {
        super("Registry Query", "Imports a table describing the result of querying a registry");
        this.rqPanel_.setPresetQueries(defaultQueries_);
        this.add(this.rqPanel_);
        this.rqPanel_.getQuerySelector().addActionListener(this.getOkAction());
    }

    public String getName() {
        return "Registry Query";
    }

    public String getDescription() {
        return "Returns a table describing the resources in a registry for a given query";
    }

    public boolean isAvailable() {
        block2: {
            if (available_ != null) break block2;
            try {
                available_ = RegistryInterrogator.isAvailable();
            }
            catch (Throwable th) {
                available_ = Boolean.FALSE;
            }
        }
        return available_;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.rqPanel_.setEnabled(enabled);
    }

    protected BasicTableLoadDialog.TableSupplier getTableSupplier() {
        try {
            final RegistryQuery query = this.rqPanel_.getRegistryQuery();
            return new BasicTableLoadDialog.TableSupplier(){

                public StarTable getTable(StarTableFactory factory, String format) throws IOException {
                    BeanStarTable st;
                    Object[] resources;
                    try {
                        resources = query.performQuery();
                    }
                    catch (RemoteException e) {
                        throw BasicTableLoadDialog.asIOException((Throwable)e);
                    }
                    catch (ServiceException e) {
                        throw BasicTableLoadDialog.asIOException((Throwable)e);
                    }
                    try {
                        st = new BeanStarTable(class$org$us_vo$www$SimpleResource == null ? (class$org$us_vo$www$SimpleResource = RegistryTableLoadDialog.class$("org.us_vo.www.SimpleResource")) : class$org$us_vo$www$SimpleResource);
                    }
                    catch (IntrospectionException e) {
                        throw BasicTableLoadDialog.asIOException((Throwable)e);
                    }
                    DescribedValue[] metadata = query.getMetadata();
                    int i = 0;
                    while (i < metadata.length) {
                        st.setParameter(metadata[i]);
                        ++i;
                    }
                    st.setData(resources);
                    return st;
                }

                public String getTableID() {
                    return query.toString();
                }
            };
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultQueries_ = new String[]{"All records", "serviceType like 'CONE'", "serviceType like 'SIAP'", "serviceType like 'SSAP'"};
    }
}

