/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import Sesame_pkg.Sesame;
import Sesame_pkg.SesameServiceLocator;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.vo.ResolverException;

public class ResolverInfo {
    private static SesameServiceLocator locator_;
    private double raDegrees_;
    private double decDegrees_;

    private ResolverInfo(Element resolverEl) throws ResolverException {
        ResolverInfo.checkTagname(resolverEl, "Resolver");
        this.raDegrees_ = Double.NaN;
        this.decDegrees_ = Double.NaN;
        Node node = resolverEl.getFirstChild();
        while (node != null) {
            String tag = ResolverInfo.getTagname(node);
            if ("jradeg".equals(tag)) {
                this.raDegrees_ = ResolverInfo.getDoubleContent((Element)node);
            } else if ("jdedeg".equals(tag)) {
                this.decDegrees_ = ResolverInfo.getDoubleContent((Element)node);
            }
            node = node.getNextSibling();
        }
        if (Double.isNaN(this.raDegrees_) || Double.isNaN(this.decDegrees_)) {
            throw new ResolverException("No position information");
        }
    }

    public double getRaDegrees() {
        return this.raDegrees_;
    }

    public double getDecDegrees() {
        return this.decDegrees_;
    }

    public static ResolverInfo resolve(String name) throws ResolverException {
        try {
            String result = ResolverInfo.getService().sesame(name, "x");
            Element el = new SourceReader().getElement((Source)new StreamSource(new ByteArrayInputStream(result.getBytes())));
            String tag = ResolverInfo.getTagname(el);
            if ("Sesame".equals(tag)) {
                return ResolverInfo.interpretSesame(el);
            }
            throw new ResolverException("Bad element type <" + tag + "> from Sesame");
        }
        catch (RemoteException e) {
            throw new ResolverException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new ResolverException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new ResolverException(e.getMessage(), e);
        }
    }

    private static ResolverInfo interpretSesame(Element sesameEl) throws ResolverException {
        ResolverInfo.checkTagname(sesameEl, "Sesame");
        ResolverInfo.checkForErrors(sesameEl);
        Node node = sesameEl.getFirstChild();
        while (node != null) {
            if ("Resolver".equals(ResolverInfo.getTagname(node))) {
                Element resolverEl = (Element)node;
                ResolverInfo.checkForErrors(resolverEl);
                return new ResolverInfo(resolverEl);
            }
            node = node.getNextSibling();
        }
        throw new ResolverException("Name not resolved");
    }

    private static void checkForErrors(Element el) throws ResolverException {
        Node node = el.getFirstChild();
        while (node != null) {
            if ("ERROR".equals(ResolverInfo.getTagname(node))) {
                throw new ResolverException(DOMUtils.getTextContent((Element)((Element)node)));
            }
            node = node.getNextSibling();
        }
    }

    private static void checkTagname(Node el, String tagname) {
        if (!tagname.equals(ResolverInfo.getTagname(el))) {
            throw new IllegalArgumentException("Node is not a <" + tagname + ">");
        }
    }

    private static String getTagname(Node node) {
        return node instanceof Element ? ((Element)node).getTagName() : null;
    }

    private static double getDoubleContent(Element el) {
        try {
            return Double.parseDouble(DOMUtils.getTextContent((Element)el));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    private static String getStringContent(Element el) {
        String s = DOMUtils.getTextContent((Element)el);
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        return s.trim();
    }

    private static synchronized Sesame getService() throws ServiceException {
        if (locator_ == null) {
            locator_ = new SesameServiceLocator();
        }
        return locator_.getSesame();
    }

    public static void main(String[] args) throws ResolverException {
        int i = 0;
        while (i < args.length) {
            String name = args[i];
            ResolverInfo info = ResolverInfo.resolve(name);
            System.out.println("\t" + name + ":\t" + (float)info.getRaDegrees() + ",\t" + (float)info.getDecDegrees());
            ++i;
        }
    }
}

