/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.us_vo.www.SimpleResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class SiapQuery {
    private final CgiQuery cgi_;
    private String name_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public SiapQuery(SimpleResource resource, double raPos, double decPos, double raSize, double decSize) {
        this(resource.getServiceURL(), raPos, decPos, raSize, decSize);
        if (!resource.getServiceType().toUpperCase().startsWith("SIAP")) {
            throw new IllegalArgumentException("Resource " + resource.getShortName() + " is not labelled as a SIAP service");
        }
        String id = null;
        if (id == null) {
            id = resource.getShortName();
        }
        if (id == null) {
            id = resource.getTitle();
        }
        if (id != null) {
            this.name_ = id;
        }
    }

    public SiapQuery(String baseURL, double raPos, double decPos, double raSize, double decSize) {
        this.cgi_ = new CgiQuery(baseURL);
        this.name_ = baseURL;
        this.addArgument("POS", raPos + "," + decPos);
        this.addArgument("SIZE", raSize == decSize ? Double.toString(raSize) : raSize + "," + decSize);
    }

    public void addArgument(String name, String value) {
        this.cgi_.addArgument(name, value);
    }

    public StarTable execute(StarTableFactory tfact) throws IOException {
        VOElement topEl;
        URL qurl = this.cgi_.toURL();
        logger_.info("Submitting query: " + qurl);
        StoragePolicy storage = tfact.getStoragePolicy();
        try {
            topEl = new VOElementFactory(storage).makeVOElement(qurl.openStream(), qurl.toString());
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        NodeList resources = topEl.getElementsByTagName("RESOURCE");
        Node results = null;
        int i = 0;
        while (i < resources.getLength()) {
            Element resource = (Element)resources.item(i);
            if (!resource.hasAttribute("type")) {
                results = resource;
            } else if ("results".equals(resource.getAttribute("type"))) {
                results = resource;
                break;
            }
            ++i;
        }
        if (results == null) {
            throw new IOException("No suitable RESOURCE found in returned VOTable");
        }
        String status = null;
        String message = null;
        Node node = results.getFirstChild();
        while (node != null) {
            Element el;
            if (node instanceof Element && "INFO".equals((el = (Element)node).getTagName()) && "QUERY_STATUS".equals(el.getAttribute("name"))) {
                status = el.getAttribute("value");
                message = DOMUtils.getTextContent((Element)el);
                break;
            }
            node = node.getNextSibling();
        }
        if ("ERROR".equals(status)) {
            throw new IOException("SIAP query error: " + message);
        }
        VOStarTable st = null;
        Node node2 = results.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof TableElement) {
                st = new VOStarTable((TableElement)node2);
                break;
            }
            node2 = node2.getNextSibling();
        }
        if (st == null) {
            throw new IOException("No TABLE element found in SIAP returned VOTable");
        }
        return st;
    }

    public String toString() {
        return this.name_;
    }
}

