/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.us_vo.www.SimpleResource;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.vo.DoubleValueField;
import uk.ac.starlink.vo.RegistryServiceTableLoadDialog;
import uk.ac.starlink.vo.SiapQuery;
import uk.ac.starlink.vo.ValueFieldPanel;

public class SiapTableLoadDialog
extends RegistryServiceTableLoadDialog {
    private final DoubleValueField raField_;
    private final DoubleValueField decField_;
    private final DoubleValueField sizeField_;

    public SiapTableLoadDialog() {
        super("SIAP Query", "Get results of a Simple Image Access Protocol query", "serviceType like 'SIAP'");
        Action okAction = this.getOkAction();
        this.raField_ = DoubleValueField.makeRADegreesField();
        this.raField_.getEntryField().addActionListener(okAction);
        this.raField_.setDescription("Right Ascension of region of interest centre");
        this.decField_ = DoubleValueField.makeDecDegreesField();
        this.decField_.getEntryField().addActionListener(okAction);
        this.decField_.setDescription("Declination of region of interest centre");
        this.sizeField_ = DoubleValueField.makeRadiusDegreesField();
        this.sizeField_.getEntryField().addActionListener(okAction);
        this.sizeField_.getValueInfo().setName("Size");
        this.sizeField_.setDescription("Size along RA,Dec axes of desired image");
        ValueFieldPanel qPanel = new ValueFieldPanel();
        qPanel.addField(this.raField_);
        qPanel.addField(this.decField_);
        qPanel.addField(this.sizeField_);
        this.getControlBox().add(qPanel);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.raField_.setEnabled(enabled);
        this.decField_.setEnabled(enabled);
        this.sizeField_.setEnabled(enabled);
    }

    public BasicTableLoadDialog.TableSupplier getTableSupplier() {
        SimpleResource[] resources = this.getRegistryPanel().getSelectedResources();
        if (resources.length != 1) {
            throw new IllegalStateException("No SIAP service selected");
        }
        double ra = this.raField_.getValue();
        double dec = this.decField_.getValue();
        double size = this.sizeField_.getValue();
        final SiapQuery query = new SiapQuery(resources[0], ra, dec, size, size);
        final List<DescribedValue> metadata = Arrays.asList(this.raField_.getDescribedValue(), this.decField_.getDescribedValue(), this.sizeField_.getDescribedValue());
        return new BasicTableLoadDialog.TableSupplier(){

            public StarTable getTable(StarTableFactory factory, String format) throws IOException {
                StarTable st = query.execute(factory);
                st.getParameters().addAll(metadata);
                return st;
            }

            public String getTableID() {
                return query.toString();
            }
        };
    }
}

