/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.connect;

import java.io.File;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.FileBranch;
import uk.ac.starlink.connect.FileLeaf;
import uk.ac.starlink.connect.Node;

public abstract class FileNode
implements Node {
    final File file_;

    protected FileNode(File file) {
        this.file_ = file.getAbsoluteFile();
    }

    public String getName() {
        return this.file_.getParentFile() == null ? this.file_.toString() : this.file_.getName();
    }

    public Branch getParent() {
        File parent = this.file_.getParentFile();
        return parent == null ? null : new FileBranch(parent);
    }

    public File getFile() {
        return this.file_;
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(this.getClass())) {
            return this.file_.equals(((FileNode)other).file_);
        }
        return false;
    }

    public int hashCode() {
        return this.file_.hashCode();
    }

    public String toString() {
        return this.file_.toString();
    }

    public static FileNode createNode(File file) {
        return file.isDirectory() ? new FileBranch(file) : new FileLeaf(file);
    }
}

