/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.coco;

import java.text.NumberFormat;
import java.util.StringTokenizer;
import uk.ac.starlink.pal.AngleDR;
import uk.ac.starlink.pal.Galactic;
import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.pal.Stardata;
import uk.ac.starlink.pal.mjDate;
import uk.ac.starlink.pal.palError;
import uk.ac.starlink.pal.palString;
import uk.ac.starlink.pal.palTime;

public class CoordinateConversion {
    private final String Version = "Version 1.00";
    private Pal pal;
    private final boolean DEBUG = true;
    private static final double D2R = Math.PI / 180;
    private static final double R2D = 57.29577951308232;
    private static final double S2R = 7.27220521664304E-5;
    private static final double AS2R = 4.84813681109536E-6;
    private static final double PIBY2 = 1.5707963267948966;
    private char insys = (char)52;
    private char inJB = (char)66;
    private double inepoch = 1950.0;
    private char inJBeq = (char)66;
    private double inequinox = 1950.0;
    private char outsys = (char)53;
    private char outJB = (char)74;
    private double outepoch = 2000.0;
    private char outJBeq = (char)74;
    private double outequinox = 2000.0;
    private boolean hours = true;
    private boolean degrees = false;
    private boolean lowprec = false;
    private boolean mediumprec = true;
    private boolean highprec = false;
    private String answer = null;
    private double da = 0.0;
    private double db = 0.0;
    private double px = 0.0;
    private double rv = 0.0;
    private int count = 0;
    private int jz = 0;
    private NumberFormat nf = NumberFormat.getNumberInstance();
    private NumberFormat nf2 = NumberFormat.getNumberInstance();
    private NumberFormat nfep = NumberFormat.getNumberInstance();
    private NumberFormat nfpx = NumberFormat.getNumberInstance();
    private NumberFormat nfrv = NumberFormat.getNumberInstance();
    private int pra = 3;
    private int prb = 2;
    private int prep = 2;
    private int prpx = 3;
    private int prrv = 1;
    private int pr1 = 5;
    private int pr2 = 4;

    public CoordinateConversion() {
        this.setup();
    }

    public CoordinateConversion(char in, char out) {
        this.insys = Character.toUpperCase(in);
        this.outsys = Character.toUpperCase(out);
        this.setup();
    }

    private void setup() {
        this.printDebug("setup: Conversion of Celestial Coordinates (Version 1.00)");
        this.pal = new Pal();
    }

    public String convert(String data) {
        StringTokenizer s = new StringTokenizer(data);
        String answer = null;
        int num = s.countTokens();
        if (num < 6) {
            return "Insufficient data " + data;
        }
        this.setInEpoch(s.nextToken());
        this.setOutEpoch(s.nextToken());
        String str = s.nextToken();
        if (str.length() < 4) {
            return "Insufficient data in " + str;
        }
        this.setPrecision(str.charAt(0));
        this.setUnits(str.charAt(1));
        this.setInSystem(str.charAt(2));
        this.setOutSystem(str.charAt(3));
        String coords = s.nextToken();
        num -= 4;
        while (num > 0) {
            coords = coords + " " + s.nextToken();
            --num;
        }
        System.out.println("Coords = " + coords);
        AngleDR r = this.validate(coords);
        answer = r != null ? this.convert(r) : "Invalid Input data: " + data;
        return answer;
    }

    public void setInSystem(char in) {
        this.insys = Character.toUpperCase(in);
        switch (this.insys) {
            case '4': 
            case 'B': 
            case 'G': {
                this.inJBeq = (char)66;
                this.inJB = (char)66;
                this.inequinox = 1950.0;
                this.inepoch = 1950.0;
                break;
            }
            case '5': {
                this.inJBeq = (char)74;
                this.inJB = (char)74;
                this.inequinox = 2000.0;
                this.inepoch = 2000.0;
            }
        }
    }

    public void setInEpoch(String ep) {
        if (ep == null) {
            return;
        }
        this.inJB = Character.toUpperCase(ep.charAt(0));
        if (this.inJB == 'B' || this.inJB == 'J') {
            this.inepoch = Double.parseDouble(ep.substring(1));
        } else {
            this.inJB = (char)32;
            this.inepoch = Double.parseDouble(ep.substring(0));
        }
    }

    public void setInEquinox(String eq) {
        if (eq == null) {
            return;
        }
        this.inJBeq = Character.toUpperCase(eq.charAt(0));
        this.inequinox = this.inJBeq == 'B' || this.inJBeq == 'J' ? Double.parseDouble(eq.substring(1)) : Double.parseDouble(eq.substring(0));
    }

    public void setOutSystem(char out) {
        this.outsys = Character.toUpperCase(out);
        switch (this.outsys) {
            case '4': 
            case 'B': 
            case 'G': {
                this.outJBeq = (char)66;
                this.outJB = (char)66;
                this.outequinox = 1950.0;
                this.outepoch = 1950.0;
                break;
            }
            case '5': {
                this.outJBeq = (char)74;
                this.outJB = (char)74;
                this.outequinox = 2000.0;
                this.outepoch = 2000.0;
            }
        }
    }

    public void setOutEpoch(String ep) {
        if (ep == null) {
            return;
        }
        this.outJB = Character.toUpperCase(ep.charAt(0));
        this.outepoch = this.outJB == 'B' || this.outJB == 'J' ? Double.parseDouble(ep.substring(1)) : Double.parseDouble(ep.substring(0));
    }

    public void setOutEquinox(String eq) {
        if (eq == null) {
            return;
        }
        this.outJBeq = Character.toUpperCase(eq.charAt(0));
        this.outequinox = this.outJBeq == 'B' || this.outJBeq == 'J' ? Double.parseDouble(eq.substring(1)) : Double.parseDouble(eq.substring(0));
    }

    public void setHigh() {
        this.setPrecision('H');
    }

    public void setMedium() {
        this.setPrecision('M');
    }

    public void setLow() {
        this.setPrecision('L');
    }

    public void setPrecision(String prec) {
        this.setUnits(prec.charAt(0));
    }

    public void setPrecision(char prec) {
        this.lowprec = false;
        this.mediumprec = false;
        this.highprec = false;
        switch (Character.toUpperCase(prec)) {
            case 'H': {
                this.highprec = true;
                this.pra = 5;
                this.prb = 4;
                this.prep = 3;
                this.prpx = 5;
                this.prrv = 3;
                this.pr1 = 8;
                this.pr2 = 7;
                break;
            }
            case 'L': {
                this.lowprec = true;
                this.pra = 1;
                this.prb = 0;
                this.prep = 1;
                this.prpx = 2;
                this.prrv = 1;
                this.pr1 = 2;
                this.pr2 = 1;
                break;
            }
            default: {
                this.mediumprec = true;
                this.pra = 3;
                this.prb = 2;
                this.prep = 2;
                this.prpx = 3;
                this.prrv = 1;
                this.pr1 = 5;
                this.pr2 = 4;
            }
        }
        this.nfep.setMinimumFractionDigits(this.prep);
        this.nfep.setMaximumFractionDigits(this.prep);
        this.nfep.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(this.pr1);
        this.nf.setMinimumFractionDigits(this.pr1);
        this.nf.setGroupingUsed(false);
        this.nf2.setMaximumFractionDigits(this.pr2);
        this.nf2.setMinimumFractionDigits(this.pr2);
        this.nf2.setGroupingUsed(false);
        this.nfpx.setMaximumFractionDigits(this.prpx);
        this.nfpx.setMinimumFractionDigits(this.prpx);
        this.nfpx.setGroupingUsed(false);
        this.nfrv.setMaximumFractionDigits(this.prrv);
        this.nfrv.setMinimumFractionDigits(this.prrv);
        this.nfrv.setGroupingUsed(false);
    }

    public void setDegrees() {
        this.setUnits('D');
    }

    public void setHours() {
        this.setUnits('H');
    }

    public void setUnits(String unit) {
        this.setUnits(unit.charAt(0));
    }

    public void setUnits(char unit) {
        if (Character.toUpperCase(unit) == 'D') {
            this.degrees = true;
            this.hours = false;
        } else if (Character.toUpperCase(unit) == 'H') {
            this.degrees = false;
            this.hours = true;
        }
    }

    public AngleDR validate(String value) {
        AngleDR ra;
        double b;
        double a;
        String text = null;
        this.printDebug("validate: Coord: " + value);
        this.printDebug("   System in: " + this.insys + " " + this.inJBeq + this.inequinox);
        this.printDebug("   System out: " + this.outsys + " " + this.outJBeq + this.outequinox);
        if (value.equals("")) {
            this.answer = null;
            return null;
        }
        text = value;
        palString val = new palString(value + "\n");
        double[] d = new double[10];
        int[] jf = new int[10];
        if (this.lowprec) {
            this.setPrecision('L');
        } else if (this.mediumprec) {
            this.setPrecision('M');
        } else if (this.highprec) {
            this.setPrecision('H');
        }
        if (this.insys == '4' || this.insys == 'B' || this.insys == '5' || this.insys == 'A') {
            int i = 0;
            while (i < 10) {
                double f = 0.0;
                f = this.pal.Dfltin(val, f);
                int j = this.pal.Status;
                d[i] = f;
                if ((i == 6 || i == 7) && val.getChar() == '\"') {
                    j = -2;
                    val.incrChar();
                }
                jf[i] = j;
                if (j > 1) {
                    this.printDebug("   Flag " + i + " = " + j);
                    return null;
                }
                if (j != 1) {
                    this.count = i + 1;
                }
                ++i;
            }
            this.printDebug("   Number of fields = " + this.count);
            if (this.count < 2) {
                return null;
            }
            if (this.count == 2) {
                jf[5] = 0;
                jf[4] = 0;
                d[3] = d[1];
                jf[3] = jf[1];
                d[1] = 0.0;
                jf[1] = 0;
                d[2] = 0.0;
                jf[2] = 0;
                this.count = 6;
            } else {
                if (this.degrees) {
                    return null;
                }
                if (this.count == 3) {
                    return null;
                }
                if (this.count == 4) {
                    jf[5] = 0;
                    d[4] = d[3];
                    jf[4] = jf[3];
                    d[3] = d[2];
                    jf[3] = jf[2];
                    d[2] = 0.0;
                    jf[2] = 0;
                    this.count = 6;
                } else if (this.count == 5) {
                    jf[5] = 0;
                    this.count = 6;
                }
            }
            this.printDebug("   Coarse Validity Check");
            if (jf[0] != 0 || jf[1] != 0 || jf[2] != 0 || jf[3] > 0 || jf[4] != 0 || jf[5] != 0 || this.count == 7 || Math.abs(d[6]) >= 15.0 || Math.abs(d[7]) >= 15.0 || jf[8] < 0 || d[8] >= 1.0 || Math.abs(d[9]) >= 200.0 || this.insys == 'A' && this.count > 6) {
                return null;
            }
            a = (60.0 * (60.0 * d[0] + d[1]) + d[2]) * 7.27220521664304E-5;
            b = (60.0 * (60.0 * Math.abs(d[3]) + d[4]) + d[5]) * 4.84813681109536E-6;
            if (jf[3] < 0) {
                b = -b;
            }
            this.jz = jf[6];
            this.da = d[6] * 7.27220521664304E-5;
            this.db = d[7] * 4.84813681109536E-6;
            this.px = d[8];
            this.rv = d[9];
            if (this.degrees) {
                a /= 15.0;
            }
            if (this.jz == -2) {
                ra = new AngleDR(this.da / 15.0, this.db);
                AngleDR rb = new AngleDR(0.0, b);
                ra = this.pal.Dtp2s(ra, rb);
                this.da = this.pal.Drange(ra.getAlpha());
                this.db = ra.getDelta() - b;
            } else {
                this.printDebug("   Angle > 15.0");
                if (Math.cos(a) * Math.abs(this.da) / 4.84813681109536E-6 >= 15.0) {
                    return null;
                }
            }
        } else {
            double w = 0.0;
            w = this.pal.Dfltin(val, w);
            if (this.pal.Status > 0) {
                return null;
            }
            a = w * (Math.PI / 180);
            w = this.pal.Dfltin(val, w);
            if (this.pal.Status > 0) {
                return null;
            }
            b = w * (Math.PI / 180);
            if (Math.abs(w) > 90.0) {
                return null;
            }
        }
        this.printDebug("   Check end of String " + val.getPos() + " " + val.length());
        if (val.getPos() < val.length()) {
            return null;
        }
        ra = new AngleDR(a, b);
        double[] v = this.pal.Dcs2c(ra);
        ra = this.pal.Dcc2s(v);
        ra.setAlpha(this.pal.Dranrm(ra.getAlpha()));
        ra = this.normalize(ra);
        return ra;
    }

    public AngleDR normalize(AngleDR ra) {
        double aw = ra.getAlpha();
        double bw = ra.getDelta();
        double[] dd = new double[]{this.da, this.db};
        double epb = this.pal.Epco('B', this.inJB, this.inepoch);
        double epb1 = this.pal.Epco('B', this.outJB, this.outepoch);
        double eqb = this.pal.Epco('B', this.inJBeq, this.inequinox);
        double epj = this.pal.Epco('J', this.inJB, this.inepoch);
        double epj1 = this.pal.Epco('J', this.outJB, this.outepoch);
        double eqj = this.pal.Epco('J', this.inJBeq, this.inequinox);
        this.printDebug("normalize: Angle ra =" + ra);
        this.printDebug("   inepoch = " + this.inepoch);
        this.printDebug("   outepoch = " + this.outepoch);
        this.printDebug("   inquinox = " + this.inequinox);
        if (this.insys == '4') {
            String system = "FK4";
            this.printDebug("   input system = " + system);
            if (this.hours) {
                this.printDebug("   Hours");
                palTime ifA = this.pal.Dr2tf(aw);
                palTime ifB = this.pal.Dr2af(bw);
                this.WRITE("  = " + ifA.toString(this.pra) + " " + ifB.printSign() + ifB.toString(this.prb) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + this.inJBeq + this.nfep.format(this.inequinox) + " " + system + " " + this.nfpx.format(this.px) + " " + this.nfrv.format(this.rv));
                if (this.jz != 1) {
                    this.WRITE(this.nf.format(this.da / 7.27220521664304E-5) + " " + this.nf2.format(this.db / 4.84813681109536E-6));
                }
            } else {
                this.printDebug("   Degrees");
                this.WRITE(" =   " + this.nf.format(this.r2d(aw)) + " " + this.nf2.format(bw / (Math.PI / 180)) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + this.inJBeq + this.nfep.format(this.inequinox) + " " + system);
            }
            if (this.jz != 1) {
                this.printDebug("   Proper Motion");
                AngleDR rw = this.pal.Pm(ra, dd, this.px, this.rv, epb, epb1);
                ra = this.pal.Subet(rw, eqb);
                ra = this.pal.Preces(system, eqb, 1950.0, ra);
                rw = this.pal.Addet(ra, 1950.0);
                ra = this.pal.Fk45z(rw, epb1);
            } else {
                AngleDR rb = this.pal.Subet(ra, eqb);
                ra = this.pal.Preces(system, eqb, 1950.0, rb);
                rb = this.pal.Addet(ra, 1950.0);
                ra = this.pal.Fk45z(rb, epb);
            }
        } else if (this.insys == 'B') {
            String system = "FK4 (no E-terms)";
            this.printDebug("   Input system = " + system);
            if (this.hours) {
                this.printDebug("   Hours");
                palTime ifA = this.pal.Dr2tf(aw);
                palTime ifB = this.pal.Dr2af(bw);
                this.WRITE("  = " + ifA.toString(this.pra) + " " + ifB.printSign() + ifB.toString(this.prb) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + this.inJBeq + this.nfep.format(this.inequinox) + " " + system + " " + this.nfpx.format(this.px) + " " + this.nfrv.format(this.rv));
                if (this.jz != 1) {
                    this.WRITE(this.nf.format(this.da / 7.27220521664304E-5) + " " + this.nf2.format(this.db / 4.84813681109536E-6));
                }
            } else {
                this.printDebug("   Degrees");
                this.WRITE(" =   " + this.nf.format(this.r2d(aw)) + " " + this.nf2.format(bw / (Math.PI / 180)) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + this.inJBeq + this.nfep.format(this.inequinox) + " " + system);
            }
            if (this.jz != 1) {
                this.printDebug("   Proper Motion");
                AngleDR rw = this.pal.Pm(ra, dd, this.px, this.rv, epb, epb1);
                ra = this.pal.Preces("FK4", eqb, 1950.0, rw);
                rw = this.pal.Addet(ra, 1950.0);
                ra = this.pal.Fk45z(rw, epb1);
            } else {
                AngleDR rw = this.pal.Preces("FK4", eqb, 1950.0, ra);
                AngleDR rb = this.pal.Addet(rw, 1950.0);
                ra = this.pal.Fk45z(rb, epb);
            }
        } else if (this.insys == '5') {
            String system = "FK5";
            this.printDebug("   Input system = " + system);
            if (this.hours) {
                this.printDebug("   Hours");
                palTime ifA = this.pal.Dr2tf(aw);
                palTime ifB = this.pal.Dr2af(bw);
                this.WRITE("  = " + ifA.toString(this.pra) + " " + ifB.printSign() + ifB.toString(this.prb) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + this.inJBeq + this.nfep.format(this.inequinox) + " " + system + " " + this.nfpx.format(this.px) + " " + this.nfrv.format(this.rv));
                if (this.jz != 1) {
                    this.WRITE(this.nf.format(this.da / 7.27220521664304E-5) + " " + this.nf2.format(this.db / 4.84813681109536E-6));
                }
            } else {
                this.printDebug("   Degrees");
                this.WRITE(" =   " + this.nf.format(this.r2d(aw)) + " " + this.nf2.format(bw / (Math.PI / 180)) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + this.inJBeq + this.nfep.format(this.inequinox) + " " + system);
            }
            this.printDebug("   Proper Motion");
            epj = this.pal.Epco('J', this.inJB, this.inepoch);
            eqj = this.pal.Epco('J', this.inJBeq, this.inequinox);
            AngleDR rw = this.pal.Pm(ra, dd, this.px, this.rv, epj, epj1);
            ra = this.pal.Preces(system, eqj, 2000.0, rw);
        } else if (this.insys == 'A') {
            String system = "geocentric apparent";
            this.printDebug("   Input system = " + system);
            mjDate ifD = null;
            double mjd = this.pal.Epj2d(epj);
            try {
                ifD = this.pal.Djcal(mjd);
            }
            catch (palError e) {
                // empty catch block
            }
            palTime ifA = this.pal.Dr2tf(aw);
            palTime ifB = this.pal.Dr2af(bw);
            if (this.hours) {
                this.printDebug("   Hours");
                this.WRITE("  = " + ifA.toString(this.pra) + " " + ifB.printSign() + ifB.toString(this.prb) + " " + ifD.toString(this.prrv) + " " + system);
            } else {
                this.printDebug("   Degrees");
                this.WRITE(" =   " + this.nf.format(this.r2d(aw)) + " " + this.nf2.format(bw / (Math.PI / 180)) + " " + ifD.toString(this.prrv) + " " + system);
            }
            this.printDebug("   Convert to J2000 FK5: " + ra + mjd);
            ra = this.pal.Amp(ra, mjd, 2000.0);
            this.printDebug("   Result " + ra);
        } else if (this.insys == 'E') {
            String system = "ecliptic";
            this.printDebug("   Input system = " + system);
            this.WRITE("  = " + this.nf.format(this.r2d(aw)) + " " + this.nf2.format(bw / (Math.PI / 180)) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + system);
            double dw = this.pal.Epj2d(epj);
            ra = this.pal.Ecleq(ra, dw);
        } else {
            String system = "galactic (II)";
            this.printDebug("   Input system = " + system);
            this.WRITE("  = " + this.nf.format(this.r2d(aw)) + " " + this.nf2.format(bw / (Math.PI / 180)) + " " + this.inJB + this.nfep.format(this.inepoch) + " " + system);
            Galactic g = new Galactic(ra.getAlpha(), ra.getDelta());
            ra = this.pal.Galeq(g);
        }
        return ra;
    }

    public String convert(AngleDR ra) {
        AngleDR rw;
        String system;
        if (ra == null) {
            return "No Coordinate specified";
        }
        double epb = this.pal.Epco('B', this.outJB, this.outepoch);
        double epj = this.pal.Epco('J', this.outJB, this.outepoch);
        double eqb = this.pal.Epco('B', this.outJBeq, this.outequinox);
        double eqj = this.pal.Epco('J', this.outJBeq, this.outequinox);
        Stardata sd = this.pal.Fk54z(ra, epb);
        this.printDebug("convert: Angle = " + ra);
        this.printDebug("   inepoch = " + this.inepoch);
        this.printDebug("   outepoch = " + this.outepoch);
        this.printDebug("   outequinox = " + this.outequinox);
        if (this.outsys == '4') {
            system = "FK4";
            this.printDebug("   Output system = " + system);
            ra = this.pal.Subet(sd.getAngle(), 1950.0);
            rw = this.pal.Preces("FK4", 1950.0, eqb, ra);
            ra = this.pal.Addet(rw, eqb);
        } else if (this.outsys == 'B') {
            system = "FK4 (no E-terms)";
            this.printDebug("   Output system = " + system);
            rw = this.pal.Subet(sd.getAngle(), 1950.0);
            ra = this.pal.Preces("FK4", 1950.0, eqb, rw);
        } else if (this.outsys == '5') {
            system = "FK5";
            this.printDebug("   Output system = " + system);
            ra = this.pal.Preces("FK5", 2000.0, eqj, ra);
        } else if (this.outsys == 'A') {
            system = "geocentric apparent";
            this.printDebug("   Ouput system = " + system);
            double[] pm = new double[]{0.0, 0.0};
            sd = new Stardata(ra, pm, this.px, 0.0);
            ra = this.pal.Map(sd, 2000.0, this.pal.Epj2d(epj));
        } else if (this.outsys == 'E') {
            system = "ecliptic";
            this.printDebug("   Output system = " + system);
            ra = this.pal.Eqecl(ra, this.pal.Epj2d(epj));
        } else if (this.outsys == 'G') {
            system = "galactic (II)";
            this.printDebug("   Output system = " + system);
            Galactic g = this.pal.Eqgal(ra);
            ra = new AngleDR(g.getLongitude(), g.getLatitude());
        } else {
            return "Unknown Output System";
        }
        this.printDebug("   Angle = " + ra);
        if (this.hours) {
            palTime ifA = this.pal.Dr2tf(ra.getAlpha());
            palTime ifB = this.pal.Dr2af(ra.getDelta());
            this.answer = ifA.toString(this.pra) + " " + ifB.printSign() + ifB.toString(this.prb);
            if (this.outsys == '4' || this.outsys == '5' || this.outsys == 'B') {
                this.answer = this.answer + " " + this.outJB + this.nfep.format(this.outepoch) + " " + this.outJBeq + this.nfep.format(this.outequinox) + " " + system;
            } else if (this.outsys == 'A') {
                try {
                    mjDate ifD = this.pal.Djcal(this.pal.Epj2d(epj));
                    this.answer = this.answer + " " + ifD.toString(this.prrv) + " " + system;
                }
                catch (palError e) {
                    this.answer = "Invalid date";
                }
            } else if (this.outsys == 'E' || this.outsys == 'G') {
                rw = new AngleDR(ra.getAlpha() / (Math.PI / 180), ra.getDelta() / (Math.PI / 180));
                this.answer = rw.toString(this.pr1) + " " + this.outJB + this.nfep.format(this.outepoch) + " " + system;
            }
        } else {
            this.answer = this.nf.format(ra.getAlpha() / (Math.PI / 180)) + " " + this.nf.format(ra.getDelta() / (Math.PI / 180)) + " " + this.outJB + this.nfep.format(this.outepoch) + " " + this.outJBeq + this.nfep.format(this.outequinox) + " " + system;
        }
        return this.answer;
    }

    private double r2d(double angle) {
        double c;
        double u = Math.pow(10.0, this.pr1);
        double v = Math.IEEEremainder((int)(angle * 57.29577951308232 * u), c = 360.0 * u);
        if (v < 0.0) {
            v += c;
        }
        return v / u;
    }

    private void WRITE(String s) {
        System.out.println(s);
    }

    private void printDebug(String message) {
        System.err.println("[Coco Debug] " + message);
    }
}

