/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.client.policy.manager.PolicyManagerDelegate;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.community.resolver.policy.manager.PolicyManagerResolver;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.store.Ivorn;

public class CommunityAccountResolver {
    private static Log log = LogFactory.getLog((Class)CommunityAccountResolver.class);
    private PolicyManagerResolver resolver;

    public CommunityAccountResolver() {
        this.resolver = new PolicyManagerResolver();
    }

    public CommunityAccountResolver(URL registry) {
        this.resolver = new PolicyManagerResolver(registry);
    }

    public AccountData resolve(Ivorn ivorn) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException, CommunityResolverException, RegistryException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityAccountResolver.resolve()");
        log.debug((Object)("  Ivorn : " + ivorn));
        if (null == ivorn) {
            throw new CommunityIdentifierException("Null identifier");
        }
        return this.resolve(new CommunityIvornParser(ivorn));
    }

    public AccountData resolve(CommunityIvornParser parser) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException, CommunityResolverException, RegistryException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityAccountResolver.resolve()");
        log.debug((Object)("  Ivorn : " + (null != parser ? parser.getIvorn() : null)));
        if (null == parser) {
            throw new CommunityIdentifierException("Null identifier");
        }
        PolicyManagerDelegate delegate = this.resolver.resolve(parser);
        return delegate.getAccount(parser.getAccountIdent());
    }
}

