/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver;

import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.resolver.CommunityAccountResolver;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.store.Ivorn;

public class CommunityAccountSpaceResolver {
    private static Log log = LogFactory.getLog((Class)CommunityAccountSpaceResolver.class);
    private CommunityAccountResolver resolver;

    public CommunityAccountSpaceResolver() {
        this.resolver = new CommunityAccountResolver();
    }

    public CommunityAccountSpaceResolver(URL registry) {
        this.resolver = new CommunityAccountResolver(registry);
    }

    public Ivorn resolve(Ivorn ivorn) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException, CommunityResolverException, RegistryException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityAccountSpaceResolver.resolve()");
        log.debug((Object)("  Ivorn : " + ivorn));
        if (null == ivorn) {
            throw new CommunityIdentifierException("Null identifier");
        }
        return this.resolve(new CommunityIvornParser(ivorn));
    }

    protected Ivorn resolve(CommunityIvornParser parser) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException, CommunityResolverException, RegistryException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityAccountSpaceResolver.resolve()");
        log.debug((Object)("  Ivorn : " + (null != parser ? parser.getIvorn() : null)));
        if (null == parser) {
            throw new CommunityIdentifierException("Null identifier");
        }
        AccountData account = this.resolver.resolve(parser);
        log.debug((Object)"CommunityAccountSpaceResolver.resolve()");
        log.debug((Object)"Got Account");
        log.debug((Object)("Account : " + account.getIdent()));
        log.debug((Object)("Home    : " + account.getHomeSpace()));
        String home = account.getHomeSpace();
        if (null != home) {
            log.debug((Object)"PASS : Got Account home.");
            log.debug((Object)"Building new Ivorn based on Account home");
            log.debug((Object)("  Home : " + home));
            log.debug((Object)("  Path : " + parser.getRemainder()));
            try {
                return new Ivorn(home + parser.getRemainder());
            }
            catch (URISyntaxException ouch) {
                throw new CommunityIdentifierException("Unable to parse Account home into an Ivorn", ouch);
            }
        }
        throw new CommunityResolverException("Account does not have a home space defined", parser.getIvorn());
    }
}

