/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.ivorn.CommunityServiceIvornFactory;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.config.Config;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.registry.client.RegistryDelegateFactory;
import org.astrogrid.registry.client.query.RegistryService;
import org.astrogrid.registry.client.query.ServiceData;
import org.astrogrid.registry.common.CommunityInterfaceType;
import org.astrogrid.registry.common.InterfaceType;
import org.astrogrid.store.Ivorn;

public class CommunityEndpointResolver {
    private static Log log = LogFactory.getLog((Class)CommunityEndpointResolver.class);
    protected static Config conf = SimpleConfig.getSingleton();
    private static RegistryDelegateFactory factory = new RegistryDelegateFactory();
    private RegistryService registry;

    public CommunityEndpointResolver() {
        this.registry = factory.createQuery();
    }

    public CommunityEndpointResolver(URL registry) {
        this.registry = RegistryDelegateFactory.createQuery((URL)registry);
    }

    public URL resolve(Ivorn ivorn, Class type) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityEndpointResolver.resolve()");
        log.debug((Object)("  Ivorn : " + ivorn));
        log.debug((Object)("  Type  : " + type));
        if (null == ivorn) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (null == type) {
            throw new CommunityIdentifierException("Null service type");
        }
        return this.resolve(new CommunityIvornParser(ivorn), type);
    }

    public URL resolve(CommunityIvornParser parser, Class type) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityEndpointResolver.resolve()");
        log.debug((Object)("  Ivorn : " + (null != parser ? parser.getIvorn() : null)));
        log.debug((Object)("  Type  : " + type));
        if (null == parser) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (null == type) {
            throw new CommunityIdentifierException("Null service type");
        }
        if (null == parser.getCommunityIdent()) {
            throw new CommunityIdentifierException("Null community identifier");
        }
        Ivorn ivorn = CommunityServiceIvornFactory.createIvorn((String)parser.getCommunityIdent(), (Class)type);
        log.debug((Object)"PASS : Got service Ivorn");
        log.debug((Object)("  Ivorn    : " + ivorn));
        String endpoint = null;
        try {
            endpoint = this.registry.getEndPointByIdentifier(ivorn.getPath());
        }
        catch (Throwable ouch) {
            log.debug((Object)"FAIL : Registry lookup failed");
            throw new CommunityResolverException("Registry lookup failed", ouch);
        }
        if (null != endpoint) {
            log.debug((Object)"PASS : Got service endpoint");
            log.debug((Object)("  Endpoint : " + endpoint));
            try {
                return new URL(endpoint);
            }
            catch (MalformedURLException ouch) {
                throw new CommunityResolverException("Unable to parse Registry response into endpoint URL", ivorn);
            }
        }
        throw new CommunityResolverException("Registry returned null endpoint address for ivorn", ivorn);
    }

    public ServiceData[] resolve() throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityEndpointResolver.resolve()");
        ServiceData[] sd = null;
        try {
            sd = this.registry.getResourcesByInterfaceType((InterfaceType)new CommunityInterfaceType());
        }
        catch (Throwable ouch) {
            log.debug((Object)"FAIL : Registry lookup failed");
            throw new CommunityResolverException("Registry lookup failed", ouch);
        }
        if (null != sd && sd.length > 0) {
            log.debug((Object)"PASS : Got service endpoints");
            return sd;
        }
        throw new CommunityResolverException("Registry returned no endpoints address for communities");
    }
}

