/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.client.security.service.SecurityServiceDelegate;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunitySecurityException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.community.resolver.security.service.SecurityServiceResolver;
import org.astrogrid.registry.RegistryException;

public class CommunityTokenResolver {
    private static Log log = LogFactory.getLog((Class)CommunityTokenResolver.class);
    private SecurityServiceResolver resolver;

    public CommunityTokenResolver() {
        this.resolver = new SecurityServiceResolver();
    }

    public CommunityTokenResolver(URL registry) {
        this.resolver = new SecurityServiceResolver(registry);
    }

    public SecurityToken checkToken(SecurityToken token) throws RegistryException, CommunityResolverException, CommunityServiceException, CommunitySecurityException, CommunityIdentifierException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityTokenResolver.checkToken()");
        log.debug((Object)("  Token : " + token));
        if (null == token) {
            throw new CommunityIdentifierException("Null token");
        }
        if (null == token.getToken()) {
            throw new CommunityIdentifierException("Null token value");
        }
        CommunityIvornParser parser = new CommunityIvornParser(token.getToken());
        SecurityServiceDelegate delegate = this.resolver.resolve(parser);
        return delegate.checkToken(token);
    }

    public Object[] splitToken(SecurityToken token, int count) throws RegistryException, CommunityResolverException, CommunityServiceException, CommunitySecurityException, CommunityIdentifierException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityTokenResolver.splitToken()");
        log.debug((Object)("  Token : " + token));
        if (null == token) {
            throw new CommunityIdentifierException("Null token");
        }
        if (null == token.getToken()) {
            throw new CommunityIdentifierException("Null token value");
        }
        CommunityIvornParser parser = new CommunityIvornParser(token.getToken());
        SecurityServiceDelegate delegate = this.resolver.resolve(parser);
        return delegate.splitToken(token, count);
    }
}

