/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver.ant;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.config.Config;
import org.astrogrid.config.SimpleConfig;

public class CommunityResolverTask
extends Task {
    private static final boolean DEBUG_FLAG = true;
    public static final String TOKEN_PROPERTY = "org.astrogrid.community.token";
    protected static Config config = SimpleConfig.getSingleton();
    private String registry;
    private String properties;

    public CommunityResolverTask() {
    }

    public CommunityResolverTask(Task parent) {
        this.setProject(parent.getProject());
    }

    public void init() throws BuildException {
        System.out.println("----\"----");
        System.out.println("CommunityResolverTask.init()");
        System.out.println("  Token : " + this.getToken());
    }

    protected SecurityToken getToken() {
        String string;
        if (null != this.getProject() && null != (string = this.getProject().getProperty(TOKEN_PROPERTY))) {
            return new SecurityToken(string);
        }
        return null;
    }

    protected void setToken(SecurityToken token) {
        if (null != this.getProject()) {
            this.getProject().setProperty(TOKEN_PROPERTY, token.toString());
        }
    }

    public void setRegistry(String value) {
        this.registry = value;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String value) {
        this.properties = value;
    }

    public void configure() throws BuildException {
        System.out.println("----\"----");
        System.out.println("CommunityResolverTask.configure()");
        if (null != this.properties) {
            try {
                System.out.println("  Properties  : " + this.properties);
                Properties map = new Properties();
                map.load(new FileInputStream(this.properties));
                Enumeration<Object> enumeration = map.keys();
                while (enumeration.hasMoreElements()) {
                    System.out.println("----");
                    String name = (String)enumeration.nextElement();
                    System.out.println("  Name  : " + name);
                    String value = map.getProperty(name);
                    System.out.println("  Value : " + value);
                    if (null != this.getProject()) {
                        value = this.getProject().replaceProperties(value);
                    }
                    System.out.println("  Value : " + value);
                    config.setProperty(name, (Object)value);
                    System.out.println("----");
                }
            }
            catch (Exception ouch) {
                throw new BuildException((Throwable)ouch);
            }
        }
    }

    public void execute() throws BuildException {
        System.out.println("----\"----");
        System.out.println("CommunityResolverTask.execute()");
        System.out.println("  Registry   : " + this.registry);
        System.out.println("  Properties : " + this.properties);
        this.configure();
    }
}

