/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver.policy.manager;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.client.policy.manager.PolicyManagerDelegate;
import org.astrogrid.community.client.policy.manager.PolicyManagerMockDelegate;
import org.astrogrid.community.client.policy.manager.PolicyManagerSoapDelegate;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.policy.manager.PolicyManager;
import org.astrogrid.community.resolver.CommunityEndpointResolver;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.registry.client.query.ServiceData;
import org.astrogrid.store.Ivorn;

public class PolicyManagerResolver {
    private static Log log = LogFactory.getLog((Class)PolicyManagerResolver.class);
    private CommunityEndpointResolver resolver;

    public PolicyManagerResolver() {
        this.resolver = new CommunityEndpointResolver();
    }

    public PolicyManagerResolver(URL registry) {
        this.resolver = new CommunityEndpointResolver(registry);
    }

    public PolicyManagerDelegate resolve(Ivorn ivorn) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"PolicyManagerResolverImpl.resolve()");
        log.debug((Object)("  Ivorn : " + (null != ivorn ? ivorn : null)));
        if (null == ivorn) {
            throw new CommunityIdentifierException("Null identifier");
        }
        return this.resolve(new CommunityIvornParser(ivorn));
    }

    public ServiceData[] resolve() throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"PolicyManagerResolverImpl.resolve()");
        return this.resolver.resolve();
    }

    public PolicyManagerDelegate resolve(CommunityIvornParser parser) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"PolicyManagerResolverImpl.resolve(parser)");
        log.debug((Object)("  Ivorn : " + (null != parser ? parser.getIvorn() : null)));
        if (null == parser) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (parser.isMock()) {
            log.debug((Object)"Ivorn is mock.");
            log.debug((Object)"Creating mock delegate.");
            return new PolicyManagerMockDelegate();
        }
        log.debug((Object)"Ivorn is real.");
        log.debug((Object)"Resolving endpoint URL.");
        URL endpoint = this.resolver.resolve(parser, PolicyManager.class);
        log.debug((Object)"PASS : Got endpoint url");
        log.debug((Object)("  URL : " + endpoint));
        log.debug((Object)"Creating SOAP delegate.");
        return this.resolve(endpoint);
    }

    protected PolicyManagerDelegate resolve(URL url) {
        return new PolicyManagerSoapDelegate(url);
    }
}

