/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver.policy.service;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.client.policy.service.PolicyServiceDelegate;
import org.astrogrid.community.client.policy.service.PolicyServiceMockDelegate;
import org.astrogrid.community.client.policy.service.PolicyServiceSoapDelegate;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.policy.service.PolicyService;
import org.astrogrid.community.resolver.CommunityEndpointResolver;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.store.Ivorn;

public class PolicyServiceResolver {
    private static Log log = LogFactory.getLog((Class)PolicyServiceResolver.class);
    private CommunityEndpointResolver resolver;

    public PolicyServiceResolver() {
        this.resolver = new CommunityEndpointResolver();
    }

    public PolicyServiceResolver(URL registry) {
        this.resolver = new CommunityEndpointResolver(registry);
    }

    public PolicyServiceDelegate resolve(Ivorn ivorn) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"PolicyServiceResolverImpl.resolve()");
        log.debug((Object)("  Ivorn : " + (null != ivorn ? ivorn : null)));
        if (null == ivorn) {
            throw new CommunityIdentifierException("Null identifier");
        }
        return this.resolve(new CommunityIvornParser(ivorn));
    }

    public PolicyServiceDelegate resolve(CommunityIvornParser parser) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"PolicyServiceResolverImpl.resolve()");
        log.debug((Object)("  Ivorn : " + (null != parser ? parser.getIvorn() : null)));
        if (null == parser) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (parser.isMock()) {
            log.debug((Object)"Ivorn is mock.");
            log.debug((Object)"Creating mock delegate.");
            return new PolicyServiceMockDelegate();
        }
        log.debug((Object)"Ivorn is real.");
        log.debug((Object)"Resolving endpoint URL.");
        URL endpoint = this.resolver.resolve(parser, PolicyService.class);
        log.debug((Object)"PASS : Got endpoint url");
        log.debug((Object)("  URL : " + endpoint));
        log.debug((Object)"Creating SOAP delegate.");
        return this.resolve(endpoint);
    }

    protected PolicyServiceDelegate resolve(URL url) {
        return new PolicyServiceSoapDelegate(url);
    }
}

