/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.resolver.security.manager;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.client.security.manager.SecurityManagerDelegate;
import org.astrogrid.community.client.security.manager.SecurityManagerMockDelegate;
import org.astrogrid.community.client.security.manager.SecurityManagerSoapDelegate;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.security.manager.SecurityManager;
import org.astrogrid.community.resolver.CommunityEndpointResolver;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.store.Ivorn;

public class SecurityManagerResolver {
    private static Log log = LogFactory.getLog((Class)SecurityManagerResolver.class);
    private CommunityEndpointResolver resolver;

    public SecurityManagerResolver() {
        this.resolver = new CommunityEndpointResolver();
    }

    public SecurityManagerResolver(URL registry) {
        this.resolver = new CommunityEndpointResolver(registry);
    }

    public SecurityManagerDelegate resolve(Ivorn ivorn) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityManagerResolverImpl.resolve()");
        log.debug((Object)("  Ivorn : " + (null != ivorn ? ivorn : null)));
        if (null == ivorn) {
            throw new CommunityIdentifierException("Null identifier");
        }
        return this.resolve(new CommunityIvornParser(ivorn));
    }

    public SecurityManagerDelegate resolve(CommunityIvornParser parser) throws RegistryException, CommunityIdentifierException, CommunityResolverException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityManagerResolverImpl.resolve()");
        log.debug((Object)("  Ivorn : " + (null != parser ? parser.getIvorn() : null)));
        if (null == parser) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (parser.isMock()) {
            log.debug((Object)"Ivorn is mock.");
            log.debug((Object)"Creating mock delegate.");
            return new SecurityManagerMockDelegate();
        }
        log.debug((Object)"Ivorn is real.");
        log.debug((Object)"Resolving endpoint URL.");
        URL endpoint = this.resolver.resolve(parser, SecurityManager.class);
        log.debug((Object)"PASS : Got endpoint url");
        log.debug((Object)("  URL : " + endpoint));
        log.debug((Object)"Creating SOAP delegate.");
        return this.resolve(endpoint);
    }

    protected SecurityManagerDelegate resolve(URL url) {
        return new SecurityManagerSoapDelegate(url);
    }
}

