/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsHeap;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableData;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;
import nom.tam.util.Cursor;
import nom.tam.util.RandomAccess;
import nom.tam.util.TableException;

public class BinaryTable
extends Data
implements TableData {
    FitsHeap heap;
    int heapOffset;
    int[] sizes;
    int[][] dimens;
    int[] flags;
    static final int COL_CONSTANT = 0;
    static final int COL_VARYING = 1;
    static final int COL_COMPLEX = 2;
    static final int COL_STRING = 4;
    static final int COL_BOOLEAN = 8;
    static final int COL_BIT = 16;
    int nRow;
    int nCol;
    int rowLen;
    int[] colOffsets;
    Class[] bases;
    Object[] modelRow;
    Object[] columns;
    ColumnTable table;
    ArrayDataInput currInput;
    static /* synthetic */ Class class$java$lang$String;

    public BinaryTable() throws FitsException {
        try {
            this.table = new ColumnTable(new Object[0], new int[0]);
        }
        catch (TableException e) {
            System.err.println("Impossible exception in BinaryTable() constructor" + e);
        }
        this.heap = new FitsHeap(0);
        this.extendArrays(0);
        this.nRow = 0;
        this.nCol = 0;
        this.rowLen = 0;
    }

    public BinaryTable(Header myHeader) throws FitsException {
        int heapSize = myHeader.getIntValue("PCOUNT");
        this.heapOffset = myHeader.getIntValue("THEAP");
        this.nRow = myHeader.getIntValue("NAXIS2");
        int rwsz = myHeader.getIntValue("NAXIS1");
        if (this.heapOffset > 0) {
            this.heapOffset -= this.nRow * rwsz;
        }
        if (this.heapOffset > heapSize) {
            throw new FitsException("Inconsistent THEAP and PCOUNT");
        }
        this.heap = new FitsHeap(heapSize - this.heapOffset);
        this.nCol = myHeader.getIntValue("TFIELDS");
        this.rowLen = 0;
        this.extendArrays(this.nCol);
        int col = 0;
        while (col < this.nCol) {
            this.colOffsets[col] = this.rowLen;
            this.rowLen += this.processCol(myHeader, col);
            ++col;
        }
    }

    private int processCol(Header header, int col) throws FitsException {
        char type;
        String tform = header.getStringValue("TFORM" + (col + 1)).trim();
        String tdims = header.getStringValue("TDIM" + (col + 1));
        if (tform == null) {
            throw new FitsException("No TFORM for column:" + col);
        }
        if (tdims != null) {
            tdims = tdims.trim();
        }
        if ((type = this.getTformType(tform)) == 'P') {
            int n = col;
            this.flags[n] = this.flags[n] | 1;
            type = this.getTformVarType(tform);
        }
        int size = this.getTformLength(tform);
        if (type == 'X') {
            size = (size + 7) / 8;
            int n = col;
            this.flags[n] = this.flags[n] | 0x10;
        } else if ((this.flags[col] & 1) != 0) {
            size = 2;
        }
        int bSize = size;
        int[] dims = null;
        if (tdims != null && type != 'X' && (this.flags[col] & 1) == 0) {
            dims = BinaryTable.getTDims(tdims);
        }
        if (dims == null) {
            dims = new int[]{size};
        }
        if (type == 'C' || type == 'M') {
            int n = col;
            this.flags[n] = this.flags[n] | 2;
        }
        Class<Number> colBase = null;
        switch (type) {
            case 'A': {
                colBase = Byte.TYPE;
                int n = col;
                this.flags[n] = this.flags[n] | 4;
                this.bases[col] = class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 'L': {
                colBase = Byte.TYPE;
                this.bases[col] = Boolean.TYPE;
                int n = col;
                this.flags[n] = this.flags[n] | 8;
                break;
            }
            case 'B': 
            case 'X': {
                colBase = Byte.TYPE;
                this.bases[col] = Byte.TYPE;
                break;
            }
            case 'I': {
                colBase = Short.TYPE;
                this.bases[col] = Short.TYPE;
                bSize *= 2;
                break;
            }
            case 'J': {
                colBase = Integer.TYPE;
                this.bases[col] = Integer.TYPE;
                bSize *= 4;
                break;
            }
            case 'K': {
                colBase = Long.TYPE;
                this.bases[col] = Long.TYPE;
                bSize *= 8;
                break;
            }
            case 'C': 
            case 'E': {
                colBase = Float.TYPE;
                this.bases[col] = Float.TYPE;
                bSize *= 4;
                break;
            }
            case 'D': 
            case 'M': {
                colBase = Double.TYPE;
                this.bases[col] = Double.TYPE;
                bSize *= 8;
                break;
            }
            default: {
                throw new FitsException("Invalid type in column:" + col);
            }
        }
        if ((this.flags[col] & 1) != 0) {
            dims = new int[]{this.nRow, 2};
            colBase = Integer.TYPE;
            bSize = 8;
        } else if ((this.flags[col] & 2) != 0) {
            int[] xdims = new int[dims.length + 1];
            System.arraycopy(dims, 0, xdims, 0, dims.length);
            xdims[dims.length] = 2;
            dims = xdims;
        }
        this.modelRow[col] = ArrayFuncs.newInstance(colBase, dims);
        this.dimens[col] = dims;
        this.sizes[col] = size;
        return bSize;
    }

    private char getTformType(String tform) {
        int i = 0;
        while (i < tform.length()) {
            if (!Character.isDigit(tform.charAt(i))) {
                return tform.charAt(i);
            }
            ++i;
        }
        return '\u0000';
    }

    private char getTformVarType(String tform) {
        int ind = tform.indexOf("P");
        if (tform.length() > ind + 1) {
            return tform.charAt(ind + 1);
        }
        return '\u0000';
    }

    private int getTformLength(String tform) {
        if (Character.isDigit(tform.charAt(0))) {
            return this.initialNumber(tform);
        }
        String xform = tform.substring(1).trim();
        if (xform.length() == 0) {
            return 1;
        }
        if (Character.isDigit(xform.charAt(0))) {
            return this.initialNumber(xform);
        }
        return 1;
    }

    private int initialNumber(String tform) {
        int i = 0;
        while (i < tform.length()) {
            if (!Character.isDigit(tform.charAt(i))) break;
            ++i;
        }
        return Integer.parseInt(tform.substring(0, i));
    }

    public static int[] getTDims(String tdims) {
        StringTokenizer st;
        int dim;
        int[] dims = null;
        int first = tdims.indexOf(40);
        int last = tdims.lastIndexOf(41);
        if (first >= 0 && last > 0 && first < last && (dim = (st = new StringTokenizer(tdims = tdims.substring(first + 1, last - first), ",")).countTokens()) > 0) {
            dims = new int[dim];
            int i = dim - 1;
            while (i >= 0) {
                dims[i] = Integer.parseInt(st.nextToken().trim());
                --i;
            }
        }
        return dims;
    }

    public void fillHeader(Header h) throws FitsException {
        try {
            h.setXtension("BINTABLE");
            h.setBitpix(8);
            h.setNaxes(2);
            h.setNaxis(1, this.rowLen);
            h.setNaxis(2, this.nRow);
            h.addValue("PCOUNT", this.heap.size(), (String)null);
            h.addValue("GCOUNT", 1L, (String)null);
            Cursor iter = h.iterator();
            iter.setKey("GCOUNT");
            iter.next();
            iter.add("TFIELDS", new HeaderCard("TFIELDS", this.modelRow.length, null));
            iter.add("THEAP", new HeaderCard("THEAP", 0, null));
            int i = 0;
            while (i < this.modelRow.length) {
                if (i > 0) {
                    h.positionAfterIndex("TFORM", i);
                }
                this.fillForColumn(h, i, iter);
                ++i;
            }
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception");
        }
    }

    void pointToColumn(int col, Header hdr) throws FitsException {
        Cursor iter = hdr.iterator();
        if (col > 0) {
            hdr.positionAfterIndex("TFORM", col);
        }
        this.fillForColumn(hdr, col, iter);
    }

    void fillForColumn(Header h, int col, Cursor iter) throws FitsException {
        String tform = (this.flags[col] & 1) != 0 ? "1P" : "" + this.sizes[col];
        if (this.bases[col] == Integer.TYPE) {
            tform = tform + "J";
        } else if (this.bases[col] == Short.TYPE || this.bases[col] == Character.TYPE) {
            tform = tform + "I";
        } else if (this.bases[col] == Byte.TYPE) {
            tform = tform + "B";
        } else if (this.bases[col] == Float.TYPE) {
            tform = tform + "E";
        } else if (this.bases[col] == Double.TYPE) {
            tform = tform + "D";
        } else if (this.bases[col] == Long.TYPE) {
            tform = tform + "K";
        } else if (this.bases[col] == Boolean.TYPE) {
            tform = tform + "L";
        } else if (this.bases[col] == (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
            tform = tform + "A";
        } else {
            throw new FitsException("Invalid column data class:" + this.bases[col]);
        }
        String key = "TFORM" + (col + 1);
        iter.add(key, new HeaderCard(key, tform, null));
        if (this.dimens[col].length > 0 && (this.flags[col] & 1) == 0) {
            StringBuffer tdim = new StringBuffer();
            int comma = 40;
            int i = this.dimens[col].length - 1;
            while (i >= 0) {
                tdim.append((char)comma);
                tdim.append(this.dimens[col][i]);
                comma = 44;
                --i;
            }
            tdim.append(')');
            key = "TDIM" + (col + 1);
            iter.add(key, new HeaderCard(key, new String(tdim), null));
        }
    }

    private ColumnTable createTable() throws FitsException {
        ColumnTable table;
        int nfields = this.modelRow.length;
        Object[] arrCol = new Object[nfields];
        int i = 0;
        while (i < nfields) {
            arrCol[i] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(this.modelRow[i]), this.sizes[i] * this.nRow);
            ++i;
        }
        try {
            table = new ColumnTable(arrCol, this.sizes);
        }
        catch (TableException e) {
            throw new FitsException("Unable to create table:" + e);
        }
        return table;
    }

    public BinaryTable(Object[][] data) throws FitsException {
        this(BinaryTable.convertToColumns(data));
    }

    private static Object[] convertToColumns(Object[][] data) {
        Object[] row = data[0];
        int nrow = data.length;
        Object[] results = new Object[row.length];
        int col = 0;
        while (col < row.length) {
            if (row[col] instanceof String) {
                String[] sa = new String[nrow];
                int irow = 0;
                while (irow < nrow) {
                    sa[irow] = (String)data[irow][col];
                    ++irow;
                }
                results[col] = sa;
            } else {
                Class base = ArrayFuncs.getBaseClass(row[col]);
                int[] dims = ArrayFuncs.getDimensions(row[col]);
                if (dims.length > 1 || dims[0] > 1) {
                    int[] xdims = new int[dims.length + 1];
                    xdims[0] = nrow;
                    Object[] arr = (Object[])ArrayFuncs.newInstance(base, xdims);
                    int irow = 0;
                    while (irow < nrow) {
                        arr[irow] = data[irow][col];
                        ++irow;
                    }
                    results[col] = arr;
                } else {
                    Object arr = ArrayFuncs.newInstance(base, nrow);
                    int irow = 0;
                    while (irow < nrow) {
                        System.arraycopy(data[irow][col], 0, arr, irow, 1);
                        ++irow;
                    }
                    results[col] = arr;
                }
            }
            ++col;
        }
        return results;
    }

    public BinaryTable(Object[] o) throws FitsException {
        this.heap = new FitsHeap(0);
        this.modelRow = new Object[o.length];
        this.extendArrays(o.length);
        int i = 0;
        while (i < o.length) {
            this.addColumn(o[i]);
            ++i;
        }
    }

    public BinaryTable(ColumnTable tab) {
        this.nCol = tab.getNCols();
        this.extendArrays(this.nCol);
        this.bases = tab.getBases();
        this.sizes = tab.getSizes();
        this.modelRow = new Object[this.nCol];
        this.dimens = new int[this.nCol][1];
        this.flags = new int[this.nCol];
        int col = 0;
        while (col < this.nCol) {
            this.dimens[col][0] = this.sizes[col];
            ++col;
        }
        int col2 = 0;
        while (col2 < this.nCol) {
            this.modelRow[col2] = ArrayFuncs.newInstance(this.bases[col2], this.sizes[col2]);
            ++col2;
        }
        this.columns = null;
        this.table = tab;
    }

    public Object[] getRow(int row) throws FitsException {
        if (!this.validRow(row)) {
            throw new FitsException("Invalid row");
        }
        Object[] res = this.table != null ? this.getMemoryRow(row) : this.getFileRow(row);
        return res;
    }

    private Object[] getMemoryRow(int row) throws FitsException {
        Object[] data = new Object[this.modelRow.length];
        int col = 0;
        while (col < this.modelRow.length) {
            Object o = this.table.getElement(row, col);
            o = this.columnToArray(col, o);
            data[col] = this.encurl(o, col, 1);
            if (data[col] instanceof Object[]) {
                data[col] = ((Object[])data[col])[0];
            }
            ++col;
        }
        return data;
    }

    private Object[] getFileRow(int row) throws FitsException {
        Object[] data = new Object[this.nCol];
        int col = 0;
        while (col < data.length) {
            data[col] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(this.modelRow[col]), this.sizes[col]);
            ++col;
        }
        try {
            FitsUtil.reposition(this.currInput, this.fileOffset + (long)(row * this.rowLen));
            this.currInput.readArray(data);
        }
        catch (IOException e) {
            throw new FitsException("Error in deferred row read");
        }
        int col2 = 0;
        while (col2 < data.length) {
            data[col2] = this.columnToArray(col2, data[col2]);
            data[col2] = this.encurl(data[col2], col2, 1);
            if (data[col2] instanceof Object[]) {
                data[col2] = ((Object[])data[col2])[0];
            }
            ++col2;
        }
        return data;
    }

    private Object getFileElement(int row, int col) throws FitsException {
        Object cell = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(this.modelRow[col]), this.sizes[col]);
        try {
            FitsUtil.reposition(this.currInput, this.fileOffset + (long)(row * this.rowLen) + (long)this.colOffsets[col]);
            this.currInput.readArray(cell);
        }
        catch (IOException e) {
            throw new FitsException("Error in deferred row read");
        }
        cell = this.columnToArray(col, cell);
        cell = this.encurl(cell, col, 1);
        if (cell instanceof Object[]) {
            cell = ((Object[])cell)[0];
        }
        return cell;
    }

    public void setRow(int row, Object[] data) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (data.length != this.getNCols()) {
            throw new FitsException("Updated row size does not agree with table");
        }
        Object[] ydata = new Object[data.length];
        int col = 0;
        while (col < data.length) {
            Object o = ArrayFuncs.flatten(data[col]);
            ydata[col] = this.arrayToColumn(col, o);
            ++col;
        }
        try {
            this.table.setRow(row, ydata);
        }
        catch (TableException e) {
            throw new FitsException("Error modifying table: " + e);
        }
    }

    public void setColumn(int col, Object xcol) throws FitsException {
        xcol = ArrayFuncs.flatten(xcol);
        xcol = this.arrayToColumn(col, xcol);
        this.setFlattenedColumn(col, xcol);
    }

    public void setFlattenedColumn(int col, Object data) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        data = this.arrayToColumn(col, data);
        Object oldCol = this.table.getColumn(col);
        if (data.getClass() != oldCol.getClass() || Array.getLength(data) != Array.getLength(oldCol)) {
            throw new FitsException("Replacement column mismatch at column:" + col);
        }
        try {
            this.table.setColumn(col, data);
        }
        catch (TableException e) {
            throw new FitsException("Unable to set column:" + col + " error:" + e);
        }
    }

    public Object getColumn(int col) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        Object res = this.getFlattenedColumn(col);
        return this.encurl(res, col, this.nRow);
    }

    private Object encurl(Object res, int col, int rows) {
        if (this.bases[col] != (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
            if ((this.flags[col] & 1) == 0 && (this.dimens[col].length > 1 || this.dimens[col][0] != 1)) {
                int[] dims = new int[this.dimens[col].length + 1];
                System.arraycopy(this.dimens[col], 0, dims, 1, this.dimens[col].length);
                dims[0] = rows;
                res = ArrayFuncs.curl(res, dims);
            }
        } else if (this.dimens[col].length > 2) {
            int[] dims = new int[this.dimens[col].length];
            System.arraycopy(this.dimens[col], 0, dims, 1, this.dimens[col].length - 1);
            dims[0] = rows;
            res = ArrayFuncs.curl(res, dims);
        }
        return res;
    }

    public Object getFlattenedColumn(int col) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (!this.validColumn(col)) {
            throw new FitsException("Invalid column");
        }
        return this.columnToArray(col, this.table.getColumn(col));
    }

    public Object getElement(int i, int j) throws FitsException {
        Object ele;
        if (!this.validRow(i) || !this.validColumn(j)) {
            throw new FitsException("No such element");
        }
        if (this.table == null) {
            ele = this.getFileElement(i, j);
        } else {
            ele = this.table.getElement(i, j);
            ele = this.columnToArray(j, ele);
            if ((ele = this.encurl(ele, j, 1)) instanceof Object[]) {
                ele = ((Object[])ele)[0];
            }
        }
        return ele;
    }

    public int addRow(Object[] o) throws FitsException {
        if (this.table == null) {
            this.getData();
        }
        if (this.nCol == 0 && this.nRow == 0) {
            int i = 0;
            while (i < o.length) {
                this.addColumn(o);
                ++i;
            }
        } else {
            Object[] flatRow = new Object[this.getNCols()];
            int i = 0;
            while (i < this.getNCols()) {
                Object x = ArrayFuncs.flatten(o[i]);
                flatRow[i] = this.arrayToColumn(i, x);
                ++i;
            }
            try {
                this.table.addRow(flatRow);
            }
            catch (TableException e) {
                throw new FitsException("Error add row to table");
            }
            ++this.nRow;
        }
        return this.nRow;
    }

    public int addColumn(Object o) throws FitsException {
        this.extendArrays(this.nCol + 1);
        Class base = ArrayFuncs.getBaseClass(o);
        if (this.isVarying(o)) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 1;
            this.dimens[this.nCol] = new int[]{2};
        }
        if ((this.flags[this.nCol] & 1) == 0) {
            int[] allDim = ArrayFuncs.getDimensions(o);
            if (base == (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
                int[] xdim = new int[allDim.length + 1];
                System.arraycopy(allDim, 0, xdim, 0, allDim.length);
                xdim[allDim.length] = -1;
                allDim = xdim;
            }
            if (allDim.length == 1) {
                this.dimens[this.nCol] = new int[]{1};
            } else {
                this.dimens[this.nCol] = new int[allDim.length - 1];
                System.arraycopy(allDim, 1, this.dimens[this.nCol], 0, allDim.length - 1);
                o = ArrayFuncs.flatten(o);
            }
        }
        this.addFlattenedColumn(o, this.dimens[this.nCol]);
        return this.getNCols();
    }

    private boolean isVarying(Object o) {
        String classname = o.getClass().getName();
        if (classname.length() != 3 || classname.charAt(0) != '[' || classname.charAt(1) != '[') {
            return false;
        }
        Object[] ox = (Object[])o;
        if (ox.length < 2) {
            return false;
        }
        int flen = Array.getLength(ox[0]);
        int i = 1;
        while (i < ox.length) {
            if (Array.getLength(ox[i]) != flen) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int addFlattenedColumn(Object o, int[] dims) throws FitsException {
        this.extendArrays(this.nCol + 1);
        this.bases[this.nCol] = ArrayFuncs.getBaseClass(o);
        if (this.bases[this.nCol] == Boolean.TYPE) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 8;
        } else if (this.bases[this.nCol] == (class$java$lang$String == null ? (class$java$lang$String = BinaryTable.class$("java.lang.String")) : class$java$lang$String)) {
            int n = this.nCol;
            this.flags[n] = this.flags[n] | 4;
        }
        o = this.arrayToColumn(this.nCol, o);
        int size = 1;
        int dim = 0;
        while (dim < dims.length) {
            size *= dims[dim];
            ++dim;
        }
        this.sizes[this.nCol] = size;
        int xRow = Array.getLength(o) / size;
        if (this.getNCols() == 0) {
            this.nRow = xRow;
        } else if (xRow > 0 && xRow != this.nRow) {
            throw new FitsException("Added column does not have correct row count");
        }
        if ((this.flags[this.nCol] & 1) == 0) {
            this.modelRow[this.nCol] = ArrayFuncs.newInstance(ArrayFuncs.getBaseClass(o), dims);
            this.rowLen += size * ArrayFuncs.getBaseLength(o);
        } else {
            this.modelRow[this.nCol] = new int[2];
            this.rowLen += 8;
        }
        this.columns[this.nCol] = o;
        try {
            if (this.table != null) {
                this.table.addColumn(o, this.sizes[this.nCol]);
            } else if (this.nCol == this.columns.length - 1) {
                this.table = new ColumnTable(this.columns, this.sizes);
            }
        }
        catch (TableException e) {
            throw new FitsException("Error in ColumnTable:" + e);
        }
        ++this.nCol;
        return this.nCol;
    }

    public int getNRows() {
        return this.nRow;
    }

    public int getNCols() {
        return this.nCol;
    }

    protected boolean validRow(int i) {
        return this.getNRows() > 0 && i >= 0 && i < this.getNRows();
    }

    protected boolean validColumn(int j) {
        return j >= 0 && j < this.getNCols();
    }

    public void setElement(int i, int j, Object o) throws FitsException {
        try {
            this.table.setElement(i, j, ArrayFuncs.flatten(o));
        }
        catch (TableException e) {
            throw new FitsException("Error modifying table:" + e);
        }
    }

    public void read(ArrayDataInput i) throws FitsException {
        this.setFileOffset(i);
        this.currInput = i;
        if (i instanceof RandomAccess) {
            try {
                i.skipBytes(this.getTrueSize());
                i.skipBytes(FitsUtil.padding(this.getTrueSize()));
            }
            catch (IOException e) {
                throw new FitsException("Unable to skip binary table HDU:" + e);
            }
        } else {
            if (this.table == null) {
                this.table = this.createTable();
            }
            this.readTrueData(i);
        }
    }

    protected void readTrueData(ArrayDataInput i) throws FitsException {
        try {
            int len = this.table.read(i);
            i.skipBytes(this.heapOffset);
            this.heap.read(i);
            i.skipBytes(FitsUtil.padding(this.getTrueSize()));
        }
        catch (IOException e) {
            throw new FitsException("Error reading binary table data:" + e);
        }
    }

    public int getTrueSize() {
        int len = this.nRow * this.rowLen;
        if (this.heap.size() > 0) {
            len += this.heap.size() + this.heapOffset;
        }
        return len;
    }

    public void write(ArrayDataOutput os) throws FitsException {
        if (this.table == null) {
            long currentOffset = FitsUtil.findOffset(os);
            this.getData();
            FitsUtil.reposition(os, currentOffset);
        }
        try {
            int len = this.table.write(os);
            if (this.heapOffset > 0) {
                os.write(new byte[this.heapOffset]);
            }
            if (this.heap.size() > 0) {
                this.heap.write(os);
            }
            os.write(new byte[FitsUtil.padding(this.getTrueSize())]);
        }
        catch (IOException e) {
            throw new FitsException("Unable to write table:" + e);
        }
    }

    public Object getData() throws FitsException {
        if (this.table == null) {
            if (this.currInput == null) {
                throw new FitsException("Cannot find input for deferred read");
            }
            this.table = this.createTable();
            long currentOffset = FitsUtil.findOffset(this.currInput);
            FitsUtil.reposition(this.currInput, this.fileOffset);
            this.readTrueData(this.input);
            FitsUtil.reposition(this.currInput, currentOffset);
        }
        return this.table;
    }

    public int[][] getDimens() {
        return this.dimens;
    }

    public Class[] getBases() {
        return this.table.getBases();
    }

    public char[] getTypes() {
        block2: {
            if (this.table != null) break block2;
            try {
                this.getData();
            }
            catch (FitsException e) {}
        }
        return this.table.getTypes();
    }

    public Object[] getFlatColumns() {
        block2: {
            if (this.table != null) break block2;
            try {
                this.getData();
            }
            catch (FitsException e) {}
        }
        return this.table.getColumns();
    }

    public int[] getSizes() {
        return this.sizes;
    }

    private Object arrayToColumn(int col, Object o) throws FitsException {
        if (this.flags[col] == 0) {
            return o;
        }
        if ((this.flags[col] & 1) == 0) {
            if ((this.flags[col] & 4) != 0) {
                int[] dims = this.dimens[col];
                if (dims[dims.length - 1] < 0) {
                    dims[dims.length - 1] = FitsUtil.maxLength((String[])o);
                }
                if (o instanceof String) {
                    o = new String[]{(String)o};
                }
                o = FitsUtil.stringsToByteArray((String[])o, dims[dims.length - 1]);
            } else if ((this.flags[col] & 8) != 0) {
                o = FitsUtil.booleanToByte((boolean[])o);
            }
        } else {
            if ((this.flags[col] & 8) != 0) {
                if (o instanceof boolean[]) {
                    o = new boolean[][]{(boolean[])o};
                }
                boolean[][] to = (boolean[][])o;
                byte[][] xo = new byte[to.length][];
                int i = 0;
                while (i < to.length) {
                    xo[i] = FitsUtil.booleanToByte(to[i]);
                    ++i;
                }
                o = xo;
            }
            int offset = this.heap.putData(o);
            int blen = ArrayFuncs.getBaseLength(o);
            if (!(o instanceof Object[])) {
                o = new Object[]{o};
            }
            int nrow = Array.getLength(o);
            int[] descrip = new int[2 * nrow];
            Object x = o;
            int i = 0;
            while (i < nrow) {
                descrip[2 * i] = Array.getLength(x[i]);
                descrip[2 * i + 1] = offset;
                offset += descrip[2 * i] * blen;
                if ((this.flags[col] & 2) != 0) {
                    int n = 2 * i;
                    descrip[n] = descrip[n] / 2;
                }
                ++i;
            }
            o = descrip;
        }
        return o;
    }

    private Object columnToArray(int col, Object o) throws FitsException {
        if (this.flags[col] == 0) {
            return o;
        }
        if ((this.flags[col] & 1) != 0) {
            Object[] res;
            int[] dims;
            int[] descrip = (int[])o;
            int nrow = descrip.length / 2;
            if ((this.flags[col] & 2) != 0) {
                dims = new int[]{nrow, 0, 0};
                res = (Object[])ArrayFuncs.newInstance(this.bases[col], dims);
                dims = new int[2];
                dims[1] = 2;
            } else {
                dims = new int[]{nrow, 0};
                res = (Object[])ArrayFuncs.newInstance(this.bases[col], dims);
            }
            int i = 0;
            while (i < nrow) {
                Object row;
                int offset = descrip[2 * i + 1];
                int dim = descrip[2 * i];
                if ((this.flags[col] & 2) != 0) {
                    dims[0] = dim;
                    row = ArrayFuncs.newInstance(this.bases[col], dims);
                } else {
                    row = (this.flags[col] & 8) != 0 ? ArrayFuncs.newInstance(Byte.TYPE, dim) : ArrayFuncs.newInstance(this.bases[col], dim);
                }
                this.heap.getData(offset, row);
                if ((this.flags[col] & 8) != 0) {
                    row = FitsUtil.byteToBoolean((byte[])row);
                }
                res[i] = row;
                ++i;
            }
            o = res;
        } else if ((this.flags[col] & 4) != 0) {
            int[] dims = this.dimens[col];
            o = FitsUtil.byteArrayToStrings((byte[])o, dims[dims.length - 1]);
        } else if ((this.flags[col] & 8) != 0) {
            o = FitsUtil.byteToBoolean((byte[])o);
        }
        return o;
    }

    private void extendArrays(int need) {
        boolean wasNull = false;
        if (this.sizes == null) {
            wasNull = true;
        } else if (this.sizes.length > need) {
            return;
        }
        int[] newSizes = new int[need];
        int[] newColOffsets = new int[need];
        int[][] newDimens = new int[need][];
        int[] newFlags = new int[need];
        Object[] newModel = new Object[need];
        Object[] newColumns = new Object[need];
        Class[] newBases = new Class[need];
        if (!wasNull) {
            int len = this.sizes.length;
            System.arraycopy(this.sizes, 0, newSizes, 0, len);
            System.arraycopy(this.colOffsets, 0, newColOffsets, 0, len);
            System.arraycopy(this.dimens, 0, newDimens, 0, len);
            System.arraycopy(this.flags, 0, newFlags, 0, len);
            System.arraycopy(this.modelRow, 0, newModel, 0, len);
            System.arraycopy(this.columns, 0, newColumns, 0, len);
            System.arraycopy(this.bases, 0, newBases, 0, len);
        }
        this.sizes = newSizes;
        this.colOffsets = newColOffsets;
        this.dimens = newDimens;
        this.flags = newFlags;
        this.modelRow = newModel;
        this.columns = newColumns;
        this.bases = newBases;
    }

    public int getHeapSize() {
        return this.heapOffset + this.heap.size();
    }

    public int getHeapOffset() {
        return this.heapOffset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

