/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.FitsException;
import nom.tam.util.RandomAccess;

public class FitsUtil {
    public static void reposition(Object o, long offset) throws FitsException {
        if (o == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(o instanceof RandomAccess) || offset < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + o + " of type " + o.getClass().getName() + " to " + offset);
        }
        try {
            ((RandomAccess)o).seek(offset);
        }
        catch (IOException e) {
            throw new FitsException("Unable to repostion stream " + o + " of type " + o.getClass().getName() + " to " + offset + "   Exception:" + e);
        }
    }

    public static long findOffset(Object o) {
        if (o instanceof RandomAccess) {
            return ((RandomAccess)o).getFilePointer();
        }
        return -1L;
    }

    public static int padding(int size) {
        int mod = size % 2880;
        if (mod > 0) {
            mod = 2880 - mod;
        }
        return mod;
    }

    public static int addPadding(int size) {
        return size + FitsUtil.padding(size);
    }

    public static boolean isCompressed(String filename) {
        int len = filename.length();
        return len > 2 && filename.substring(len - 3).equalsIgnoreCase(".gz");
    }

    public static int maxLength(String[] o) throws FitsException {
        int max = 0;
        int i = 0;
        while (i < o.length) {
            if (o != null && o[i].length() > max) {
                max = o[i].length();
            }
            ++i;
        }
        return max;
    }

    public static byte[] stringsToByteArray(String[] o, int maxLen) {
        byte[] res = new byte[o.length * maxLen];
        int i = 0;
        while (i < o.length) {
            byte[] bstr = o[i].getBytes();
            int cnt = bstr.length;
            if (cnt > maxLen) {
                cnt = maxLen;
            }
            System.arraycopy(bstr, 0, res, i * maxLen, cnt);
            int j = cnt;
            while (j < maxLen) {
                res[i * maxLen + j] = 32;
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static String[] byteArrayToStrings(byte[] o, int maxLen) {
        String[] res = new String[o.length / maxLen];
        int i = 0;
        while (i < res.length) {
            res[i] = new String(o, i * maxLen, maxLen).trim();
            ++i;
        }
        return res;
    }

    static byte[] booleanToByte(boolean[] bool) {
        byte[] byt = new byte[bool.length];
        int i = 0;
        while (i < bool.length) {
            byt[i] = bool[i] ? 84 : 70;
            ++i;
        }
        return byt;
    }

    static boolean[] byteToBoolean(byte[] byt) {
        boolean[] bool = new boolean[byt.length];
        int i = 0;
        while (i < byt.length) {
            bool[i] = byt[i] == 84;
            ++i;
        }
        return bool;
    }
}

