/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.DataTable;
import nom.tam.util.TableException;

public class ColumnTable
implements DataTable {
    private Object[] arrays;
    private int[] sizes;
    private int nrow;
    private int chunk;
    private int rowSize;
    private char[] types;
    private Class[] bases;
    private byte[][] bytePointers;
    private short[][] shortPointers;
    private int[][] intPointers;
    private long[][] longPointers;
    private float[][] floatPointers;
    private double[][] doublePointers;
    private char[][] charPointers;
    private boolean[][] booleanPointers;

    public ColumnTable(Object[] arrays, int[] sizes) throws TableException {
        this.setup(arrays, sizes);
    }

    protected void setup(Object[] arrays, int[] sizes) throws TableException {
        this.checkArrayConsistency(arrays, sizes);
        this.getNumberOfRows();
        this.initializePointers();
    }

    public int getNRows() {
        return this.nrow;
    }

    public int getNCols() {
        return this.arrays.length;
    }

    public Object getColumn(int col) {
        return this.arrays[col];
    }

    public void setColumn(int col, Object newColumn) throws TableException {
        boolean reset = newColumn.getClass() != this.arrays[col].getClass() || Array.getLength(newColumn) != Array.getLength(this.arrays[col]);
        this.arrays[col] = newColumn;
        if (reset) {
            this.setup(this.arrays, this.sizes);
        }
    }

    public void addColumn(Object newColumn, int size) throws TableException {
        String classname = newColumn.getClass().getName();
        this.nrow = this.checkColumnConsistency(newColumn, classname, this.nrow, size);
        this.rowSize += this.nrow * ArrayFuncs.getBaseLength(newColumn);
        this.getNumberOfRows();
        int ncol = this.arrays.length;
        Object[] newArrays = new Object[ncol + 1];
        int[] newSizes = new int[ncol + 1];
        Class[] newBases = new Class[ncol + 1];
        char[] newTypes = new char[ncol + 1];
        System.arraycopy(this.arrays, 0, newArrays, 0, ncol);
        System.arraycopy(this.sizes, 0, newSizes, 0, ncol);
        System.arraycopy(this.bases, 0, newBases, 0, ncol);
        System.arraycopy(this.types, 0, newTypes, 0, ncol);
        this.arrays = newArrays;
        this.sizes = newSizes;
        this.bases = newBases;
        this.types = newTypes;
        this.arrays[ncol] = newColumn;
        this.sizes[ncol] = size;
        this.bases[ncol] = ArrayFuncs.getBaseClass(newColumn);
        this.types[ncol] = classname.charAt(1);
        this.addPointer(newColumn);
    }

    public void addRow(Object[] row) throws TableException {
        if (this.arrays.length == 0) {
            int i = 0;
            while (i < row.length) {
                this.addColumn(row[i], Array.getLength(row[i]));
                ++i;
            }
        } else {
            if (row.length != this.arrays.length) {
                throw new TableException("Row length mismatch");
            }
            int i = 0;
            while (i < row.length) {
                if (row[i].getClass() != this.arrays[i].getClass() || Array.getLength(row[i]) != this.sizes[i]) {
                    throw new TableException("Row column mismatch at column:" + i);
                }
                Object xarray = ArrayFuncs.newInstance(this.bases[i], (this.nrow + 1) * this.sizes[i]);
                System.arraycopy(this.arrays[i], 0, xarray, 0, this.nrow * this.sizes[i]);
                System.arraycopy(row[i], 0, xarray, this.nrow * this.sizes[i], this.sizes[i]);
                this.arrays[i] = xarray;
                ++i;
            }
            this.initializePointers();
            ++this.nrow;
        }
    }

    public Object getElement(int row, int col) {
        Object x = ArrayFuncs.newInstance(this.bases[col], this.sizes[col]);
        System.arraycopy(this.arrays[col], this.sizes[col] * row, x, 0, this.sizes[col]);
        return x;
    }

    public void setElement(int row, int col, Object x) throws TableException {
        String classname = x.getClass().getName();
        if (!classname.equals("[" + this.types[col])) {
            throw new TableException("setElement: Incompatible element type");
        }
        if (Array.getLength(x) != this.sizes[col]) {
            throw new TableException("setElement: Incompatible element size");
        }
        System.arraycopy(x, 0, this.arrays[col], this.sizes[col] * row, this.sizes[col]);
    }

    public Object getRow(int row) {
        Object[] x = new Object[this.arrays.length];
        int col = 0;
        while (col < this.arrays.length) {
            x[col] = this.getElement(row, col);
            ++col;
        }
        return x;
    }

    public void setRow(int row, Object x) throws TableException {
        if (!(x instanceof Object[])) {
            throw new TableException("setRow: Incompatible row");
        }
        int col = 0;
        while (col < this.arrays.length) {
            this.setElement(row, col, ((Object[])x)[col]);
            ++col;
        }
    }

    protected void checkArrayConsistency(Object[] arrays, int[] sizes) throws TableException {
        if (arrays.length != sizes.length) {
            throw new TableException("readArraysAsColumns: Incompatible arrays and sizes.");
        }
        int ratio = 0;
        int rowSize = 0;
        this.types = new char[arrays.length];
        this.bases = new Class[arrays.length];
        boolean nullTable = true;
        int i = 0;
        while (i < arrays.length) {
            String classname = arrays[i].getClass().getName();
            ratio = this.checkColumnConsistency(arrays[i], classname, ratio, sizes[i]);
            rowSize += sizes[i] * ArrayFuncs.getBaseLength(arrays[i]);
            this.types[i] = classname.charAt(1);
            this.bases[i] = ArrayFuncs.getBaseClass(arrays[i]);
            ++i;
        }
        this.nrow = ratio;
        this.rowSize = rowSize;
        this.arrays = arrays;
        this.sizes = sizes;
    }

    private int checkColumnConsistency(Object data, String classname, int ratio, int size) throws TableException {
        if (classname.charAt(0) != '[' || classname.length() != 2) {
            throw new TableException("Non-primitive array for column");
        }
        int thisSize = Array.getLength(data);
        if (thisSize == 0 && size != 0 || thisSize != 0 && size == 0) {
            throw new TableException("Size mismatch in column");
        }
        if (thisSize % size != 0) {
            throw new TableException("Row size does not divide array for column");
        }
        int thisRatio = 0;
        if (size > 0) {
            thisRatio = thisSize / size;
            if (ratio != 0 && thisRatio != ratio) {
                throw new TableException("Different number of rows in different columns");
            }
        }
        if (thisRatio > 0) {
            return thisRatio;
        }
        return ratio;
    }

    protected void getNumberOfRows() {
        int bufSize = 65536;
        this.chunk = this.rowSize == 0 ? 0 : (this.rowSize > bufSize ? 1 : (bufSize / this.rowSize >= this.nrow ? this.nrow : bufSize / this.rowSize + 1));
    }

    protected void initializePointers() {
        int nbyte = 0;
        int nshort = 0;
        int nint = 0;
        int nlong = 0;
        int nfloat = 0;
        int ndouble = 0;
        int nchar = 0;
        int nboolean = 0;
        int col = 0;
        while (col < this.arrays.length) {
            switch (this.types[col]) {
                case 'B': {
                    ++nbyte;
                    break;
                }
                case 'S': {
                    ++nshort;
                    break;
                }
                case 'I': {
                    ++nint;
                    break;
                }
                case 'J': {
                    ++nlong;
                    break;
                }
                case 'F': {
                    ++nfloat;
                    break;
                }
                case 'D': {
                    ++ndouble;
                    break;
                }
                case 'C': {
                    ++nchar;
                    break;
                }
                case 'Z': {
                    ++nboolean;
                }
            }
            ++col;
        }
        this.bytePointers = new byte[nbyte][];
        this.shortPointers = new short[nshort][];
        this.intPointers = new int[nint][];
        this.longPointers = new long[nlong][];
        this.floatPointers = new float[nfloat][];
        this.doublePointers = new double[ndouble][];
        this.charPointers = new char[nchar][];
        this.booleanPointers = new boolean[nboolean][];
        nbyte = 0;
        nshort = 0;
        nint = 0;
        nlong = 0;
        nfloat = 0;
        ndouble = 0;
        nchar = 0;
        nboolean = 0;
        int col2 = 0;
        while (col2 < this.arrays.length) {
            switch (this.types[col2]) {
                case 'B': {
                    this.bytePointers[nbyte] = (byte[])this.arrays[col2];
                    ++nbyte;
                    break;
                }
                case 'S': {
                    this.shortPointers[nshort] = (short[])this.arrays[col2];
                    ++nshort;
                    break;
                }
                case 'I': {
                    this.intPointers[nint] = (int[])this.arrays[col2];
                    ++nint;
                    break;
                }
                case 'J': {
                    this.longPointers[nlong] = (long[])this.arrays[col2];
                    ++nlong;
                    break;
                }
                case 'F': {
                    this.floatPointers[nfloat] = (float[])this.arrays[col2];
                    ++nfloat;
                    break;
                }
                case 'D': {
                    this.doublePointers[ndouble] = (double[])this.arrays[col2];
                    ++ndouble;
                    break;
                }
                case 'C': {
                    this.charPointers[nchar] = (char[])this.arrays[col2];
                    ++nchar;
                    break;
                }
                case 'Z': {
                    this.booleanPointers[nboolean] = (boolean[])this.arrays[col2];
                    ++nboolean;
                }
            }
            ++col2;
        }
    }

    protected void addPointer(Object data) throws TableException {
        String classname = data.getClass().getName();
        char type = classname.charAt(1);
        switch (type) {
            case 'B': {
                byte[][] xb = new byte[this.bytePointers.length + 1][];
                System.arraycopy(this.bytePointers, 0, xb, 0, this.bytePointers.length);
                xb[this.bytePointers.length] = (byte[])data;
                this.bytePointers = xb;
                break;
            }
            case 'Z': {
                boolean[][] xb = new boolean[this.booleanPointers.length + 1][];
                System.arraycopy(this.booleanPointers, 0, xb, 0, this.booleanPointers.length);
                xb[this.booleanPointers.length] = (boolean[])data;
                this.booleanPointers = xb;
                break;
            }
            case 'S': {
                short[][] xb = new short[this.shortPointers.length + 1][];
                System.arraycopy(this.shortPointers, 0, xb, 0, this.shortPointers.length);
                xb[this.shortPointers.length] = (short[])data;
                this.shortPointers = xb;
                break;
            }
            case 'C': {
                char[][] xb = new char[this.charPointers.length + 1][];
                System.arraycopy(this.charPointers, 0, xb, 0, this.charPointers.length);
                xb[this.charPointers.length] = (char[])data;
                this.charPointers = xb;
                break;
            }
            case 'I': {
                int[][] xb = new int[this.intPointers.length + 1][];
                System.arraycopy(this.intPointers, 0, xb, 0, this.intPointers.length);
                xb[this.intPointers.length] = (int[])data;
                this.intPointers = xb;
                break;
            }
            case 'J': {
                long[][] xb = new long[this.longPointers.length + 1][];
                System.arraycopy(this.longPointers, 0, xb, 0, this.longPointers.length);
                xb[this.longPointers.length] = (long[])data;
                this.longPointers = xb;
                break;
            }
            case 'F': {
                float[][] xb = new float[this.floatPointers.length + 1][];
                System.arraycopy(this.floatPointers, 0, xb, 0, this.floatPointers.length);
                xb[this.floatPointers.length] = (float[])data;
                this.floatPointers = xb;
                break;
            }
            case 'D': {
                double[][] xb = new double[this.doublePointers.length + 1][];
                System.arraycopy(this.doublePointers, 0, xb, 0, this.doublePointers.length);
                xb[this.doublePointers.length] = (double[])data;
                this.doublePointers = xb;
                break;
            }
            default: {
                throw new TableException("Invalid type for added column:" + classname);
            }
        }
    }

    public int read(ArrayDataInput is) throws IOException {
        boolean currRow = false;
        int row = 0;
        while (row < this.nrow) {
            int ibyte = 0;
            int ishort = 0;
            int iint = 0;
            int ilong = 0;
            int ichar = 0;
            int ifloat = 0;
            int idouble = 0;
            int iboolean = 0;
            int col = 0;
            while (col < this.arrays.length) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                switch (this.types[col]) {
                    case 'I': {
                        int[] ia = this.intPointers[iint];
                        ++iint;
                        is.read(ia, arrOffset, size);
                        break;
                    }
                    case 'S': {
                        short[] s = this.shortPointers[ishort];
                        ++ishort;
                        is.read(s, arrOffset, size);
                        break;
                    }
                    case 'B': {
                        byte[] b = this.bytePointers[ibyte];
                        ++ibyte;
                        is.read(b, arrOffset, size);
                        break;
                    }
                    case 'F': {
                        float[] f = this.floatPointers[ifloat];
                        ++ifloat;
                        is.read(f, arrOffset, size);
                        break;
                    }
                    case 'D': {
                        double[] d = this.doublePointers[idouble];
                        ++idouble;
                        is.read(d, arrOffset, size);
                        break;
                    }
                    case 'C': {
                        char[] c = this.charPointers[ichar];
                        ++ichar;
                        is.read(c, arrOffset, size);
                        break;
                    }
                    case 'J': {
                        long[] l = this.longPointers[ilong];
                        ++ilong;
                        is.read(l, arrOffset, size);
                        break;
                    }
                    case 'Z': {
                        boolean[] bool = this.booleanPointers[iboolean];
                        ++iboolean;
                        is.read(bool, arrOffset, size);
                    }
                }
                ++col;
            }
            ++row;
        }
        return this.rowSize * this.nrow;
    }

    public int write(ArrayDataOutput os) throws IOException {
        if (this.rowSize == 0) {
            return 0;
        }
        int row = 0;
        while (row < this.nrow) {
            int ibyte = 0;
            int ishort = 0;
            int iint = 0;
            int ilong = 0;
            int ichar = 0;
            int ifloat = 0;
            int idouble = 0;
            int iboolean = 0;
            int col = 0;
            while (col < this.arrays.length) {
                int arrOffset = this.sizes[col] * row;
                int size = this.sizes[col];
                switch (this.types[col]) {
                    case 'I': {
                        int[] ia = this.intPointers[iint];
                        ++iint;
                        os.write(ia, arrOffset, size);
                        break;
                    }
                    case 'S': {
                        short[] s = this.shortPointers[ishort];
                        ++ishort;
                        os.write(s, arrOffset, size);
                        break;
                    }
                    case 'B': {
                        byte[] b = this.bytePointers[ibyte];
                        ++ibyte;
                        os.write(b, arrOffset, size);
                        break;
                    }
                    case 'F': {
                        float[] f = this.floatPointers[ifloat];
                        ++ifloat;
                        os.write(f, arrOffset, size);
                        break;
                    }
                    case 'D': {
                        double[] d = this.doublePointers[idouble];
                        ++idouble;
                        os.write(d, arrOffset, size);
                        break;
                    }
                    case 'C': {
                        char[] c = this.charPointers[ichar];
                        ++ichar;
                        os.write(c, arrOffset, size);
                        break;
                    }
                    case 'J': {
                        long[] l = this.longPointers[ilong];
                        ++ilong;
                        os.write(l, arrOffset, size);
                        break;
                    }
                    case 'Z': {
                        boolean[] bool = this.booleanPointers[iboolean];
                        ++iboolean;
                        os.write(bool, arrOffset, size);
                    }
                }
                ++col;
            }
            ++row;
        }
        return this.rowSize * this.nrow;
    }

    public Class[] getBases() {
        return this.bases;
    }

    public char[] getTypes() {
        return this.types;
    }

    public Object[] getColumns() {
        return this.arrays;
    }

    public int[] getSizes() {
        return this.sizes;
    }
}

