/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.MouldArrayImpl;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.datanode.nodes.ColumnsMetamapGroup;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.ExceptionComponentMaker;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.MetaTable;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.nodes.ValueInfoMetamapGroup;
import uk.ac.starlink.datanode.viewers.ArrayBrowser;
import uk.ac.starlink.datanode.viewers.StyledTextArea;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.splat.util.SplatException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.treeview.ApplicationDetailViewer;
import uk.ac.starlink.treeview.CollapseViewer;
import uk.ac.starlink.treeview.GraphViewer;
import uk.ac.starlink.treeview.GridPlotter;
import uk.ac.starlink.treeview.HexDumper;
import uk.ac.starlink.treeview.ImageViewer;
import uk.ac.starlink.treeview.NdxDisplayer;
import uk.ac.starlink.treeview.SliceViewer;
import uk.ac.starlink.treeview.SogNdxDisplayer;
import uk.ac.starlink.treeview.SplatNdxDisplayer;
import uk.ac.starlink.treeview.StatsViewer;
import uk.ac.starlink.util.DataSource;

public class ApplicationDetailViewer
implements DetailViewer {
    private final JTabbedPane tabbed_;
    private final StyledTextArea over_;
    private final List actions_;
    private boolean actionsAdded_;
    static /* synthetic */ Class class$uk$ac$starlink$util$DataSource;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$treeview$ApplicationDetailViewer;
    static /* synthetic */ Class class$uk$ac$starlink$table$StarTable;
    static /* synthetic */ Class class$uk$ac$starlink$ndx$Ndx;

    public ApplicationDetailViewer(String overName) {
        this.actions_ = new ArrayList();
        this.tabbed_ = new JTabbedPane(){
            private ComponentListener listener;

            public void addNotify() {
                super.addNotify();
                this.listener = new ComponentAdapter(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void componentResized(ComponentEvent evt) {
                        ApplicationDetailViewer.access$100(1.access$000(this.this$1)).setPreferredSize(this.this$1.getParent().getSize());
                        ApplicationDetailViewer.access$100(1.access$000(this.this$1)).revalidate();
                    }
                };
                this.listener.componentResized(null);
                this.getParent().addComponentListener(this.listener);
            }

            public void removeNotify() {
                super.removeNotify();
                this.getParent().removeComponentListener(this.listener);
            }

            static /* synthetic */ ApplicationDetailViewer access$000(1 x0) {
                return x0.ApplicationDetailViewer.this;
            }
        };
        this.over_ = new StyledTextArea();
        this.addPane(overName, this.over_);
        this.over_.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                if (!ApplicationDetailViewer.this.actionsAdded_ && ApplicationDetailViewer.this.actions_.size() > 0) {
                    ApplicationDetailViewer.this.over_.addSeparator();
                    ApplicationDetailViewer.this.over_.addTitle("External Programs");
                    Iterator it = ApplicationDetailViewer.this.actions_.iterator();
                    while (it.hasNext()) {
                        ApplicationDetailViewer.this.over_.addAction((Action)it.next());
                        if (!it.hasNext()) continue;
                        ApplicationDetailViewer.this.over_.addSpace();
                    }
                }
                ApplicationDetailViewer.this.actionsAdded_ = true;
            }
        });
    }

    public ApplicationDetailViewer(DataNode node) {
        block10: {
            this("Overview");
            this.addIcon(node.getIcon());
            this.addSpace();
            this.addTitle(node.getLabel());
            String name = node.getName();
            if (name.trim() != "") {
                this.addKeyedItem("Name", node.getName());
            }
            this.addKeyedItem("Node type", node.getNodeType());
            String path = NodeUtil.getNodePath(node);
            if (path != null) {
                this.addKeyedItem("Path", path);
            }
            if (node.hasDataObject(DataType.DATA_SOURCE)) {
                try {
                    this.addDataSourceViews((DataSource)node.getDataObject(DataType.DATA_SOURCE));
                }
                catch (DataObjectException e) {
                    this.addPane("Error opening stream", new ExceptionComponentMaker(e));
                }
            }
            if (node.hasDataObject(DataType.TABLE)) {
                try {
                    this.addTableViews((StarTable)node.getDataObject(DataType.TABLE));
                }
                catch (DataObjectException e) {
                    this.addPane("Error obtaining table", new ExceptionComponentMaker(e));
                }
            }
            if (!node.hasDataObject(DataType.NDX)) break block10;
            try {
                this.addNdxViews((Ndx)node.getDataObject(DataType.NDX));
            }
            catch (DataObjectException e) {
                this.addPane("Error obtaining NDX", new ExceptionComponentMaker(e));
            }
        }
    }

    public JComponent getComponent() {
        return this.tabbed_;
    }

    public void setSelectedIndex(int index) {
        this.tabbed_.setSelectedIndex(index);
    }

    public void addTitle(String title) {
        this.over_.addTitle(title);
    }

    public void addSubHead(String text) {
        this.over_.addSubHead(text);
    }

    public void addKeyedItem(String name, String value) {
        this.over_.addKeyedItem(name, value);
    }

    public void addKeyedItem(String name, Object value) {
        this.addKeyedItem(name, value == null ? "null" : value.toString());
    }

    public void addKeyedItem(String name, double value) {
        this.over_.addKeyedItem(name, value);
    }

    public void addKeyedItem(String name, float value) {
        this.over_.addKeyedItem(name, value);
    }

    public void addKeyedItem(String name, long value) {
        this.over_.addKeyedItem(name, value);
    }

    public void addKeyedItem(String name, int value) {
        this.over_.addKeyedItem(name, value);
    }

    public void addKeyedItem(String name, boolean value) {
        this.over_.addKeyedItem(name, value);
    }

    public void logError(Throwable th) {
        this.over_.logError(th);
    }

    public void addSeparator() {
        this.over_.addSeparator();
    }

    public void addText(String text) {
        this.over_.addText(text);
    }

    public void addSpace() {
        this.over_.addSpace();
    }

    public void addIcon(Icon icon) {
        this.over_.addIcon(icon);
    }

    public void addPane(String title, Component comp) {
        this.tabbed_.addTab(title, comp);
    }

    public void addPane(String title, final ComponentMaker maker) {
        final Box box = new Box(0);
        this.addPane(title, box);
        this.tabbed_.addChangeListener(new ChangeListener(){
            private boolean done = false;

            public synchronized void stateChanged(ChangeEvent evt) {
                if (ApplicationDetailViewer.this.tabbed_.getSelectedComponent() == box && !this.done) {
                    JComponent comp;
                    this.done = true;
                    ApplicationDetailViewer.this.tabbed_.removeChangeListener(this);
                    try {
                        comp = new JScrollPane(maker.getComponent());
                    }
                    catch (Exception e) {
                        StyledTextArea sta = new StyledTextArea();
                        sta.addTitle("Error");
                        sta.setWrap(false);
                        sta.addKeyedItem("Exception class", e.getClass().getName());
                        sta.addKeyedItem("Message", e.getMessage());
                        sta.addSubHead("Stack trace");
                        PrintWriter pw = new PrintWriter(sta.lineAppender());
                        e.printStackTrace(pw);
                        comp = sta;
                    }
                    box.add(comp);
                }
            }
        });
    }

    public void addScalingPane(String title, final ComponentMaker maker) {
        final Box box = new Box(0);
        this.addPane(title, box);
        this.tabbed_.addChangeListener(new ChangeListener(){
            private boolean done = false;

            public synchronized void stateChanged(ChangeEvent evt) {
                if (ApplicationDetailViewer.this.tabbed_.getSelectedComponent() == box && !this.done) {
                    JComponent comp;
                    this.done = true;
                    ApplicationDetailViewer.this.tabbed_.removeChangeListener(this);
                    try {
                        comp = maker.getComponent();
                    }
                    catch (Exception e) {
                        StyledTextArea sta = new StyledTextArea();
                        sta.addTitle("Error");
                        sta.setWrap(false);
                        sta.addKeyedItem("Exception class", e.getClass().getName());
                        sta.addKeyedItem("Message", e.getMessage());
                        sta.addSubHead("Stack trace");
                        PrintWriter pw = new PrintWriter(sta.lineAppender());
                        e.printStackTrace(pw);
                        comp = new JScrollPane(sta);
                    }
                    box.add(comp);
                }
            }
        });
    }

    public void addAction(Action act) {
        this.actions_.add(act);
    }

    private void addDataSourceViews(final DataSource datsrc) {
        try {
            byte[] intro;
            long size = datsrc.getLength();
            if (size >= 0L) {
                this.addKeyedItem("Bytes", size);
            }
            if ((intro = datsrc.getIntro()).length > 0) {
                this.addPane("Hex dump", new ComponentMaker(){

                    public JComponent getComponent() throws IOException {
                        return new HexDumper(datsrc.getInputStream(), datsrc.getLength());
                    }
                });
            }
        }
        catch (IOException e) {
            this.addPane("Error reading data", new ExceptionComponentMaker(e));
        }
    }

    private void addTableViews(final StarTable startable) {
        List params;
        URL url;
        int ncol = startable.getColumnCount();
        long nrow = startable.getRowCount();
        this.addKeyedItem("Columns", ncol);
        if (nrow >= 0L) {
            this.addKeyedItem("Rows", nrow);
        }
        if ((url = startable.getURL()) != null) {
            this.addKeyedItem("URL", url);
        }
        final RandomTableGetter tgetter = new RandomTableGetter(startable);
        if (ncol > 0) {
            this.addPane("Columns", new ComponentMaker(){

                public JComponent getComponent() {
                    ColumnsMetamapGroup metagroup = new ColumnsMetamapGroup(startable);
                    return new MetaTable(metagroup);
                }
            });
        }
        if ((params = startable.getParameters()).size() > 0) {
            this.addPane("Parameters", new ComponentMaker(){

                public JComponent getComponent() {
                    ValueInfoMetamapGroup metagroup = new ValueInfoMetamapGroup(params);
                    return new MetaTable(metagroup);
                }
            });
        }
        if (ncol > 0 && nrow != 0L) {
            this.addPane("Table data", new ComponentMaker(){

                public JComponent getComponent() throws IOException {
                    StarTable rtab = tgetter.getRandomTable();
                    StarJTable sjt = new StarJTable(rtab, true);
                    sjt.configureColumnWidths(800, 100);
                    return sjt;
                }
            });
        }
        if (ncol > 0) {
            Icon tcic = IconFactory.getIcon((short)202);
            this.addAction(new AbstractAction("TOPCAT", tcic){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        ControlWindow.getInstance().addTable(tgetter.getRandomTable(), "from Treeview", true);
                    }
                    catch (IOException e) {
                        Toolkit.getDefaultToolkit().beep();
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void addNdxViews(final Ndx ndx) {
        NdxDisplayer displayer;
        final RandomNdxGetter ngetter = new RandomNdxGetter(ndx);
        final FrameSet ast = NodeUtil.hasAST() && ndx.hasWCS() ? ndx.getAst() : null;
        final NDShape shape = ngetter.getShape();
        final int ndim = shape.getNumDims();
        final int endim = ngetter.getEffectiveNumDims();
        if (NodeUtil.hasAST() && ndx.hasWCS() && ndim == 2 && endim == 2) {
            this.addScalingPane("WCS grids", new ComponentMaker(){

                public JComponent getComponent() throws IOException {
                    return new GridPlotter(shape, ast);
                }
            });
        }
        this.addScalingPane("Pixel values", new ComponentMaker(){

            public JComponent getComponent() throws IOException {
                if (endim == 2 && ndim != 2) {
                    return new ArrayBrowser(ngetter.getEffectiveImage());
                }
                return new ArrayBrowser(ngetter.getRandomImage());
            }
        });
        this.addPane("Statistics", new ComponentMaker(){

            public JComponent getComponent() {
                try {
                    return new StatsViewer(ngetter.getRandomImage());
                }
                catch (IOException e) {
                    return new TextViewer(e);
                }
            }
        });
        if (endim == 1 && NodeUtil.hasAST()) {
            this.addScalingPane("Graph view", new ComponentMaker(){

                public JComponent getComponent() throws IOException, SplatException {
                    return new GraphViewer(ndx);
                }
            });
        }
        if ((ndim == 2 || endim == 2) && NodeUtil.hasJAI()) {
            this.addPane("Image display", new ComponentMaker(){

                public JComponent getComponent() throws IOException {
                    if (endim == 2 && ndim != 2) {
                        return new ImageViewer(ngetter.getEffectiveImage(), null);
                    }
                    return new ImageViewer(ngetter.getRandomImage(), ast);
                }
            });
        }
        if (endim > 2 && NodeUtil.hasJAI()) {
            this.addPane("Slices", new ComponentMaker(){

                public JComponent getComponent() {
                    try {
                        if (endim != ndim) {
                            return new SliceViewer(ngetter.getRandomImage(), null);
                        }
                        return new SliceViewer(ngetter.getRandomImage(), ast);
                    }
                    catch (IOException e) {
                        return new TextViewer(e);
                    }
                }
            });
        }
        if (endim == 3 && NodeUtil.hasJAI()) {
            this.addPane("Collapsed", new ComponentMaker(){

                public JComponent getComponent() throws IOException {
                    if (endim != ndim) {
                        return new CollapseViewer(ngetter.getEffectiveImage(), null);
                    }
                    return new CollapseViewer(ngetter.getRandomImage(), ast);
                }
            });
        }
        if (ndim == 1 && endim == 1 && ((SplatNdxDisplayer)(displayer = SplatNdxDisplayer.getInstance())).canDisplay(ndx)) {
            this.addAction(new NdxDisplayAction(displayer, ndx, "SPLAT", 200));
        }
        if (ndim == 2 && endim == 2 && ((SogNdxDisplayer)(displayer = SogNdxDisplayer.getInstance())).canDisplay(ndx)) {
            this.addAction(new NdxDisplayAction(displayer, ndx, "SoG", 201));
        }
    }

    private static NDArray effectiveArray(NDArray nda1) {
        boolean isig = false;
        OrderedNDShape shape1 = nda1.getShape();
        long[] origin1 = shape1.getOrigin();
        long[] dims1 = shape1.getDims();
        int ndim1 = shape1.getNumDims();
        int ndim2 = 0;
        int i1 = 0;
        while (i1 < ndim1) {
            if (dims1[i1] > 1L) {
                ++ndim2;
            }
            ++i1;
        }
        long[] origin2 = new long[ndim2];
        long[] dims2 = new long[ndim2];
        int i2 = 0;
        int i12 = 0;
        while (i12 < ndim1) {
            if (dims1[i12] > 1L) {
                origin2[i2] = origin1[i12];
                dims2[i2] = dims1[i12];
                ++i2;
            }
            ++i12;
        }
        if (!$assertionsDisabled && i2 != ndim2) {
            throw new AssertionError();
        }
        NDShape shape2 = new NDShape(origin2, dims2);
        if (!$assertionsDisabled && shape2.getNumPixels() != shape1.getNumPixels()) {
            throw new AssertionError();
        }
        BridgeNDArray nda2 = new BridgeNDArray((ArrayImpl)new MouldArrayImpl(nda1, shape2));
        return nda2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean bl = $assertionsDisabled = !(class$uk$ac$starlink$treeview$ApplicationDetailViewer == null ? (class$uk$ac$starlink$treeview$ApplicationDetailViewer = ApplicationDetailViewer.class$("uk.ac.starlink.treeview.ApplicationDetailViewer")) : class$uk$ac$starlink$treeview$ApplicationDetailViewer).desiredAssertionStatus();
        if (!$assertionsDisabled && DataType.DATA_SOURCE.getDataClass() != (class$uk$ac$starlink$util$DataSource == null ? (class$uk$ac$starlink$util$DataSource = ApplicationDetailViewer.class$("uk.ac.starlink.util.DataSource")) : class$uk$ac$starlink$util$DataSource)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && DataType.TABLE.getDataClass() != (class$uk$ac$starlink$table$StarTable == null ? (class$uk$ac$starlink$table$StarTable = ApplicationDetailViewer.class$("uk.ac.starlink.table.StarTable")) : class$uk$ac$starlink$table$StarTable)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && DataType.NDX.getDataClass() != (class$uk$ac$starlink$ndx$Ndx == null ? (class$uk$ac$starlink$ndx$Ndx = ApplicationDetailViewer.class$("uk.ac.starlink.ndx.Ndx")) : class$uk$ac$starlink$ndx$Ndx)) {
            throw new AssertionError();
        }
    }

    private static class NdxDisplayAction
    extends AbstractAction {
        NdxDisplayer displayer;
        Ndx ndx;

        NdxDisplayAction(NdxDisplayer displayer, Ndx ndx, String name, short iconId) {
            super(name, IconFactory.getIcon(iconId));
            this.displayer = displayer;
            this.ndx = ndx;
        }

        public void actionPerformed(ActionEvent evt) {
            new Thread(this){
                private final /* synthetic */ NdxDisplayAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (!this.this$0.displayer.soapDisplay(this.this$0.ndx)) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 18 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                if (!18.access$600(this.this$1).displayer.localDisplay(18.access$600(this.this$1).ndx, true)) {
                                    Toolkit.getDefaultToolkit().beep();
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ NdxDisplayAction access$600(18 x0) {
                    return x0.this$0;
                }
            }.start();
        }
    }

    private static class RandomNdxGetter {
        final Ndx ndx;
        NDArray image;
        NDArray effectiveImage;
        NDShape shape;

        public RandomNdxGetter(Ndx ndx) {
            this.ndx = ndx;
        }

        public NDShape getShape() {
            if (this.shape == null) {
                this.shape = this.ndx.getImage().getShape();
            }
            return this.shape;
        }

        public NDArray getRandomImage() throws IOException {
            if (this.image == null) {
                Requirements req = new Requirements(AccessMode.READ).setRandom(true);
                this.image = NDArrays.toRequiredArray((NDArray)Ndxs.getMaskedImage((Ndx)this.ndx), (Requirements)req);
                this.shape = this.image.getShape();
            }
            return this.image;
        }

        public int getEffectiveNumDims() {
            long[] dims = this.getShape().getDims();
            int endim = 0;
            int i = 0;
            while (i < dims.length) {
                if (dims[i] > 1L) {
                    ++endim;
                }
                ++i;
            }
            return endim;
        }

        public NDArray getEffectiveImage() throws IOException {
            if (this.effectiveImage == null) {
                this.effectiveImage = this.shape.getNumPixels() > 1L ? ApplicationDetailViewer.effectiveArray(this.getRandomImage()) : this.getRandomImage();
            }
            return this.effectiveImage;
        }
    }

    private static class RandomTableGetter {
        StarTable startab;
        StarTable randomTable;

        public RandomTableGetter(StarTable startab) {
            this.startab = startab;
        }

        public StarTable getRandomTable() throws IOException {
            if (this.randomTable == null) {
                this.randomTable = Tables.randomTable((StarTable)this.startab);
            }
            return this.randomTable;
        }
    }
}

