/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.array.WrapperArrayImpl;

public class CollapseArrayImpl
extends WrapperArrayImpl {
    private final NDArray baseNda;
    private final OrderedNDShape baseShape;
    private final long[] baseOrigin;
    private final long[] baseDims;
    private final BadHandler baseHandler;
    private final Type baseType;
    private final OrderedNDShape shape;
    private final Type type;
    private final BadHandler handler;
    private final boolean hasFitsOrder;
    private final long[] origin;
    private final long[] dims;
    private final int ndim;
    private final int collAxis;
    private final long collOrigin;
    private final long collDim;
    private final Collapsor collapsor;
    private final long stride;
    private final long[] st2;
    static /* synthetic */ Class class$uk$ac$starlink$treeview$CollapseArrayImpl;

    public CollapseArrayImpl(NDArray nda, int collAxis) {
        this(nda, collAxis, nda.getShape().getOrigin()[collAxis], nda.getShape().getDims()[collAxis]);
    }

    public CollapseArrayImpl(NDArray nda, int collAxis, long collOrigin, long collDim) {
        super(nda);
        this.baseNda = nda;
        this.baseShape = this.baseNda.getShape();
        this.baseHandler = this.baseNda.getBadHandler();
        this.baseType = this.baseNda.getType();
        this.collAxis = collAxis;
        this.collOrigin = collOrigin;
        this.collDim = collDim;
        this.collapsor = CollapseArrayImpl.getMeanCollapsor(this.baseType);
        int baseNdim = this.baseShape.getNumDims();
        this.hasFitsOrder = this.baseShape.getOrder().isFitsLike();
        this.ndim = baseNdim - 1;
        this.baseOrigin = this.baseShape.getOrigin();
        this.baseDims = this.baseShape.getDims();
        if (collAxis < 0 || collAxis >= baseNdim) {
            throw new IllegalArgumentException("Collapse axis " + collAxis + " does not exist");
        }
        if (collOrigin < this.baseShape.getOrigin()[collAxis] || collOrigin + collDim > this.baseShape.getLimits()[collAxis]) {
            throw new IllegalArgumentException("Collapse limits out of base array bounds");
        }
        if (!this.baseNda.isRandom()) {
            throw new IllegalArgumentException("Base array does not have random access");
        }
        if (collDim > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Implemented does not permit collapse dimension > Integer.MAX_VALUE, sorry");
        }
        this.origin = new long[this.ndim];
        this.dims = new long[this.ndim];
        int i = 0;
        int j = 0;
        while (i < baseNdim) {
            if (i != collAxis) {
                this.origin[j] = this.baseOrigin[i];
                this.dims[j] = this.baseDims[i];
                ++j;
            }
            ++i;
        }
        this.shape = new OrderedNDShape(this.origin, this.dims, this.baseShape.getOrder());
        this.type = this.collapsor.getOutputType();
        this.handler = this.type.defaultBadHandler();
        long str = 1L;
        int j2 = 0;
        while (j2 < this.ndim) {
            int i2;
            int n = i2 = this.hasFitsOrder ? j2 : this.ndim - 1 - j2;
            if (i2 < collAxis) {
                str *= this.baseDims[i2];
            }
            ++j2;
        }
        this.stride = str;
        long[] st1 = new long[this.ndim];
        int i3 = 0;
        while (i3 < this.ndim) {
            long l = st1[i3] = i3 == 0 ? 1L : st1[i3 - 1] * this.dims[i3 - 1];
            if (i3 == collAxis) {
                int n = i3;
                st1[n] = st1[n] * this.baseDims[collAxis];
            }
            ++i3;
        }
        this.st2 = new long[this.ndim];
        int j3 = 0;
        while (j3 < this.ndim) {
            int i4 = this.hasFitsOrder ? j3 : this.ndim - 1 - j3;
            this.st2[i4] = st1[j3];
            ++j3;
        }
    }

    public OrderedNDShape getShape() {
        return this.shape;
    }

    public Type getType() {
        return this.type;
    }

    public BadHandler getBadHandler() {
        return this.handler;
    }

    public boolean isWritable() {
        return false;
    }

    public AccessImpl getAccess() throws IOException {
        return new CollapseAccessImpl();
    }

    private static Collapsor getMeanCollapsor(Type inType) {
        if (inType == Type.BYTE) {
            return new Collapsor(){

                public Type getOutputType() {
                    return Type.FLOAT;
                }

                public void collapse(Object inBuf, int inSize, Object outBuf, int outOff) {
                    float sum = 0.0f;
                    int i = 0;
                    while (i < inSize) {
                        sum += (float)((byte[])inBuf)[i];
                        ++i;
                    }
                    ((float[])outBuf)[outOff] = sum / (float)inSize;
                }
            };
        }
        if (inType == Type.SHORT) {
            return new Collapsor(){

                public Type getOutputType() {
                    return Type.FLOAT;
                }

                public void collapse(Object inBuf, int inSize, Object outBuf, int outOff) {
                    float sum = 0.0f;
                    int i = 0;
                    while (i < inSize) {
                        sum += (float)((short[])inBuf)[i];
                        ++i;
                    }
                    ((float[])outBuf)[outOff] = sum / (float)inSize;
                }
            };
        }
        if (inType == Type.INT) {
            return new Collapsor(){

                public Type getOutputType() {
                    return Type.FLOAT;
                }

                public void collapse(Object inBuf, int inSize, Object outBuf, int outOff) {
                    float sum = 0.0f;
                    int i = 0;
                    while (i < inSize) {
                        sum += (float)((int[])inBuf)[i];
                        ++i;
                    }
                    ((float[])outBuf)[outOff] = sum / (float)inSize;
                }
            };
        }
        if (inType == Type.FLOAT) {
            return new Collapsor(){

                public Type getOutputType() {
                    return Type.FLOAT;
                }

                public void collapse(Object inBuf, int inSize, Object outBuf, int outOff) {
                    float sum = 0.0f;
                    int i = 0;
                    while (i < inSize) {
                        sum += ((float[])inBuf)[i];
                        ++i;
                    }
                    ((float[])outBuf)[outOff] = sum / (float)inSize;
                }
            };
        }
        if (inType == Type.DOUBLE) {
            return new Collapsor(){

                public Type getOutputType() {
                    return Type.DOUBLE;
                }

                public void collapse(Object inBuf, int inSize, Object outBuf, int outOff) {
                    double sum = 0.0;
                    int i = 0;
                    while (i < inSize) {
                        sum += ((double[])inBuf)[i];
                        ++i;
                    }
                    ((double[])outBuf)[outOff] = sum / (double)inSize;
                }
            };
        }
        throw new AssertionError((Object)"Unknown type");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface Collapsor {
        public Type getOutputType();

        public void collapse(Object var1, int var2, Object var3, int var4);
    }

    private class CollapseAccessImpl
    implements AccessImpl {
        private ArrayAccess baseAcc;
        private long offset;
        private Object cbuf;
        private long baseStart0;
        static final /* synthetic */ boolean $assertionsDisabled;

        public CollapseAccessImpl() throws IOException {
            this.baseAcc = CollapseArrayImpl.this.baseNda.getAccess();
            this.offset = 0L;
            if (!$assertionsDisabled && CollapseArrayImpl.this.collDim >= Integer.MAX_VALUE) {
                throw new AssertionError();
            }
            this.cbuf = CollapseArrayImpl.this.baseType.newArray((int)CollapseArrayImpl.this.collDim);
            this.baseStart0 = CollapseArrayImpl.this.collOrigin - CollapseArrayImpl.this.baseOrigin[CollapseArrayImpl.this.collAxis];
            int i = 0;
            while (i < CollapseArrayImpl.this.collAxis) {
                this.baseStart0 *= CollapseArrayImpl.this.baseDims[i];
                ++i;
            }
        }

        public void setOffset(long off) throws IOException {
            this.offset = off;
        }

        public void read(Object buffer, int start, int size) throws IOException {
            Iterator it = CollapseArrayImpl.this.shape.pixelIterator(this.offset, (long)size);
            int i = 0;
            while (i < size) {
                long baseStart = this.posToBaseStart((long[])it.next());
                int ngood = 0;
                int j = 0;
                while ((long)j < CollapseArrayImpl.this.collDim) {
                    this.baseAcc.setOffset(baseStart + (long)j * CollapseArrayImpl.this.stride);
                    this.baseAcc.read(this.cbuf, ngood, 1);
                    if (!CollapseArrayImpl.this.baseHandler.isBad(this.cbuf, ngood)) {
                        ++ngood;
                    }
                    ++j;
                }
                if (ngood > 0) {
                    CollapseArrayImpl.this.collapsor.collapse(this.cbuf, ngood, buffer, start + i);
                } else {
                    CollapseArrayImpl.this.handler.putBad(buffer, start + i);
                }
                ++i;
            }
            this.offset += (long)size;
        }

        public void write(Object buffer, int start, int size) {
            throw new UnsupportedOperationException();
        }

        public void close() throws IOException {
            this.baseAcc.close();
        }

        private long posToBaseStart(long[] pos) {
            long baseStart = this.baseStart0;
            int i = 0;
            while (i < CollapseArrayImpl.this.ndim) {
                baseStart += (pos[i] - CollapseArrayImpl.this.origin[i]) * CollapseArrayImpl.this.st2[i];
                ++i;
            }
            return baseStart;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$treeview$CollapseArrayImpl == null ? (class$uk$ac$starlink$treeview$CollapseArrayImpl = CollapseArrayImpl.class$("uk.ac.starlink.treeview.CollapseArrayImpl")) : class$uk$ac$starlink$treeview$CollapseArrayImpl).desiredAssertionStatus();
        }
    }
}

