/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.treeview.DemoDataNode;
import uk.ac.starlink.treeview.StaticTreeViewer;
import uk.ac.starlink.treeview.TreeWriter;
import uk.ac.starlink.util.Loader;

public class Driver {
    public static final String CMDNAME_PROPERTY = "uk.ac.starlink.treeview.cmdname";
    private static Logger logger = Logger.getLogger("uk.ac.starlink.treeview");
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$HDSDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$FileDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$PlainDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$CompressedDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$JDBCDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$StarTableDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$ARYDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$NDFDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$WCSDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$ZipFileDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$ZipStreamDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$TarStreamDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$FITSDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$XMLDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$HDXDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$NdxDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$VOTableDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$NDArrayDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$FtpDirectoryDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$fits$FitsNdxHandler;
    static /* synthetic */ Class class$uk$ac$starlink$hds$NDFNdxHandler;

    public static void main(String[] args) {
        boolean textView = false;
        boolean textPath = false;
        int orient = 2;
        Loader.loadProperties();
        Loader.tweakGuiForMac();
        Driver.guessProperties();
        String cmdName = System.getProperty(CMDNAME_PROPERTY);
        if (cmdName == null) {
            cmdName = "treeview";
        }
        boolean hasAST = NodeUtil.hasAST();
        boolean hasHDS = NodeUtil.hasHDS();
        HashMap<String, Class> nodeTypeFlags = new HashMap<String, Class>();
        if (hasHDS) {
            nodeTypeFlags.put("-hds", class$uk$ac$starlink$datanode$nodes$HDSDataNode == null ? (class$uk$ac$starlink$datanode$nodes$HDSDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.HDSDataNode")) : class$uk$ac$starlink$datanode$nodes$HDSDataNode);
        }
        nodeTypeFlags.put("-file", class$uk$ac$starlink$datanode$nodes$FileDataNode == null ? (class$uk$ac$starlink$datanode$nodes$FileDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.FileDataNode")) : class$uk$ac$starlink$datanode$nodes$FileDataNode);
        nodeTypeFlags.put("-plain", class$uk$ac$starlink$datanode$nodes$PlainDataNode == null ? (class$uk$ac$starlink$datanode$nodes$PlainDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.PlainDataNode")) : class$uk$ac$starlink$datanode$nodes$PlainDataNode);
        nodeTypeFlags.put("-comp", class$uk$ac$starlink$datanode$nodes$CompressedDataNode == null ? (class$uk$ac$starlink$datanode$nodes$CompressedDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.CompressedDataNode")) : class$uk$ac$starlink$datanode$nodes$CompressedDataNode);
        nodeTypeFlags.put("-jdbc", class$uk$ac$starlink$datanode$nodes$JDBCDataNode == null ? (class$uk$ac$starlink$datanode$nodes$JDBCDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.JDBCDataNode")) : class$uk$ac$starlink$datanode$nodes$JDBCDataNode);
        nodeTypeFlags.put("-table", class$uk$ac$starlink$datanode$nodes$StarTableDataNode == null ? (class$uk$ac$starlink$datanode$nodes$StarTableDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.StarTableDataNode")) : class$uk$ac$starlink$datanode$nodes$StarTableDataNode);
        nodeTypeFlags.put("-src", class$uk$ac$starlink$datanode$nodes$PlainDataNode == null ? (class$uk$ac$starlink$datanode$nodes$PlainDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.PlainDataNode")) : class$uk$ac$starlink$datanode$nodes$PlainDataNode);
        if (hasHDS) {
            nodeTypeFlags.put("-ary", class$uk$ac$starlink$datanode$nodes$ARYDataNode == null ? (class$uk$ac$starlink$datanode$nodes$ARYDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.ARYDataNode")) : class$uk$ac$starlink$datanode$nodes$ARYDataNode);
            nodeTypeFlags.put("-ndf", class$uk$ac$starlink$datanode$nodes$NDFDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NDFDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.NDFDataNode")) : class$uk$ac$starlink$datanode$nodes$NDFDataNode);
        }
        if (hasAST) {
            nodeTypeFlags.put("-wcs", class$uk$ac$starlink$datanode$nodes$WCSDataNode == null ? (class$uk$ac$starlink$datanode$nodes$WCSDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.WCSDataNode")) : class$uk$ac$starlink$datanode$nodes$WCSDataNode);
        }
        nodeTypeFlags.put("-zip", class$uk$ac$starlink$datanode$nodes$ZipFileDataNode == null ? (class$uk$ac$starlink$datanode$nodes$ZipFileDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.ZipFileDataNode")) : class$uk$ac$starlink$datanode$nodes$ZipFileDataNode);
        nodeTypeFlags.put("-zips", class$uk$ac$starlink$datanode$nodes$ZipStreamDataNode == null ? (class$uk$ac$starlink$datanode$nodes$ZipStreamDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.ZipStreamDataNode")) : class$uk$ac$starlink$datanode$nodes$ZipStreamDataNode);
        nodeTypeFlags.put("-tar", class$uk$ac$starlink$datanode$nodes$TarStreamDataNode == null ? (class$uk$ac$starlink$datanode$nodes$TarStreamDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.TarStreamDataNode")) : class$uk$ac$starlink$datanode$nodes$TarStreamDataNode);
        nodeTypeFlags.put("-fit", class$uk$ac$starlink$datanode$nodes$FITSDataNode == null ? (class$uk$ac$starlink$datanode$nodes$FITSDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.FITSDataNode")) : class$uk$ac$starlink$datanode$nodes$FITSDataNode);
        nodeTypeFlags.put("-xml", class$uk$ac$starlink$datanode$nodes$XMLDataNode == null ? (class$uk$ac$starlink$datanode$nodes$XMLDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.XMLDataNode")) : class$uk$ac$starlink$datanode$nodes$XMLDataNode);
        nodeTypeFlags.put("-hdx", class$uk$ac$starlink$datanode$nodes$HDXDataNode == null ? (class$uk$ac$starlink$datanode$nodes$HDXDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.HDXDataNode")) : class$uk$ac$starlink$datanode$nodes$HDXDataNode);
        nodeTypeFlags.put("-ndx", class$uk$ac$starlink$datanode$nodes$NdxDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NdxDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.NdxDataNode")) : class$uk$ac$starlink$datanode$nodes$NdxDataNode);
        nodeTypeFlags.put("-vot", class$uk$ac$starlink$datanode$nodes$VOTableDataNode == null ? (class$uk$ac$starlink$datanode$nodes$VOTableDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.VOTableDataNode")) : class$uk$ac$starlink$datanode$nodes$VOTableDataNode);
        nodeTypeFlags.put("-nda", class$uk$ac$starlink$datanode$nodes$NDArrayDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NDArrayDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.NDArrayDataNode")) : class$uk$ac$starlink$datanode$nodes$NDArrayDataNode);
        nodeTypeFlags.put("-ftp", class$uk$ac$starlink$datanode$nodes$FtpDirectoryDataNode == null ? (class$uk$ac$starlink$datanode$nodes$FtpDirectoryDataNode = Driver.class$("uk.ac.starlink.datanode.nodes.FtpDirectoryDataNode")) : class$uk$ac$starlink$datanode$nodes$FtpDirectoryDataNode);
        String usageMsg = "Usage: " + cmdName + "\n         [-demo] [-text [-path]] [-strict] [-debug] " + "[-split(x|y|0)]" + "\n        ";
        Iterator flagIt = nodeTypeFlags.keySet().iterator();
        while (flagIt.hasNext()) {
            usageMsg = usageMsg + " [" + flagIt.next().toString() + "]";
        }
        usageMsg = usageMsg + "\n         [item ...]\n";
        System.setProperty("HdxDocumentFactory.load." + (class$uk$ac$starlink$fits$FitsNdxHandler == null ? (class$uk$ac$starlink$fits$FitsNdxHandler = Driver.class$("uk.ac.starlink.fits.FitsNdxHandler")) : class$uk$ac$starlink$fits$FitsNdxHandler).getName(), "true");
        if (hasHDS) {
            System.setProperty("HdxDocumentFactory.load." + (class$uk$ac$starlink$hds$NDFNdxHandler == null ? (class$uk$ac$starlink$hds$NDFNdxHandler = Driver.class$("uk.ac.starlink.hds.NDFNdxHandler")) : class$uk$ac$starlink$hds$NDFNdxHandler).getName(), "true");
        }
        final DataNodeFactory nodeFactory = new DataNodeFactory();
        final ArrayList<DataNode> topNodes = new ArrayList<DataNode>(args.length);
        int iarg = 0;
        while (iarg < args.length) {
            String arg = args[iarg];
            if (arg.charAt(0) == '-') {
                if (arg.equals("-text")) {
                    textView = true;
                } else if (arg.equals("-path")) {
                    textPath = true;
                } else if (arg.equals("-splitx")) {
                    orient = 2;
                } else if (arg.equals("-splity")) {
                    orient = 1;
                } else if (arg.equals("-split0")) {
                    orient = 0;
                } else if (arg.equals("-strict")) {
                    List builders = nodeFactory.getBuilders();
                    nodeFactory.getBuilders().removeAll(builders);
                } else if (arg.equals("-debug")) {
                    nodeFactory.setDebug(true);
                } else if (arg.equals("-demo")) {
                    try {
                        topNodes.add(new DemoDataNode());
                    }
                    catch (NoSuchDataException e) {
                        Driver.exitWithError(e.getMessage() + "\n");
                        throw new Error();
                    }
                } else if (nodeTypeFlags.containsKey(arg)) {
                    Class prefClass = (Class)nodeTypeFlags.get(arg);
                    nodeFactory.setPreferredClass(prefClass);
                } else {
                    Driver.exitWithError(usageMsg);
                }
            } else {
                topNodes.add(Driver.makeDataNode(nodeFactory, arg));
            }
            ++iarg;
        }
        if (topNodes.size() == 0) {
            String dfltarg = new File(".").getAbsolutePath();
            if (dfltarg.endsWith(File.separatorChar + ".")) {
                dfltarg = dfltarg.substring(0, dfltarg.length() - 1);
            }
            topNodes.add(Driver.makeDataNode(nodeFactory, dfltarg));
        }
        Iterator it = topNodes.iterator();
        while (it.hasNext()) {
            DataNode node = (DataNode)it.next();
            node.setChildMaker(nodeFactory);
        }
        DefaultDataNode root = new DefaultDataNode(){

            public boolean allowsChildren() {
                return true;
            }

            public Iterator getChildIterator() {
                return topNodes.iterator();
            }

            public DataNodeFactory getChildMaker() {
                return nodeFactory;
            }
        };
        if (textView) {
            NodeUtil.setGUI(false);
            Driver.viewAsText(root, textPath);
        } else {
            NodeUtil.setGUI(true);
            Driver.viewAsGUI(root, (short)orient);
        }
    }

    private static void viewAsGUI(final DataNode root, final short orient) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StaticTreeViewer tv = new StaticTreeViewer(root, "Starlink Treeview", orient);
                tv.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                tv.setVisible(true);
            }
        });
    }

    public static void viewAsText(DataNode root, boolean showPath) {
        TreeWriter tw = new TreeWriter(System.out, showPath);
        tw.write(root);
    }

    private static DataNode makeDataNode(DataNodeFactory nodeFactory, String nodename) {
        try {
            DataNode node = nodeFactory.makeDataNode(null, nodename);
            node.setLabel(nodename);
            return node;
        }
        catch (NoSuchDataException e) {
            StringBuffer msg = new StringBuffer();
            msg.append("\nNo such object ").append('\"').append(nodename).append('\"');
            Driver.exitWithError(msg.toString());
            throw new AssertionError();
        }
    }

    private static void guessProperties() {
        block4: {
            Loader.loadProperties();
            Properties props = System.getProperties();
            String prefix = "uk.ac.starlink.treeview.";
            String sc = "" + File.separatorChar;
            String cmdnameProp = prefix + "cmdname";
            if (!props.containsKey(cmdnameProp)) {
                props.setProperty(cmdnameProp, "treeview");
            }
            try {
                File sdir = Loader.starjavaDirectory();
                if (sdir == null) break block4;
                String stardir = sdir.toString() + sc;
                String demodirProp = prefix + "demodir";
                if (!props.containsKey(demodirProp)) {
                    props.setProperty(demodirProp, stardir + "etc" + sc + "treeview" + sc + "demo");
                }
            }
            catch (Exception e) {
                System.err.println("Failed to locate Treeview etc. directory");
            }
        }
    }

    private static void exitWithError(String msg) {
        System.err.println();
        StringTokenizer st = new StringTokenizer(msg, "\n");
        while (st.hasMoreTokens()) {
            System.err.println("   " + st.nextToken());
        }
        System.err.println();
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

