/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import uk.ac.starlink.datanode.nodes.IconFactory;

public class HTMLViewer
extends JEditorPane {
    public static final String CSS_RESOURCE = "uk/ac/starlink/treeview/docs/help.css";
    private static ClassLoader loader = (class$uk$ac$starlink$treeview$HTMLViewer == null ? (class$uk$ac$starlink$treeview$HTMLViewer = HTMLViewer.class$("uk.ac.starlink.treeview.HTMLViewer")) : class$uk$ac$starlink$treeview$HTMLViewer).getClassLoader();
    static /* synthetic */ Class class$uk$ac$starlink$treeview$HTMLViewer;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$IconFactory;

    public HTMLViewer(String resourceName) throws IOException {
        this(HTMLViewer.getResourceURL(resourceName));
    }

    public HTMLViewer(File file) throws IOException {
        this(new URL("file:" + file));
    }

    public HTMLViewer(URL docURL) throws IOException {
        StyleSheet css;
        this.setEditable(false);
        InputStream docstrm = docURL.openStream();
        if (docstrm == null) {
            throw new FileNotFoundException("Resource " + docURL + " not found");
        }
        HTMLEditorKit htmlkit = new HTMLEditorKit();
        try {
            css = new StyleSheet();
            InputStream cssstrm = loader.getResourceAsStream(CSS_RESOURCE);
            css.loadRules(new InputStreamReader(cssstrm), null);
            htmlkit.setStyleSheet(css);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent ev) {
                if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        css = htmlkit.getStyleSheet();
        HTMLDocument hdoc = new HTMLDocument(css);
        InputStreamReader docrdr = new InputStreamReader(new HTMLDoctorStream(docstrm));
        hdoc.setBase(docURL);
        this.setEditorKit(htmlkit);
        this.setDocument(hdoc);
        try {
            htmlkit.read(docrdr, (Document)hdoc, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static URL getResourceURL(String resourceName) throws FileNotFoundException {
        URL url = loader.getResource(resourceName);
        if (url == null) {
            throw new FileNotFoundException("No resource found at " + resourceName);
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HTMLDoctorStream
    extends InputStream {
        InputStream baseStream;
        InputStream lineStream;

        public HTMLDoctorStream(InputStream baseStream) throws IOException {
            this.baseStream = baseStream;
            this.lineStream = this.nextLine();
        }

        public int read() throws IOException {
            if (this.lineStream == null) {
                return -1;
            }
            int val = this.lineStream.read();
            if (this.lineStream.available() == 0) {
                this.lineStream = this.nextLine();
            }
            return val;
        }

        private InputStream nextLine() throws IOException {
            StringBuffer sb = new StringBuffer();
            int b = 0;
            while (b != 10 && b != -1) {
                b = this.baseStream.read();
                if (b == -1) continue;
                sb.append((char)b);
            }
            int leng = sb.length();
            if (leng == 0) {
                return null;
            }
            Pattern pat = Pattern.compile("(.*?)IconFactory\\.([A-Z0-9_]+)");
            Matcher mat = pat.matcher(sb);
            StringBuffer subst = new StringBuffer();
            int end = 0;
            while (mat.find()) {
                subst.append(mat.group(1));
                subst.append(this.getIconURL(mat.group(2)));
                end = mat.end();
            }
            subst.append(sb.substring(end));
            leng = subst.length();
            byte[] bytes = new byte[leng];
            int i = 0;
            while (i < leng) {
                bytes[i] = (byte)subst.charAt(i);
                ++i;
            }
            return new ByteArrayInputStream(bytes);
        }

        private String getIconURL(String symbol) {
            try {
                Field field = (class$uk$ac$starlink$datanode$nodes$IconFactory == null ? (class$uk$ac$starlink$datanode$nodes$IconFactory = HTMLViewer.class$("uk.ac.starlink.datanode.nodes.IconFactory")) : class$uk$ac$starlink$datanode$nodes$IconFactory).getField(symbol);
                short id = field.getShort(null);
                URL imageURL = IconFactory.getIconURL(id);
                return imageURL == null ? "unknown" : imageURL.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return symbol;
            }
        }
    }
}

