/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jsky.image.ImageProcessor;
import jsky.image.gui.ImageDisplay;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Plot;
import uk.ac.starlink.treeview.AsynchronousImageDisplay;
import uk.ac.starlink.treeview.NDArrayImage;

public class ImageViewPane
extends JPanel {
    private Plot plot;
    private JPanel plotPanel;
    private boolean doPlot = true;

    public ImageViewPane(NDArray nda, FrameSet wcs, boolean async) throws IOException {
        this((RenderedImage)((Object)new NDArrayImage(nda)), nda.getShape().getOrigin(), nda.getBadHandler().getBadValue(), wcs, async);
    }

    private ImageViewPane(RenderedImage im, long[] origin, Number badValue, FrameSet wcs, boolean async) {
        JComponent mainPanel;
        final double badval = badValue == null ? Double.NaN : badValue.doubleValue();
        PlanarImage pim = PlanarImage.wrapRenderedImage((RenderedImage)im);
        Dimension picsize = new Dimension(pim.getWidth(), pim.getHeight());
        ImageDisplay disp = async ? new AsynchronousImageDisplay() : new ImageDisplay();
        disp.setPrescaled(true);
        disp.setImmediateMode(true);
        disp.setPreferredSize(picsize);
        disp.setOpaque(false);
        if (wcs != null) {
            int lgap = 70;
            int rgap = 20;
            int tgap = 40;
            int bgap = 50;
            Dimension holdersize = new Dimension(pim.getWidth() + lgap + rgap, pim.getHeight() + tgap + bgap);
            Rectangle outRect = new Rectangle(holdersize);
            Rectangle inRect = new Rectangle(lgap, tgap, pim.getWidth(), pim.getHeight());
            double[] basebox = new double[]{0.5, 0.5, 0.5 + (double)pim.getWidth(), 0.5 + (double)pim.getHeight()};
            this.plot = new Plot((Frame)wcs, (Rectangle2D)outRect, basebox, lgap, rgap, bgap, tgap);
            this.plot.setGrid(true);
            this.plot.setColour("grid", -2147418368);
            this.plot.setColour("ticks", Color.GREEN.getRGB());
            this.plot.setColour("textlab", Color.BLACK.getRGB());
            this.plot.grid();
            this.plotPanel = new JPanel(){

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    ImageViewPane.this.plot.paint(g);
                }
            };
            this.plotPanel.setOpaque(false);
            JPanel holder = new JPanel();
            holder.setOpaque(false);
            holder.setLayout(null);
            holder.setPreferredSize(holdersize);
            holder.add(this.plotPanel);
            holder.add(disp);
            this.plotPanel.setBounds(outRect);
            disp.setBounds(inRect);
            mainPanel = holder;
        } else {
            disp.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            mainPanel = disp;
        }
        this.add(mainPanel);
        int tx = Math.min(pim.getTileWidth(), pim.getWidth());
        int ty = Math.min(pim.getTileHeight(), pim.getHeight());
        Rectangle2D.Double sample = new Rectangle2D.Double(0.0, 0.0, tx, ty);
        ImageProcessor ip = new ImageProcessor(pim, sample){
            {
                super(x0, x1);
                this.setBlank(badval);
            }
        };
        ip.setReverseY(true);
        boolean done = false;
        int ix = 0;
        while (ix < pim.getWidth() / tx && !done) {
            int iy = 0;
            while (iy < pim.getHeight() / ty && !done) {
                Rectangle2D.Double samp = new Rectangle2D.Double((double)ix * (double)tx, (double)iy * (double)ty, tx, ty);
                ip.autoSetCutLevels(98.0, samp);
                if (ip.getLowCut() < ip.getHighCut()) {
                    done = true;
                }
                ++iy;
            }
            ++ix;
        }
        ip.update();
        disp.setImageProcessor(ip);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setDoPlot(boolean doPlot) {
        this.doPlot = doPlot;
    }

    public void rePlot() {
        this.plot.clear();
        if (this.doPlot) {
            this.plot.grid();
        }
        this.plotPanel.repaint();
    }
}

