/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Plot;
import uk.ac.starlink.datanode.viewers.TreeviewLAF;
import uk.ac.starlink.treeview.ImageViewPane;

class ImageViewer
extends JPanel {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$treeview$ImageViewer;

    public ImageViewer(NDArray nda, FrameSet wcs) throws IOException {
        this(nda, wcs, true);
    }

    public ImageViewer(NDArray nda, FrameSet wcs, boolean async) throws IOException {
        super(new BorderLayout());
        final ImageViewPane view = new ImageViewPane(nda, wcs, async);
        this.add((Component)view, "Center");
        TreeviewLAF.configureMainPanel(view);
        Box controlBox = new Box(1);
        if (wcs != null) {
            int nfrm = wcs.getNframe();
            String[] frameNames = new String[nfrm + 1];
            frameNames[0] = "no grid";
            int i = 0;
            while (i < nfrm) {
                frameNames[i + 1] = i + 1 + ": " + wcs.getFrame(i + 1).getDomain();
                ++i;
            }
            final JComboBox<String> selecter = new JComboBox<String>(frameNames);
            final Plot plot = view.getPlot();
            if (!$assertionsDisabled && plot == null) {
                throw new AssertionError();
            }
            selecter.setSelectedIndex(plot.getCurrent() - 1);
            selecter.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        int currentFrame = selecter.getSelectedIndex();
                        if (currentFrame == 0) {
                            view.setDoPlot(false);
                        } else {
                            view.setDoPlot(true);
                            plot.setCurrent(currentFrame + 1);
                        }
                        view.rePlot();
                    }
                }
            });
            Box selecterBox = new Box(0);
            selecterBox.add(new JLabel("Coordinate grid: "));
            selecterBox.add(selecter);
            selecterBox.add(Box.createGlue());
            TreeviewLAF.configureControl(selecterBox);
            controlBox.add(selecterBox);
        }
        if (controlBox.getComponentCount() > 0) {
            TreeviewLAF.configureControlPanel(controlBox);
            this.add((Component)controlBox, "North");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$treeview$ImageViewer == null ? (class$uk$ac$starlink$treeview$ImageViewer = ImageViewer.class$("uk.ac.starlink.treeview.ImageViewer")) : class$uk$ac$starlink$treeview$ImageViewer).desiredAssertionStatus();
    }
}

