/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import com.sun.media.jai.codec.ImageCodec;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.jaiutil.SimpleRenderedImage;

public class NDArrayImage
extends SimpleRenderedImage {
    private ArrayAccess acc;
    private int defaultTileWidth = 200;
    private int defaultTileHeight = 200;
    private static final int MAX_TILE_BYTES = 0x4000000;
    private long[] origin;
    public static final TileCache tileCache = JAI.getDefaultInstance().getTileCache();

    public NDArrayImage(NDArray nda) throws IOException {
        OrderedNDShape shape = nda.getShape();
        if (shape.getNumDims() != 2) {
            throw new IllegalArgumentException("NDArray " + nda + " not 2-d");
        }
        this.acc = nda.getAccess();
        this.origin = shape.getOrigin();
        long[] dims = shape.getDims();
        this.width = (int)dims[0];
        this.height = (int)dims[1];
        this.tileWidth = this.defaultTileWidth;
        if (this.width / this.tileWidth <= 1) {
            this.tileWidth = this.width;
        }
        this.tileHeight = this.defaultTileHeight;
        if (this.height / this.tileHeight <= 1) {
            this.tileHeight = this.height;
        }
        this.sampleModel = NDArrayImage.makeSampleModel(NDArrayImage.getDataType(nda.getType()), this.tileWidth, this.tileHeight);
        this.colorModel = ImageCodec.createComponentColorModel((SampleModel)this.sampleModel);
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        Raster tile = tileCache.getTile((RenderedImage)((Object)this), tileX, tileY);
        if (tile == null) {
            Point origin = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
            tile = RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (Point)origin);
            this.fillTile(tile);
            tileCache.add((RenderedImage)((Object)this), tileX, tileY, tile);
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTile(Raster tile) {
        long[] tOrigin = new long[]{(long)tile.getMinX() + this.origin[0], (long)tile.getMinY() + this.origin[1]};
        int[] tDims = new int[]{tile.getWidth(), tile.getHeight()};
        NDShape tileShape = new NDShape(tOrigin, tDims);
        Object destArray = this.getArrayData(tile.getDataBuffer());
        try {
            NDArrayImage nDArrayImage = this;
            synchronized (nDArrayImage) {
                this.acc.readTile(destArray, tileShape);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static SampleModel makeSampleModel(int dataType, int tileWidth, int tileHeight) {
        int[] bandOffsets = new int[]{0};
        int pixelStride = 1;
        int scanlineStride = tileWidth;
        return RasterFactory.createPixelInterleavedSampleModel((int)dataType, (int)tileWidth, (int)tileHeight, (int)pixelStride, (int)scanlineStride, (int[])bandOffsets);
    }

    private Object getArrayData(DataBuffer dbuf) {
        Type type = this.acc.getType();
        if (type == Type.BYTE) {
            return ((DataBufferByte)dbuf).getData();
        }
        if (type == Type.SHORT) {
            return ((DataBufferShort)dbuf).getData();
        }
        if (type == Type.INT) {
            return ((DataBufferInt)dbuf).getData();
        }
        if (type == Type.FLOAT) {
            if (dbuf instanceof java.awt.image.DataBufferFloat) {
                return ((java.awt.image.DataBufferFloat)dbuf).getData();
            }
            return ((DataBufferFloat)dbuf).getData();
        }
        if (type == Type.DOUBLE) {
            if (dbuf instanceof java.awt.image.DataBufferDouble) {
                return ((java.awt.image.DataBufferDouble)dbuf).getData();
            }
            return ((DataBufferDouble)dbuf).getData();
        }
        return null;
    }

    private static int getDataType(Type type) {
        if (type == Type.BYTE) {
            return 0;
        }
        if (type == Type.SHORT) {
            return 2;
        }
        if (type == Type.INT) {
            return 3;
        }
        if (type == Type.FLOAT) {
            return 4;
        }
        if (type == Type.DOUBLE) {
            return 5;
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            tileCache.removeTiles((RenderedImage)((Object)this));
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

