/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Element;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxIO;
import uk.ac.starlink.treeview.SogNdxDisplayer;
import uk.ac.starlink.treeview.SplatNdxDisplayer;
import uk.ac.starlink.util.SourceReader;

public abstract class NdxDisplayer {
    private URL endpoint;
    private String displayMethod;

    protected NdxDisplayer(String endpoint, String displayMethod) {
        try {
            this.endpoint = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Bad URL " + endpoint).initCause(e);
        }
        this.displayMethod = displayMethod;
    }

    public abstract boolean localDisplay(Ndx var1, boolean var2);

    public boolean canDisplay(Ndx ndx) {
        return true;
    }

    public boolean display(Ndx ndx, boolean embedded) {
        return this.soapDisplay(ndx) || this.localDisplay(ndx, embedded);
    }

    public boolean soapDisplay(Ndx ndx) {
        Element el;
        if (this.endpoint == null || this.displayMethod == null) {
            return false;
        }
        if (!ndx.isPersistent()) {
            return false;
        }
        try {
            Source xsrc = ndx.getHdxFacade().getSource(null);
            el = (Element)new SourceReader().getDOM(xsrc);
        }
        catch (TransformerException e) {
            return false;
        }
        catch (HdxException e) {
            return false;
        }
        try {
            this.attemptCall(el);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void attemptCall(Element el) throws RemoteException, ServiceException {
        Call call = this.getCall();
        call.setOperationName(this.displayMethod);
        call.addParameter("element", XMLType.SOAP_ELEMENT, ParameterMode.IN);
        call.setReturnType(XMLType.AXIS_VOID);
        call.invoke(new Object[]{el});
    }

    private Call getCall() throws ServiceException {
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(this.endpoint);
        return call;
    }

    public static void main(String[] args) {
        NdxIO ndxIO = new NdxIO();
        boolean trouble = false;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            try {
                Ndx ndx = ndxIO.makeNdx(arg, AccessMode.READ);
                String failmsg = null;
                if (ndx == null) {
                    failmsg = "not an NDX";
                } else {
                    OrderedNDShape shape = ndx.getImage().getShape();
                    int ndim = shape.getNumDims();
                    if (ndim == 1) {
                        if (!SplatNdxDisplayer.getInstance().display(ndx, false)) {
                            failmsg = "SPLAT failed to display";
                        }
                    } else if (ndim == 2) {
                        if (!SogNdxDisplayer.getInstance().display(ndx, false)) {
                            failmsg = "SoG failed to display";
                        }
                    } else {
                        failmsg = "No displayer for " + ndim + " dimensions";
                    }
                }
                if (failmsg != null) {
                    System.err.println(arg + ": " + failmsg);
                    trouble = true;
                }
            }
            catch (IOException e) {
                System.err.println(arg + ": " + e.toString());
            }
            ++i;
        }
    }
}

