/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.MouldArrayImpl;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.WindowArrayImpl;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.datanode.viewers.TreeviewLAF;
import uk.ac.starlink.treeview.ImageViewer;

public class SliceViewer
extends JPanel {
    private NDArray nda;
    private FrameSet wcs;
    private Order order;
    private OrderedNDShape depthShape;
    private JComboBox orienter = new JComboBox();
    private JSlider slider = new JSlider();
    private JLabel planeLabel = new JLabel();
    private Set planeSet = new HashSet();
    private CardLayout flipper = new CardLayout();
    private JPanel imageHolder = new JPanel(this.flipper);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$treeview$SliceViewer;

    public SliceViewer(NDArray nda, FrameSet wcs) {
        super(new BorderLayout());
        this.nda = nda;
        this.wcs = wcs;
        this.order = nda.getShape().getOrder();
        Box controlBox = new Box(1);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SliceViewer.this.updateSliderPosition();
            }
        });
        OrderedNDShape shape = nda.getShape();
        int ndim = shape.getNumDims();
        long[] dims = shape.getDims();
        long[] origin = shape.getOrigin();
        int i = 0;
        while (i < ndim) {
            int j = i + 1;
            while (j < ndim) {
                if (dims[i] > 1L && dims[j] > 1L) {
                    long[] depthOrigin = (long[])origin.clone();
                    long[] depthDims = (long[])dims.clone();
                    depthOrigin[i] = Long.MIN_VALUE;
                    depthOrigin[j] = Long.MIN_VALUE;
                    depthDims[i] = 1L;
                    depthDims[j] = 1L;
                    NDShape dshape = new NDShape(depthOrigin, depthDims);
                    this.orienter.addItem(dshape);
                }
                ++j;
            }
            ++i;
        }
        this.orienter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    SliceViewer.this.updateOrientation();
                }
            }
        });
        int norient = this.orienter.getItemCount();
        if (norient < 1) {
            throw new IllegalArgumentException("Too few non-dummy dimensions " + shape);
        }
        this.add((Component)this.imageHolder, "Center");
        Box orientBox = new Box(0);
        orientBox.add(new JLabel("Orientation selector: "));
        orientBox.add(this.orienter);
        orientBox.add(Box.createGlue());
        controlBox.add(orientBox);
        Box sliderBox = new Box(0);
        sliderBox.add(new JLabel("Slice selector: "));
        sliderBox.add(this.slider);
        sliderBox.add(new JLabel("    "));
        sliderBox.add(this.planeLabel);
        controlBox.add(sliderBox);
        if (controlBox.getComponentCount() > 0) {
            TreeviewLAF.configureControlPanel(controlBox);
            this.add((Component)controlBox, "North");
        }
        this.orienter.setSelectedIndex(0);
        this.updateOrientation();
    }

    private void updateSliderPosition() {
        int value = this.slider.getValue();
        long[] spec = this.depthShape.offsetToPosition((long)value);
        String name = this.makeName(spec);
        this.planeLabel.setText(name + "   ");
        if (!this.slider.getValueIsAdjusting()) {
            if (!this.planeSet.contains(name)) {
                try {
                    this.planeSet.add(name);
                    NDArray slice = SliceViewer.getSlice(this.nda, spec);
                    if (!$assertionsDisabled && slice.getShape().getNumDims() != 2) {
                        throw new AssertionError();
                    }
                    ImageViewer iv = new ImageViewer(slice, null, false);
                    this.imageHolder.add((Component)iv, name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.flipper.show(this.imageHolder, name);
        }
    }

    private void updateOrientation() {
        NDShape dshape = (NDShape)this.orienter.getSelectedItem();
        if (!dshape.equals((Object)this.depthShape)) {
            this.depthShape = new OrderedNDShape(dshape, this.order);
            this.slider.setMinimum(0);
            this.slider.setMaximum((int)(this.depthShape.getNumPixels() - 1L));
            this.slider.setValue(0);
        }
    }

    private static NDArray getSlice(NDArray nda, long[] spec) throws IOException {
        int ndim = spec.length;
        OrderedNDShape shape = nda.getShape();
        long[] origin = shape.getOrigin();
        long[] dims = shape.getDims();
        long[] windowOrigin = shape.getOrigin();
        long[] windowDims = shape.getDims();
        int nok = 0;
        int i = 0;
        while (i < ndim) {
            if (spec[i] == Long.MIN_VALUE) {
                windowOrigin[i] = origin[i];
                windowDims[i] = dims[i];
                ++nok;
            } else {
                windowOrigin[i] = spec[i];
                windowDims[i] = 1L;
            }
            ++i;
        }
        long[] sliceOrigin = new long[nok];
        long[] sliceDims = new long[nok];
        int iok = 0;
        int i2 = 0;
        while (i2 < ndim) {
            if (spec[i2] == Long.MIN_VALUE) {
                sliceOrigin[iok] = windowOrigin[i2];
                sliceDims[iok] = windowDims[i2];
                ++iok;
            }
            ++i2;
        }
        if (!$assertionsDisabled && iok != nok) {
            throw new AssertionError();
        }
        NDShape sliceShape = new NDShape(sliceOrigin, sliceDims);
        NDShape window = new NDShape(windowOrigin, windowDims);
        BridgeNDArray winarray = new BridgeNDArray((ArrayImpl)new WindowArrayImpl(nda, window));
        BridgeNDArray slicearray = new BridgeNDArray((ArrayImpl)new MouldArrayImpl((NDArray)winarray, sliceShape));
        return slicearray;
    }

    private String makeName(long[] spec) {
        return NDShape.toString((long[])spec);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$treeview$SliceViewer == null ? (class$uk$ac$starlink$treeview$SliceViewer = SliceViewer.class$("uk.ac.starlink.treeview.SliceViewer")) : class$uk$ac$starlink$treeview$SliceViewer).desiredAssertionStatus();
    }
}

