/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.treeview;

import java.io.IOException;
import uk.ac.starlink.jaiutil.HDXImage;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.sog.SOG;
import uk.ac.starlink.sog.SOGNavigatorImageDisplay;
import uk.ac.starlink.sog.SOGNavigatorImageDisplayFrame;
import uk.ac.starlink.treeview.NdxDisplayer;

public class SogNdxDisplayer
extends NdxDisplayer {
    private SOG sog;
    private static SogNdxDisplayer instance;

    public SogNdxDisplayer() {
        super("http://localhost:8082/services/SOGRemoteServices", "showNDX");
    }

    public static synchronized SogNdxDisplayer getInstance() {
        if (instance == null) {
            instance = new SogNdxDisplayer();
        }
        return instance;
    }

    public boolean canDisplay(Ndx ndx) {
        return true;
    }

    public boolean localDisplay(Ndx ndx, boolean embedded) {
        try {
            this.getImageDisplay(embedded).setHDXImage(new HDXImage(ndx));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private synchronized SOGNavigatorImageDisplay getImageDisplay(boolean embedded) {
        SOGNavigatorImageDisplay imageDisplay = null;
        if (this.sog == null) {
            this.sog = new SOG();
            this.sog.setDoExit(!embedded);
            imageDisplay = (SOGNavigatorImageDisplay)this.sog.getImageDisplay();
        } else {
            imageDisplay = (SOGNavigatorImageDisplay)this.sog.getImageDisplay();
            SOGNavigatorImageDisplayFrame frame = (SOGNavigatorImageDisplayFrame)imageDisplay.newWindow();
            imageDisplay = (SOGNavigatorImageDisplay)frame.getImageDisplayControl().getImageDisplay();
            imageDisplay.setDoExit(!embedded);
        }
        return imageDisplay;
    }
}

