/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.CmpMap;
import uk.ac.starlink.ast.Mapping;
import uk.ac.starlink.diva.FigureProps;
import uk.ac.starlink.diva.interp.Interpolator;

public class AstFigureProps
extends FigureProps {
    private double[] xin = new double[2];
    private double[] yin = new double[2];

    public AstFigureProps() {
    }

    public AstFigureProps(FigureProps props) {
        super(props);
    }

    public void decode(Element rootElement, Mapping oldMapping, Mapping newMapping) {
        super.decode(rootElement);
        if (oldMapping != null && newMapping != null) {
            newMapping.setInvert(true);
            Mapping mapping = new CmpMap(oldMapping, newMapping, true).simplify();
            Rectangle2D.Double r = new Rectangle2D.Double(this.getX1(), this.getY1(), this.getWidth(), this.getHeight());
            this.transform(r, mapping);
            this.setX1(r.x);
            this.setY1(r.y);
            this.setWidth(r.width);
            this.setHeight(r.height);
            r.x = this.getX2();
            r.y = this.getY2();
            this.transform(r, mapping);
            this.setX2(r.x);
            this.setY2(r.y);
            Interpolator i = this.getInterpolator();
            if (i != null) {
                this.transform(i.getXCoords(), i.getYCoords(), mapping);
                i.setCoords(i.getXCoords(), i.getYCoords(), true);
            }
            if (this.getXArray() != null) {
                this.transform(this.getXArray(), this.getYArray(), mapping);
            }
            newMapping.setInvert(false);
        }
    }

    public void transform(Rectangle2D.Double r, Mapping mapping) {
        this.xin[0] = r.getX();
        this.xin[1] = this.xin[0] + r.getWidth();
        this.yin[0] = r.getY();
        this.yin[1] = this.yin[0] + r.getHeight();
        this.transform(this.xin, this.yin, mapping);
        r.x = Math.min(this.xin[0], this.xin[1]);
        r.y = Math.min(this.yin[0], this.yin[1]);
        r.width = Math.abs(this.xin[0] - this.xin[1]);
        r.height = Math.abs(this.yin[0] - this.yin[1]);
    }

    public void transform(double[] x, double[] y, Mapping mapping) {
        double[][] res = mapping.tran2(x.length, x, y, true);
        int i = 0;
        while (i < x.length) {
            x[i] = res[0][i];
            y[i] = res[1][i];
            ++i;
        }
    }
}

