/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstAxes;
import uk.ac.starlink.ast.gui.AstDoubleField;
import uk.ac.starlink.ast.gui.LineControls;
import uk.ac.starlink.ast.gui.PlotController;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class AxesControls
extends JPanel
implements PlotControls,
ChangeListener {
    private AstAxes astAxes = null;
    protected PlotController controller = null;
    private JCheckBox showX = new JCheckBox();
    private JCheckBox showY = new JCheckBox();
    private JCheckBox logX = new JCheckBox();
    private JCheckBox logY = new JCheckBox();
    private JCheckBox interior = new JCheckBox();
    private AstDoubleField xLabelAt = null;
    private AstDoubleField yLabelAt = null;
    private LineControls xLineControls = null;
    private LineControls yLineControls = null;
    private boolean inhibitLineChangeListener = false;
    private static String defaultTitle = "Axes display properties:";
    private static String defaultName = "Axes";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstAxes;

    public AxesControls(AbstractPlotControlsModel astAxes, PlotController controller) {
        this.controller = controller;
        this.initUI();
        this.setAstAxes((AstAxes)astAxes);
    }

    private void initUI() {
        this.showX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxesControls.this.matchXShow();
            }
        });
        this.showY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxesControls.this.matchYShow();
            }
        });
        this.logX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxesControls.this.matchXLog();
            }
        });
        this.logY.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxesControls.this.matchYLog();
            }
        });
        this.interior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxesControls.this.matchInterior();
            }
        });
        this.yLabelAt = new AstDoubleField(0.0, this.controller, 2);
        this.yLabelAt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxesControls.this.matchYLabelAt();
            }
        });
        this.xLabelAt = new AstDoubleField(0.0, this.controller, 1);
        this.xLabelAt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxesControls.this.matchXLabelAt();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Show X:", false);
        layouter.add((Component)this.showX, true);
        layouter.add("Show Y:", false);
        layouter.add((Component)this.showY, true);
        layouter.add("Log X:", false);
        layouter.add((Component)this.logX, true);
        layouter.add("Log Y:", false);
        layouter.add((Component)this.logY, true);
        layouter.add("Interior:", false);
        layouter.add((Component)this.interior, true);
        layouter.add("X origin:", false);
        layouter.add((Component)this.yLabelAt, true);
        layouter.add("Y origin:", false);
        layouter.add((Component)this.xLabelAt, true);
        this.addXLineControls(layouter);
        this.addYLineControls(layouter);
        layouter.eatSpare();
        this.showX.setToolTipText("Display an X axis");
        this.showY.setToolTipText("Display a Y axis");
        this.logX.setToolTipText("Use logarithmic scaling of X axis");
        this.logY.setToolTipText("Use logarithmic scaling of Y axis");
        this.interior.setToolTipText("Display axes in interior, if needed");
        this.xLabelAt.setToolTipText("Origin coordinate for Y axis (units of Y), <Return> to accept");
        this.yLabelAt.setToolTipText("Origin coordinate for X axis (units of X), <Return> to accept");
    }

    public void setAstAxes(AstAxes astAxes) {
        this.astAxes = astAxes;
        astAxes.addChangeListener(this);
        this.updateFromAstAxes();
    }

    private void updateFromAstAxes() {
        this.astAxes.removeChangeListener(this);
        this.showX.setSelected(this.astAxes.getXShown());
        this.showY.setSelected(this.astAxes.getYShown());
        this.logX.setSelected(this.astAxes.getXLog());
        this.logY.setSelected(this.astAxes.getYLog());
        this.interior.setSelected(this.astAxes.getInterior());
        this.xLabelAt.setDoubleValue(this.astAxes.getXLabelAt());
        this.yLabelAt.setDoubleValue(this.astAxes.getYLabelAt());
        this.inhibitLineChangeListener = true;
        this.xLineControls.setThick((int)this.astAxes.getXWidth());
        this.xLineControls.setColour(this.astAxes.getXColour());
        this.xLineControls.setStyle(this.astAxes.getXStyle());
        this.yLineControls.setThick((int)this.astAxes.getYWidth());
        this.yLineControls.setColour(this.astAxes.getYColour());
        this.yLineControls.setStyle(this.astAxes.getYStyle());
        this.inhibitLineChangeListener = false;
        this.astAxes.setXState(true);
        this.astAxes.setYState(true);
        this.astAxes.addChangeListener(this);
    }

    public AstAxes getAstAxes() {
        return this.astAxes;
    }

    private void matchXShow() {
        this.astAxes.setXShown(this.showX.isSelected());
    }

    private void matchYShow() {
        this.astAxes.setYShown(this.showY.isSelected());
    }

    private void matchXLog() {
        this.astAxes.setXLog(this.logX.isSelected());
    }

    private void matchYLog() {
        this.astAxes.setYLog(this.logY.isSelected());
    }

    private void matchInterior() {
        this.astAxes.setInterior(this.interior.isSelected());
    }

    protected void matchXLabelAt() {
        this.astAxes.setXLabelAt(this.xLabelAt.getDoubleValue());
    }

    protected void matchYLabelAt() {
        this.astAxes.setYLabelAt(this.yLabelAt.getDoubleValue());
    }

    private void addXLineControls(GridBagLayouter layouter) {
        this.xLineControls = new LineControls(layouter, "X");
        this.xLineControls.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AxesControls.this.matchXLine();
            }
        });
    }

    private void addYLineControls(GridBagLayouter layouter) {
        this.yLineControls = new LineControls(layouter, "Y");
        this.yLineControls.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AxesControls.this.matchYLine();
            }
        });
    }

    protected void matchXLine() {
        if (!this.inhibitLineChangeListener) {
            this.astAxes.removeChangeListener(this);
            this.astAxes.setXWidth(this.xLineControls.getThick());
            this.astAxes.setXStyle(this.xLineControls.getStyle());
            this.astAxes.setXColour(this.xLineControls.getColour());
            this.astAxes.addChangeListener(this);
            this.updateFromAstAxes();
        }
    }

    protected void matchYLine() {
        if (!this.inhibitLineChangeListener) {
            this.astAxes.removeChangeListener(this);
            this.astAxes.setYWidth(this.yLineControls.getThick());
            this.astAxes.setYStyle(this.yLineControls.getStyle());
            this.astAxes.setYColour(this.yLineControls.getColour());
            this.astAxes.addChangeListener(this);
            this.updateFromAstAxes();
        }
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.astAxes.setDefaults();
        this.xLineControls.reset();
        this.yLineControls.reset();
        this.updateFromAstAxes();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astAxes;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstAxes == null ? (class$uk$ac$starlink$ast$gui$AstAxes = AxesControls.class$("uk.ac.starlink.ast.gui.AstAxes")) : class$uk$ac$starlink$ast$gui$AstAxes;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstAxes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

