/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstNumberLabels;
import uk.ac.starlink.ast.gui.ColourIcon;
import uk.ac.starlink.ast.gui.FontChangedEvent;
import uk.ac.starlink.ast.gui.FontChangedListener;
import uk.ac.starlink.ast.gui.FontControls;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class AxisNumLabControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected AstNumberLabels astNumberLabels = null;
    protected JLabel display = new JLabel("123456789.0E1");
    protected JCheckBox xShowNumbers = new JCheckBox();
    protected JCheckBox yShowNumbers = new JCheckBox();
    protected JCheckBox logLabelSet = new JCheckBox();
    protected JCheckBox xLogLabel = new JCheckBox();
    protected JCheckBox yLogLabel = new JCheckBox();
    protected JCheckBox xRotateNumbers = new JCheckBox();
    protected JCheckBox yRotateNumbers = new JCheckBox();
    protected JSpinner xGapSpinner = null;
    protected JSpinner yGapSpinner = null;
    protected SpinnerNumberModel xSpinnerModel = new SpinnerNumberModel(0.0, -0.5, 0.5, 0.005);
    protected SpinnerNumberModel ySpinnerModel = new SpinnerNumberModel(0.0, -0.5, 0.5, 0.005);
    protected JButton colourButton = new JButton();
    protected ColourIcon colourIcon = new ColourIcon(Color.black);
    protected FontControls fontControls = null;
    protected JComboBox digitsField = new JComboBox();
    protected static String defaultTitle = "Axis number label properties:";
    protected static String defaultName = "Axis numbers";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstNumberLabels;

    public AxisNumLabControls(AbstractPlotControlsModel astNumberLabels) {
        this.initUI();
        this.setAstNumberLabels((AstNumberLabels)astNumberLabels);
    }

    protected void initUI() {
        this.xShowNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchXShown();
            }
        });
        this.yShowNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchYShown();
            }
        });
        this.logLabelSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchLogLabelSet();
            }
        });
        this.xLogLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchXLogLabel();
            }
        });
        this.yLogLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchYLogLabel();
            }
        });
        this.xRotateNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchXRotate();
            }
        });
        this.yRotateNumbers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchYRotate();
            }
        });
        this.colourButton.setIcon(this.colourIcon);
        this.colourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.chooseColour();
            }
        });
        this.xGapSpinner = new JSpinner(this.xSpinnerModel);
        this.xGapSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AxisNumLabControls.this.matchXGap();
            }
        });
        this.yGapSpinner = new JSpinner(this.ySpinnerModel);
        this.yGapSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AxisNumLabControls.this.matchYGap();
            }
        });
        this.digitsField.addItem("Default");
        int i = 0;
        while (i < 18) {
            this.digitsField.addItem(new Integer(i));
            ++i;
        }
        this.digitsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisNumLabControls.this.matchDigits();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Sample:", false);
        layouter.add((Component)this.display, true);
        layouter.add("Show X:", false);
        layouter.add((Component)this.xShowNumbers, true);
        layouter.add("Show Y:", false);
        layouter.add((Component)this.yShowNumbers, true);
        layouter.add("Set log labelling:", false);
        layouter.add((Component)this.logLabelSet, true);
        layouter.add("X log labelling:", false);
        layouter.add((Component)this.xLogLabel, true);
        layouter.add("Y log labelling:", false);
        layouter.add((Component)this.yLogLabel, true);
        layouter.add("Rotate X:", false);
        layouter.add((Component)this.xRotateNumbers, true);
        layouter.add("Rotate Y:", false);
        layouter.add((Component)this.yRotateNumbers, true);
        this.addFontControls(layouter);
        layouter.add("Colour:", false);
        layouter.add((Component)this.colourButton, false);
        layouter.eatLine();
        layouter.add("X gap:", false);
        layouter.add((Component)this.xGapSpinner, false);
        layouter.eatLine();
        layouter.add("Y gap:", false);
        layouter.add((Component)this.yGapSpinner, false);
        layouter.eatLine();
        layouter.add("Digits:", false);
        layouter.add((Component)this.digitsField, false);
        layouter.eatLine();
        layouter.eatSpare();
        this.colourButton.setToolTipText("Select a colour");
        this.xGapSpinner.setToolTipText("Set the gap between numbers and axis");
        this.yGapSpinner.setToolTipText("Set the gap between numbers and axis");
        this.logLabelSet.setToolTipText("Use log/exponential labelling values to override defaults");
        this.xLogLabel.setToolTipText("Use log/exponential labelling for X axis ticks");
        this.yLogLabel.setToolTipText("Use log/exponentail labelling for Y axis ticks");
        this.digitsField.setToolTipText("Digits of precision used in formatted numbers");
        this.xShowNumbers.setToolTipText("Display X labels");
        this.yShowNumbers.setToolTipText("Display Y labels");
        this.xRotateNumbers.setToolTipText("Display re-oriented X labels if needed");
        this.yRotateNumbers.setToolTipText("Display re-oriented Y labels if needed");
    }

    public void setAstNumberLabels(AstNumberLabels astNumberLabels) {
        this.astNumberLabels = astNumberLabels;
        astNumberLabels.addChangeListener(this);
        this.updateFromAstNumberLabels();
    }

    protected void updateFromAstNumberLabels() {
        this.astNumberLabels.removeChangeListener(this);
        this.xShowNumbers.setSelected(this.astNumberLabels.getXShown());
        this.yShowNumbers.setSelected(this.astNumberLabels.getYShown());
        this.logLabelSet.setSelected(this.astNumberLabels.getLogLabelSet());
        this.xLogLabel.setSelected(this.astNumberLabels.getXLogLabel());
        this.yLogLabel.setSelected(this.astNumberLabels.getYLogLabel());
        this.matchLogLabelSet();
        this.xRotateNumbers.setSelected(this.astNumberLabels.getXRotated());
        this.yRotateNumbers.setSelected(this.astNumberLabels.getYRotated());
        this.display.setFont(this.astNumberLabels.getFont());
        this.fontControls.setFont(this.astNumberLabels.getFont());
        this.colourIcon.setMainColour(this.astNumberLabels.getColour());
        this.colourButton.repaint();
        this.display.setForeground(this.astNumberLabels.getColour());
        this.xSpinnerModel.setValue(new Double(this.astNumberLabels.getXGap()));
        this.ySpinnerModel.setValue(new Double(this.astNumberLabels.getYGap()));
        int digits = this.astNumberLabels.getDigits();
        if (digits != -1) {
            this.digitsField.setSelectedItem(new Integer(digits));
        } else {
            this.digitsField.setSelectedItem("Default");
        }
        this.astNumberLabels.setXState(true);
        this.astNumberLabels.setYState(true);
        this.astNumberLabels.addChangeListener(this);
    }

    public AstNumberLabels getAstNumberLabels() {
        return this.astNumberLabels;
    }

    private void addFontControls(GridBagLayouter layouter) {
        this.fontControls = new FontControls(layouter, "");
        this.fontControls.addListener(new FontChangedListener(){

            public void fontChanged(FontChangedEvent e) {
                AxisNumLabControls.this.updateFont(e);
            }
        });
    }

    protected void updateFont(FontChangedEvent e) {
        this.setTextFont(e.getFont());
    }

    protected void setTextFont(Font font) {
        if (font != null) {
            this.astNumberLabels.setFont(font);
            this.display.setFont(font);
        }
    }

    protected void matchXShown() {
        this.astNumberLabels.setXShown(this.xShowNumbers.isSelected());
    }

    protected void matchYShown() {
        this.astNumberLabels.setYShown(this.yShowNumbers.isSelected());
    }

    protected void matchLogLabelSet() {
        boolean set = this.logLabelSet.isSelected();
        this.astNumberLabels.setLogLabelSet(set);
        this.xLogLabel.setEnabled(set);
        this.yLogLabel.setEnabled(set);
    }

    protected void matchXLogLabel() {
        this.astNumberLabels.setXLogLabel(this.xLogLabel.isSelected());
    }

    protected void matchYLogLabel() {
        this.astNumberLabels.setYLogLabel(this.yLogLabel.isSelected());
    }

    protected void matchXRotate() {
        this.astNumberLabels.setXRotated(this.xRotateNumbers.isSelected());
    }

    protected void matchYRotate() {
        this.astNumberLabels.setYRotated(this.yRotateNumbers.isSelected());
    }

    protected void matchXGap() {
        this.astNumberLabels.setXGap(this.xSpinnerModel.getNumber().doubleValue());
    }

    protected void matchYGap() {
        this.astNumberLabels.setYGap(this.ySpinnerModel.getNumber().doubleValue());
    }

    protected void matchDigits() {
        Object object = this.digitsField.getSelectedItem();
        int value = -1;
        if (!object.equals("Default")) {
            value = (Integer)object;
        }
        this.astNumberLabels.setDigits(value);
    }

    protected void chooseColour() {
        Color newColour = JColorChooser.showDialog(this, "Select text colour", this.colourIcon.getMainColour());
        if (newColour != null) {
            this.setTextColour(newColour);
        }
    }

    protected void setTextColour(Color colour) {
        if (colour != null) {
            this.colourIcon.setMainColour(colour);
            this.colourButton.repaint();
            this.astNumberLabels.setColour(colour);
            this.display.setForeground(colour);
        }
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.astNumberLabels.setDefaults();
        this.fontControls.setDefaults();
        this.setTextColour(Color.black);
        this.updateFromAstNumberLabels();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astNumberLabels;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstNumberLabels == null ? (class$uk$ac$starlink$ast$gui$AstNumberLabels = AxisNumLabControls.class$("uk.ac.starlink.ast.gui.AstNumberLabels")) : class$uk$ac$starlink$ast$gui$AstNumberLabels;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstNumberLabels();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

