/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import uk.ac.starlink.ast.gui.DecimalDocument;

public class DecimalField
extends JTextField {
    protected DecimalFormat decimalFormat;

    public DecimalField(double value, int columns, DecimalFormat format) {
        super(columns);
        this.setDocument(new DecimalDocument(format));
        this.decimalFormat = format;
        this.setDoubleValue(value);
    }

    public DecimalField(int value, int columns, DecimalFormat format) {
        super(columns);
        this.setDocument(new DecimalDocument(format));
        this.decimalFormat = format;
        this.setIntValue(value);
    }

    public double getDoubleValue() {
        double retVal = 0.0;
        try {
            retVal = this.decimalFormat.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {}
        return retVal;
    }

    public int getIntValue() {
        int retVal = 0;
        try {
            retVal = this.decimalFormat.parse(this.getText()).intValue();
        }
        catch (ParseException e) {}
        return retVal;
    }

    public void setDoubleValue(double value) {
        this.setText(this.decimalFormat.format(value));
    }

    public void setIntValue(int value) {
        this.setText(this.decimalFormat.format(value));
    }
}

