/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class GraphicsHints
extends AbstractPlotControlsModel {
    protected boolean textAntialiased;
    protected boolean allAntialiased;

    public GraphicsHints() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.textAntialiased = true;
        this.allAntialiased = false;
        this.fireChanged();
    }

    public boolean isTextAntialiased() {
        return this.textAntialiased;
    }

    public boolean isAllAntialiased() {
        return this.allAntialiased;
    }

    public void setTextAntialiased(boolean textAntialiased) {
        this.textAntialiased = textAntialiased;
        this.fireChanged();
    }

    public void setAllAntialiased(boolean allAntialiased) {
        this.allAntialiased = allAntialiased;
        this.fireChanged();
    }

    public void applyRenderingHints(Graphics2D g2) {
        if (this.allAntialiased) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else if (this.textAntialiased) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public String getTagName() {
        return "graphicshints";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "textAntialiased", this.textAntialiased);
        this.addChildElement(rootElement, "allAntialiased", this.allAntialiased);
    }

    public void setFromString(String name, String value) {
        if (name.equals("textAntialiased")) {
            this.setTextAntialiased(this.booleanFromString(value));
            return;
        }
        if (name.equals("allAntialiased")) {
            this.setAllAntialiased(this.booleanFromString(value));
            return;
        }
    }
}

