/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.GraphicsHints;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class GraphicsHintsControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected GraphicsHints hints = null;
    protected JCheckBox textAntialiased = new JCheckBox();
    protected JCheckBox allAntialiased = new JCheckBox();
    protected static String defaultTitle = "Graphics rendering hints:";
    protected static String defaultName = "Rendering";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$GraphicsHints;

    public GraphicsHintsControls(AbstractPlotControlsModel hints) {
        this.initUI();
        this.setGraphicsHints((GraphicsHints)hints);
    }

    protected void initUI() {
        this.textAntialiased.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicsHintsControls.this.matchTextState();
            }
        });
        this.allAntialiased.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicsHintsControls.this.matchAllState();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Anti-aliased text:", false);
        layouter.add((Component)this.textAntialiased, true);
        layouter.add("Anti-aliased everything:", false);
        layouter.add((Component)this.allAntialiased, true);
        layouter.eatSpare();
        this.textAntialiased.setToolTipText("Render text using antialiasing");
        this.allAntialiased.setToolTipText("Render everthing using antialiasing (can be slow)");
    }

    public void setGraphicsHints(GraphicsHints hints) {
        this.hints = hints;
        hints.addChangeListener(this);
        this.updateFromGraphicsHints();
    }

    protected void updateFromGraphicsHints() {
        this.hints.removeChangeListener(this);
        this.textAntialiased.setSelected(this.hints.isTextAntialiased());
        this.allAntialiased.setSelected(this.hints.isAllAntialiased());
        this.hints.addChangeListener(this);
    }

    public GraphicsHints getGraphicsHints() {
        return this.hints;
    }

    protected void matchTextState() {
        this.hints.setTextAntialiased(this.textAntialiased.isSelected());
    }

    protected void matchAllState() {
        this.hints.setAllAntialiased(this.allAntialiased.isSelected());
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.hints.setDefaults();
        this.updateFromGraphicsHints();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.hints;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$GraphicsHints == null ? (class$uk$ac$starlink$ast$gui$GraphicsHints = GraphicsHintsControls.class$("uk.ac.starlink.ast.gui.GraphicsHints")) : class$uk$ac$starlink$ast$gui$GraphicsHints;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromGraphicsHints();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

