/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstGrid;
import uk.ac.starlink.ast.gui.LineControls;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class GridControls
extends JPanel
implements PlotControls,
ChangeListener {
    protected AstGrid astGrid = null;
    protected JCheckBox show = new JCheckBox();
    protected LineControls lineControls = null;
    protected boolean inhibitLineChangeListener = false;
    protected static String defaultTitle = "Grid line properties:";
    protected static String defaultName = "GridLines";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstGrid;

    public GridControls(AbstractPlotControlsModel astGrid) {
        this.initUI();
        this.setAstGrid((AstGrid)astGrid);
    }

    protected void initUI() {
        this.show.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GridControls.this.matchShow();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Show:", false);
        layouter.add((Component)this.show, true);
        this.addLineControls(layouter);
        layouter.eatSpare();
        this.show.setToolTipText("Display grid lines in plot");
    }

    public void setAstGrid(AstGrid astGrid) {
        this.astGrid = astGrid;
        astGrid.addChangeListener(this);
        this.updateFromAstGrid();
    }

    protected void updateFromAstGrid() {
        this.astGrid.removeChangeListener(this);
        this.show.setSelected(this.astGrid.getShown());
        this.inhibitLineChangeListener = true;
        this.lineControls.setThick((int)this.astGrid.getWidth());
        this.lineControls.setColour(this.astGrid.getColour());
        this.lineControls.setStyle(this.astGrid.getStyle());
        this.inhibitLineChangeListener = false;
        this.astGrid.setState(true);
        this.astGrid.addChangeListener(this);
    }

    public AstGrid getAstGrid() {
        return this.astGrid;
    }

    protected void matchShow() {
        this.astGrid.setShown(this.show.isSelected());
    }

    private void addLineControls(GridBagLayouter layouter) {
        this.lineControls = new LineControls(layouter, "");
        this.lineControls.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GridControls.this.matchLine();
            }
        });
    }

    protected void matchLine() {
        if (!this.inhibitLineChangeListener) {
            this.astGrid.removeChangeListener(this);
            this.astGrid.setWidth(this.lineControls.getThick());
            this.astGrid.setStyle(this.lineControls.getStyle());
            this.astGrid.setColour(this.lineControls.getColour());
            this.astGrid.addChangeListener(this);
            this.updateFromAstGrid();
        }
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.astGrid.setDefaults();
        this.lineControls.reset();
        this.updateFromAstGrid();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astGrid;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstGrid == null ? (class$uk$ac$starlink$ast$gui$AstGrid = GridControls.class$("uk.ac.starlink.ast.gui.AstGrid")) : class$uk$ac$starlink$ast$gui$AstGrid;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstGrid();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

