/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import uk.ac.starlink.ast.gui.AstStyleBox;
import uk.ac.starlink.ast.gui.ColourIcon;
import uk.ac.starlink.util.gui.GridBagLayouter;

public class LineControls {
    protected JButton colourButton = new JButton();
    protected ColourIcon colourIcon = new ColourIcon(Color.black);
    protected AstStyleBox styleBox = new AstStyleBox();
    protected JComboBox thickBox = new JComboBox();
    protected GridBagLayouter layouter = null;
    protected EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public LineControls(GridBagLayouter layouter, String postfix) {
        this.initUI(layouter, postfix);
    }

    public void reset() {
        this.setColour(Color.black);
        this.setThick(1);
        this.setStyle(1);
    }

    private void initUI(GridBagLayouter layouter, String postfix) {
        this.layouter = layouter;
        layouter.add("Thickness " + postfix + ":", false);
        layouter.add((Component)this.thickBox, false);
        layouter.eatLine();
        layouter.add("Style " + postfix + ":", false);
        layouter.add((Component)this.styleBox, false);
        layouter.eatLine();
        layouter.add("Colour " + postfix + ":", false);
        layouter.add((Component)this.colourButton, false);
        layouter.eatLine();
        int i = 1;
        while (i < 21) {
            this.thickBox.addItem(new Integer(i));
            ++i;
        }
        this.thickBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineControls.this.changeThick();
            }
        });
        this.styleBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineControls.this.changeStyle();
            }
        });
        this.colourButton.setIcon(this.colourIcon);
        this.colourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineControls.this.chooseColour();
            }
        });
        this.thickBox.setToolTipText("Select a thickness for line");
        this.styleBox.setToolTipText("Select a style for line");
        this.colourButton.setToolTipText("Select a colour for line");
    }

    protected void changeThick() {
        this.fireChanged();
    }

    public void setThick(int thick) {
        this.thickBox.setSelectedItem(new Integer(thick));
    }

    public int getThick() {
        Integer thick = (Integer)this.thickBox.getSelectedItem();
        return thick;
    }

    protected void changeStyle() {
        this.fireChanged();
    }

    public void setStyle(int style) {
        this.styleBox.setSelectedStyle(style);
    }

    public int getStyle() {
        return this.styleBox.getSelectedStyle();
    }

    protected void chooseColour() {
        Color newColour = JColorChooser.showDialog(this.layouter.getContainer(), "Select line colour", this.colourIcon.getMainColour());
        if (newColour != null) {
            this.colourIcon.setMainColour(newColour);
            this.fireChanged();
        }
    }

    public Color getColour() {
        return this.colourIcon.getMainColour();
    }

    public void setColour(Color colour) {
        this.colourIcon.setMainColour(colour);
        this.colourButton.repaint();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LineControls.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChanged() {
        Object[] la = this.listeners.getListenerList();
        ChangeEvent e = null;
        int i = la.length - 2;
        while (i >= 0) {
            if (la[i] == (class$javax$swing$event$ChangeListener == null ? LineControls.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)la[i + 1]).stateChanged(e);
            }
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

