/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.AstTitle;
import uk.ac.starlink.ast.gui.ColourIcon;
import uk.ac.starlink.ast.gui.FontChangedEvent;
import uk.ac.starlink.ast.gui.FontChangedListener;
import uk.ac.starlink.ast.gui.FontControls;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.ast.gui.Utilities;
import uk.ac.starlink.util.gui.GridBagLayouter;
import uk.ac.starlink.util.gui.SelectTextField;

public class TitleControls
extends JPanel
implements PlotControls,
ChangeListener,
DocumentListener {
    protected AstTitle astTitle = null;
    protected JCheckBox showTitle = new JCheckBox();
    protected SelectTextField textField = new SelectTextField();
    protected JSpinner gapSpinner = null;
    protected SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0.0, -0.5, 0.5, 0.005);
    protected JButton colourButton = new JButton();
    protected ColourIcon colourIcon = new ColourIcon(Color.black);
    protected FontControls fontControls = null;
    protected boolean inhibitDocumentListener = false;
    protected static String defaultTitle = "Title properties:";
    protected static String defaultName = "Title";
    static /* synthetic */ Class class$uk$ac$starlink$ast$gui$AstTitle;

    public TitleControls(AbstractPlotControlsModel astTitle) {
        this.initUI();
        this.setAstTitle((AstTitle)astTitle);
    }

    protected void initUI() {
        this.showTitle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TitleControls.this.matchShow();
            }
        });
        this.colourButton.setIcon(this.colourIcon);
        this.colourButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TitleControls.this.chooseColour();
            }
        });
        this.textField.getDocument().addDocumentListener(this);
        this.gapSpinner = new JSpinner(this.spinnerModel);
        this.gapSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TitleControls.this.matchGap();
            }
        });
        GridBagLayouter layouter = Utilities.getGridBagLayouter(this);
        layouter.add("Show:", false);
        layouter.add((Component)this.showTitle, true);
        layouter.add("Label:", false);
        layouter.add((Component)this.textField, true);
        this.addFontControls(layouter);
        layouter.add("Colour:", false);
        layouter.add((Component)this.colourButton, false);
        layouter.eatLine();
        layouter.add("Gap:", false);
        layouter.add((Component)this.gapSpinner, false);
        layouter.eatLine();
        layouter.eatSpare();
        this.colourButton.setToolTipText("Select a colour");
        this.textField.setToolTipText("Type in the plot title");
        this.gapSpinner.setToolTipText("Set the gap between title and top of plot");
    }

    public void setAstTitle(AstTitle astTitle) {
        this.astTitle = astTitle;
        astTitle.addChangeListener(this);
        this.updateFromAstTitle();
    }

    protected void updateFromAstTitle() {
        this.astTitle.removeChangeListener(this);
        this.showTitle.setSelected(this.astTitle.getShown());
        if (!this.inhibitDocumentListener) {
            this.textField.setText(this.astTitle.getTitle());
        }
        this.textField.setTextFont(this.astTitle.getFont());
        this.fontControls.setFont(this.astTitle.getFont());
        this.textField.setTextColour(this.astTitle.getColour());
        this.colourIcon.setMainColour(this.astTitle.getColour());
        this.colourButton.repaint();
        this.spinnerModel.setValue(new Double(this.astTitle.getGap()));
        this.astTitle.addChangeListener(this);
    }

    public AstTitle getAstTitle() {
        return this.astTitle;
    }

    private void addFontControls(GridBagLayouter layouter) {
        this.fontControls = new FontControls(layouter, "");
        this.fontControls.addListener(new FontChangedListener(){

            public void fontChanged(FontChangedEvent e) {
                TitleControls.this.updateFont(e);
            }
        });
    }

    public void setText(String text) {
        this.astTitle.setTitle(text);
    }

    protected void matchShow() {
        this.astTitle.setShown(this.showTitle.isSelected());
    }

    protected void matchGap() {
        this.astTitle.setGap(this.spinnerModel.getNumber().doubleValue());
    }

    protected void updateFont(FontChangedEvent e) {
        this.setTextFont(e.getFont());
    }

    protected void setTextFont(Font font) {
        this.astTitle.setFont(font);
    }

    protected void chooseColour() {
        Color newColour = JColorChooser.showDialog(this, "Select text colour", this.colourIcon.getMainColour());
        if (newColour != null) {
            this.setTextColour(newColour);
        }
    }

    protected void setTextColour(Color colour) {
        if (colour != null) {
            this.astTitle.setColour(colour);
        }
    }

    public String getControlsTitle() {
        return defaultTitle;
    }

    public String getControlsName() {
        return defaultName;
    }

    public void reset() {
        this.fontControls.setDefaults();
        this.setTextColour(Color.black);
        this.astTitle.setDefaults();
    }

    public JComponent getControlsComponent() {
        return this;
    }

    public AbstractPlotControlsModel getControlsModel() {
        return this.astTitle;
    }

    public static Class getControlsModelClass() {
        return class$uk$ac$starlink$ast$gui$AstTitle == null ? (class$uk$ac$starlink$ast$gui$AstTitle = TitleControls.class$("uk.ac.starlink.ast.gui.AstTitle")) : class$uk$ac$starlink$ast$gui$AstTitle;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromAstTitle();
    }

    public void changedUpdate(DocumentEvent e) {
        this.matchText();
    }

    public void insertUpdate(DocumentEvent e) {
        this.matchText();
    }

    public void removeUpdate(DocumentEvent e) {
        this.matchText();
    }

    protected void matchText() {
        this.inhibitDocumentListener = true;
        this.astTitle.setTitle(this.textField.getText());
        this.inhibitDocumentListener = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

