/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.registry.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.config.Config;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.registry.common.versionNS.IRegistryInfo;

public class RegistryHelper {
    private static final Log logger = LogFactory.getLog((Class)RegistryHelper.class);
    private static final String REGISTRY_VERSION_PROPERTY = "org.astrogrid.registry.version";
    public static Config conf = null;

    public static IRegistryInfo loadRegistryInfo() {
        IRegistryInfo iri = null;
        String className = "org.astrogrid.registry.common.versionNS.vr" + conf.getString(REGISTRY_VERSION_PROPERTY) + ".Registry";
        logger.debug((Object)("loadRegistryInfo() - attempting to load " + className));
        Class<?> reg = null;
        try {
            reg = Class.forName(className);
        }
        catch (Exception e) {
            logger.info((Object)"loadRegistryInfo() - died at classforname");
            logger.error((Object)"loadRegistryInfo()", (Throwable)e);
        }
        try {
            if (reg != null) {
                iri = (IRegistryInfo)reg.newInstance();
            } else {
                logger.info((Object)"loadRegistryInfo() - reg class was null");
            }
        }
        catch (Exception e) {
            logger.info((Object)"loadRegistryInfo() - died at newinstance");
            logger.error((Object)"loadRegistryInfo()", (Throwable)e);
        }
        return iri;
    }

    static {
        if (conf == null) {
            conf = SimpleConfig.getSingleton();
        }
    }
}

