/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.registry.common;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.registry.common.WSDLBasicInformation;

public class WSDLInformation {
    private static final Log logger = LogFactory.getLog((Class)WSDLInformation.class);

    public static String getNameSpaceFromBinding(String url, String interfaceName) throws RegistryException {
        try {
            WSDLFactory wf = WSDLFactory.newInstance();
            WSDLReader wr = wf.newWSDLReader();
            Definition def = wr.readWSDL(url);
            Map mp = def.getBindings();
            Set bindingSet = mp.keySet();
            Iterator iter = bindingSet.iterator();
            while (iter.hasNext()) {
                QName bindingQName = (QName)iter.next();
                Binding binding = (Binding)mp.get(bindingQName);
                BindingOperation boperation = binding.getBindingOperation(interfaceName, null, null);
                if (boperation == null) {
                    throw new RegistryException("Could not find binding for operation name = " + interfaceName);
                }
                BindingInput bi = boperation.getBindingInput();
                List lst = bi.getExtensibilityElements();
                for (int i = 0; i < lst.size(); ++i) {
                    ExtensibilityElement extElement = (ExtensibilityElement)lst.get(i);
                    if (extElement instanceof SOAPBody) {
                        SOAPBody soapBody = (SOAPBody)extElement;
                        logger.info((Object)("getNameSpaceFromBinding(String, String) - the nanespaceuri from soapbody = " + soapBody.getNamespaceURI()));
                        return soapBody.getNamespaceURI();
                    }
                    logger.info((Object)("getNameSpaceFromBinding(String, String) - the extensiblity type = " + extElement.getElementType().toString()));
                }
            }
        }
        catch (WSDLException wse) {
            throw new RegistryException(wse);
        }
        return null;
    }

    private static void getSoapActionsFromBinding(Binding bind, String portName, WSDLBasicInformation wsdlBasic) {
        List opList = bind.getBindingOperations();
        for (int j = 0; j < opList.size(); ++j) {
            BindingOperation bo = (BindingOperation)opList.get(j);
            List lst = bo.getExtensibilityElements();
            for (int i = 0; i < lst.size(); ++i) {
                ExtensibilityElement extElement = (ExtensibilityElement)lst.get(i);
                if (!(extElement instanceof SOAPOperation)) continue;
                SOAPOperation soapOperation = (SOAPOperation)extElement;
                wsdlBasic.addSoapActionURI(portName + "_" + bo.getName(), soapOperation.getSoapActionURI());
            }
        }
    }

    public static WSDLBasicInformation getBasicInformationFromURL(String url) throws RegistryException {
        WSDLBasicInformation wsdlBasic = null;
        logger.info((Object)("getBasicInformationFromURL(String) - begin getBasicInformationFromURL with url = " + url));
        try {
            WSDLFactory wf = WSDLFactory.newInstance();
            WSDLReader wr = wf.newWSDLReader();
            Definition def = wr.readWSDL(url);
            logger.info((Object)("getBasicInformationFromURL(String) - processed targetnamespace = " + def.getTargetNamespace()));
            wsdlBasic = new WSDLBasicInformation();
            wsdlBasic.setTargetNameSpace(def.getTargetNamespace());
            Map mp = def.getServices();
            Set serviceSet = mp.keySet();
            Iterator iter = serviceSet.iterator();
            while (iter.hasNext()) {
                QName serviceQName = (QName)iter.next();
                Service service = (Service)mp.get(serviceQName);
                Set portSet = service.getPorts().keySet();
                Iterator portIter = portSet.iterator();
                while (portIter.hasNext()) {
                    String portName = (String)portIter.next();
                    Port port = (Port)service.getPorts().get(portName);
                    List lst = port.getExtensibilityElements();
                    for (int i = 0; i < lst.size(); ++i) {
                        ExtensibilityElement extElement = (ExtensibilityElement)lst.get(i);
                        if (!(extElement instanceof SOAPAddress)) continue;
                        SOAPAddress soapAddress = (SOAPAddress)extElement;
                        logger.info((Object)("getBasicInformationFromURL(String) - the locationuri = " + soapAddress.getLocationURI()));
                        wsdlBasic.addEndPoint(port.getName(), soapAddress.getLocationURI());
                    }
                    WSDLInformation.getSoapActionsFromBinding(port.getBinding(), portName, wsdlBasic);
                }
            }
            logger.info((Object)("getBasicInformationFromURL(String) - finished with getBasicInformationFromURL and wsdlBasic = " + wsdlBasic.toString()));
        }
        catch (WSDLException wse) {
            throw new RegistryException(wse);
        }
        return wsdlBasic;
    }
}

