/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.registry.common;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.util.DomHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLHelper {
    private static final Log logger = LogFactory.getLog((Class)XSLHelper.class);
    public static final String DEFAULT_DATABASE_XSL = "XSLDBProcess.xsl";
    public static final String DEFAULT_CASTOR_XML = "CastorXSLProcess.xsl";

    private InputStream loadStyleSheet(String name) {
        ClassLoader loader = this.getClass().getClassLoader();
        return loader.getResourceAsStream(name);
    }

    private InputStream loadDBXSL() {
        ClassLoader loader = this.getClass().getClassLoader();
        return loader.getResourceAsStream(DEFAULT_DATABASE_XSL);
    }

    private InputStream loadCastorXSL() {
        ClassLoader loader = this.getClass().getClassLoader();
        return loader.getResourceAsStream(DEFAULT_CASTOR_XML);
    }

    public String transformADQLToXQL(Node doc, String versionNumber) {
        DOMSource xmlSource = new DOMSource(doc);
        Document resultDoc = null;
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = null;
        is = loader.getResourceAsStream("ADQLToXQL-" + versionNumber + ".xsl");
        logger.info((Object)("transformADQLToXQL(Node, String) - the file resource = ADQLToXQL-" + versionNumber + ".xsl"));
        StreamSource xslSource = new StreamSource(is);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            resultDoc = builder.newDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            Transformer transformer = transformerFactory.newTransformer(xslSource);
            transformer.transform(xmlSource, result);
            String xqlResult = sw.toString();
            if (xqlResult.startsWith("<?")) {
                xqlResult = xqlResult.substring(xqlResult.indexOf("?>") + 2);
            }
            xqlResult = xqlResult.replaceAll("&gt;", ">").replaceAll("&lt;", "<");
            return xqlResult;
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"transformADQLToXQL(Node, String)", (Throwable)pce);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"transformADQLToXQL(Node, String)", (Throwable)tce);
        }
        catch (TransformerException te) {
            logger.error((Object)"transformADQLToXQL(Node, String)", (Throwable)te);
        }
        return null;
    }

    public Document transformToOAI(Node doc, String versionNumber) {
        String fileName = "Resourcev" + versionNumber + "-OAI.xsl";
        DOMSource xmlSource = new DOMSource(doc);
        Document resultDoc = null;
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = null;
        is = loader.getResourceAsStream(fileName);
        StreamSource xslSource = new StreamSource(is);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            resultDoc = builder.newDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMResult result = new DOMResult(resultDoc);
            Transformer transformer = transformerFactory.newTransformer(xslSource);
            transformer.transform(xmlSource, result);
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"transformToOAI(Node, String)", (Throwable)pce);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"transformToOAI(Node, String)", (Throwable)tce);
        }
        catch (TransformerException te) {
            logger.error((Object)"transformToOAI(Node, String)", (Throwable)te);
        }
        return resultDoc;
    }

    public Document transformExistResult(Node doc, String versionNumber, String responseElement) {
        DOMSource xmlSource = new DOMSource(doc);
        Document resultDoc = null;
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = null;
        is = loader.getResourceAsStream("ExistRegistryResult" + versionNumber + ".xsl");
        StreamSource xslSource = new StreamSource(is);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            resultDoc = builder.newDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMResult result = new DOMResult(resultDoc);
            Transformer transformer = transformerFactory.newTransformer(xslSource);
            transformer.transform(xmlSource, result);
            if (responseElement != null && responseElement.trim().length() > 0) {
                Element currentRoot = resultDoc.getDocumentElement();
                Element root = resultDoc.createElement(responseElement);
                root.appendChild(currentRoot);
                resultDoc.appendChild(root);
            }
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"transformExistResult(Node, String, String)", (Throwable)pce);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"transformExistResult(Node, String, String)", (Throwable)tce);
        }
        catch (TransformerException te) {
            logger.error((Object)"transformExistResult(Node, String, String)", (Throwable)te);
        }
        return resultDoc;
    }

    public Document transformUpdate(Node doc, String versionNumber) {
        DOMSource xmlSource = new DOMSource(doc);
        Document resultDoc = null;
        String styleSheetName = "UpdateProcess_" + versionNumber + ".xsl";
        logger.info((Object)("transformUpdate(Node, String) - the stylesheet name = " + styleSheetName));
        StreamSource xslSource = new StreamSource(this.loadStyleSheet(styleSheetName));
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            resultDoc = builder.newDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMResult result = new DOMResult(resultDoc);
            Transformer transformer = transformerFactory.newTransformer(xslSource);
            transformer.transform(xmlSource, result);
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"transformUpdate(Node, String)", (Throwable)pce);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"transformUpdate(Node, String)", (Throwable)tce);
        }
        catch (TransformerException te) {
            logger.error((Object)"transformUpdate(Node, String)", (Throwable)te);
        }
        logger.info((Object)"transformUpdate(Node, String) - THIS IS AFTER THE TRANSFORMUPDATE");
        DomHelper.DocumentToStream((Document)resultDoc, (OutputStream)System.out);
        return resultDoc;
    }

    public Document transformDatabaseProcess(Node doc) {
        DOMSource xmlSource = new DOMSource(doc);
        Document resultDoc = null;
        StreamSource xslSource = new StreamSource(this.loadDBXSL());
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            resultDoc = builder.newDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMResult result = new DOMResult(resultDoc);
            Transformer transformer = transformerFactory.newTransformer(xslSource);
            transformer.transform(xmlSource, result);
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"transformDatabaseProcess(Node)", (Throwable)pce);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"transformDatabaseProcess(Node)", (Throwable)tce);
        }
        catch (TransformerException te) {
            logger.error((Object)"transformDatabaseProcess(Node)", (Throwable)te);
        }
        return resultDoc;
    }

    public Document transformCastorProcess(Node doc) {
        DOMSource xmlSource = new DOMSource(doc);
        Document resultDoc = null;
        StreamSource xslSource = new StreamSource(this.loadCastorXSL());
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            resultDoc = builder.newDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMResult result = new DOMResult(resultDoc);
            Transformer transformer = transformerFactory.newTransformer(xslSource);
            transformer.transform(xmlSource, result);
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"transformCastorProcess(Node)", (Throwable)pce);
        }
        catch (TransformerConfigurationException tce) {
            logger.error((Object)"transformCastorProcess(Node)", (Throwable)tce);
        }
        catch (TransformerException te) {
            logger.error((Object)"transformCastorProcess(Node)", (Throwable)te);
        }
        return resultDoc;
    }
}

