/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOStarTable;

abstract class Encoder {
    final ValueInfo info;
    final Map attMap = new HashMap();
    final StringBuffer content = new StringBuffer();
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$String;

    public abstract String encodeAsText(Object var1);

    public abstract void encodeToStream(Object var1, DataOutput var2) throws IOException;

    private Encoder(ValueInfo info, String datatype) {
        String desc;
        String ucd;
        String units;
        this.info = info;
        this.attMap.put("datatype", datatype.trim());
        String name = info.getName();
        if (name != null && name.trim().length() > 0) {
            this.attMap.put("name", name.trim());
        }
        if ((units = info.getUnitString()) != null && units.trim().length() > 0) {
            this.attMap.put("unit", units.trim());
        }
        if ((ucd = info.getUCD()) != null && ucd.trim().length() > 0) {
            this.attMap.put("ucd", ucd.trim());
        }
        if (info instanceof ColumnInfo) {
            String precision;
            Integer width;
            String utype;
            ColumnInfo cinfo = (ColumnInfo)info;
            String id = (String)cinfo.getAuxDatumValue(VOStarTable.ID_INFO, class$java$lang$String == null ? (class$java$lang$String = Encoder.class$("java.lang.String")) : class$java$lang$String);
            if (id != null && id.trim().length() > 0) {
                this.attMap.put("ID", id.trim());
            }
            if ((utype = (String)cinfo.getAuxDatumValue(VOStarTable.UTYPE_INFO, class$java$lang$String == null ? (class$java$lang$String = Encoder.class$("java.lang.String")) : class$java$lang$String)) != null && utype.trim().length() > 0) {
                this.attMap.put("utype", utype.trim());
            }
            if ((width = (Integer)cinfo.getAuxDatumValue(VOStarTable.WIDTH_INFO, class$java$lang$Integer == null ? (class$java$lang$Integer = Encoder.class$("java.lang.Integer")) : class$java$lang$Integer)) != null && width > 0) {
                this.attMap.put("width", width.toString());
            }
            if ((precision = (String)cinfo.getAuxDatumValue(VOStarTable.PRECISION_INFO, class$java$lang$String == null ? (class$java$lang$String = Encoder.class$("java.lang.String")) : class$java$lang$String)) != null && precision.trim().length() > 0) {
                this.attMap.put("precision", precision.trim());
            }
        }
        if ((desc = info.getDescription()) != null && (desc = desc.trim()).length() > 0) {
            this.content.append("<DESCRIPTION>").append(VOSerializer.formatText(desc)).append("</DESCRIPTION>");
        }
        if (info instanceof ColumnInfo) {
            Iterator it = ((ColumnInfo)info).getAuxData().iterator();
            while (it.hasNext()) {
                DescribedValue dval;
                ValueInfo linkInfo;
                if (!(class$java$net$URL == null ? Encoder.class$("java.net.URL") : class$java$net$URL).equals((linkInfo = (dval = (DescribedValue)it.next()).getInfo()).getContentClass())) continue;
                String linkName = linkInfo.getName();
                URL linkUrl = (URL)dval.getValue();
                if (linkName == null || linkUrl == null) continue;
                this.content.append("<LINK").append(VOSerializer.formatAttribute("title", linkName)).append(VOSerializer.formatAttribute("href", linkUrl.toString())).append("/>");
            }
        }
    }

    public String getFieldContent() {
        return this.content.toString();
    }

    public Map getFieldAttributes() {
        return this.attMap;
    }

    public static Encoder getEncoder(ValueInfo info) {
        Encoder1 enc1;
        String badString;
        Object o;
        DescribedValue nullValue;
        Class clazz = info.getContentClass();
        int[] dims = info.getShape();
        boolean isNullable = info.isNullable();
        final boolean isVariable = dims != null && dims.length > 0 && dims[dims.length - 1] < 0;
        Number nullObj = null;
        if (info instanceof ColumnInfo && (nullValue = ((ColumnInfo)info).getAuxDatum(Tables.NULL_VALUE_INFO)) != null && (o = nullValue.getValue()) instanceof Number) {
            nullObj = (Number)o;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Encoder.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new ScalarEncoder(info, "boolean", null){

                public String encodeAsText(Object val) {
                    Boolean value = (Boolean)val;
                    return value == null ? "" : (value != false ? "T" : "F");
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Boolean value = (Boolean)val;
                    int b = value == null ? 32 : (value != false ? 84 : 70);
                    out.write(b);
                }
            };
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Encoder.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Encoder.class$("java.lang.Short")) : class$java$lang$Short)) {
            final int badVal = nullObj == null ? Short.MIN_VALUE : nullObj.intValue();
            badString = isNullable ? Integer.toString(badVal) : null;
            return new ScalarEncoder(info, "short", badString){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeShort(value == null ? badVal : value.intValue());
                }
            };
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Encoder.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            final int badVal = nullObj == null ? Integer.MIN_VALUE : nullObj.intValue();
            badString = isNullable ? Integer.toString(badVal) : null;
            return new ScalarEncoder(info, "int", badString){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeInt(value == null ? badVal : value.intValue());
                }
            };
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Encoder.class$("java.lang.Long")) : class$java$lang$Long)) {
            final long badVal = nullObj == null ? Long.MIN_VALUE : nullObj.longValue();
            String badString2 = isNullable ? Long.toString(badVal) : null;
            return new ScalarEncoder(info, "long", badString2){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeLong(value == null ? badVal : value.longValue());
                }
            };
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Encoder.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new ScalarEncoder(info, "float", null){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeFloat(value == null ? Float.NaN : value.floatValue());
                }
            };
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Encoder.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new ScalarEncoder(info, "double", null){

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeDouble(value == null ? Double.NaN : value.doubleValue());
                }
            };
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Encoder.class$("java.lang.Character")) : class$java$lang$Character)) {
            boolean badVal = false;
            return new ScalarEncoder(info, "char", null){
                {
                    this.attMap.put("arraysize", "1");
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Character value = (Character)val;
                    out.write(value == null ? (char)'\u0000' : value.charValue());
                }
            };
        }
        if (clazz == (array$Z == null ? (array$Z = Encoder.class$("[Z")) : array$Z)) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    boolean value = ((boolean[])array)[index];
                    out.write(value ? 84 : 70);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.write(32);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "boolean", dims, enc1) : new FixedArrayEncoder(info, "boolean", dims, enc1);
        }
        if (clazz == (array$B == null ? (array$B = Encoder.class$("[B")) : array$B)) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    byte value = ((byte[])array)[index];
                    out.writeShort(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeShort(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "short", dims, enc1) : new FixedArrayEncoder(info, "short", dims, enc1);
        }
        if (clazz == (array$S == null ? (array$S = Encoder.class$("[S")) : array$S)) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    short value = ((short[])array)[index];
                    out.writeShort(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeShort(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "short", dims, enc1) : new FixedArrayEncoder(info, "short", dims, enc1);
        }
        if (clazz == (array$I == null ? (array$I = Encoder.class$("[I")) : array$I)) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    int value = ((int[])array)[index];
                    out.writeInt(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeInt(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "int", dims, enc1) : new FixedArrayEncoder(info, "int", dims, enc1);
        }
        if (clazz == (array$J == null ? (array$J = Encoder.class$("[J")) : array$J)) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    long value = ((long[])array)[index];
                    out.writeLong(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeLong(0L);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "long", dims, enc1) : new FixedArrayEncoder(info, "long", dims, enc1);
        }
        if (clazz == (array$F == null ? (array$F = Encoder.class$("[F")) : array$F)) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    float value = ((float[])array)[index];
                    out.writeFloat(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeFloat(Float.NaN);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "float", dims, enc1) : new FixedArrayEncoder(info, "float", dims, enc1);
        }
        if (clazz == (array$D == null ? (array$D = Encoder.class$("[D")) : array$D)) {
            enc1 = new Encoder1(){

                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    double value = ((double[])array)[index];
                    out.writeDouble(value);
                }

                public void pad1(DataOutput out) throws IOException {
                    out.writeDouble(Double.NaN);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "double", dims, enc1) : new FixedArrayEncoder(info, "double", dims, enc1);
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Encoder.class$("java.lang.String")) : class$java$lang$String)) {
            int nChar;
            int n = nChar = clazz == (class$java$lang$String == null ? (class$java$lang$String = Encoder.class$("java.lang.String")) : class$java$lang$String) ? info.getElementSize() : -1;
            if (nChar > 0) {
                final byte[] padBuf = new byte[nChar];
                return new Encoder(info, "char"){
                    {
                        super(x0, x1);
                        this.attMap.put("arraysize", Integer.toString(nChar));
                    }

                    public String encodeAsText(Object val) {
                        return val == null ? "" : val.toString();
                    }

                    public void encodeToStream(Object val, DataOutput out) throws IOException {
                        int i = 0;
                        if (val != null) {
                            String value = val.toString();
                            int limit = Math.min(value.length(), nChar);
                            while (i < limit) {
                                out.write(value.charAt(i));
                                ++i;
                            }
                        }
                        out.write(padBuf, 0, nChar - i);
                    }
                };
            }
            return new Encoder(info, "char"){
                {
                    this.attMap.put("arraysize", "*");
                }

                public String encodeAsText(Object val) {
                    return val == null ? "" : val.toString();
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    if (val == null) {
                        out.writeInt(0);
                    } else {
                        String value = val.toString();
                        int leng = value.length();
                        out.writeInt(leng);
                        int i = 0;
                        while (i < leng) {
                            out.write(value.charAt(i));
                            ++i;
                        }
                    }
                }
            };
        }
        if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = Encoder.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            int nChar;
            int n = nChar = clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = Encoder.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) ? info.getElementSize() : -1;
            if (nChar < 0) {
                logger.warning("Oh dear - can't serialize array of variable-length strings to VOTable - sorry");
                return null;
            }
            int[] charDims = new int[dims.length + 1];
            charDims[0] = nChar;
            System.arraycopy(dims, 0, charDims, 1, dims.length);
            StringBuffer sbuf = new StringBuffer();
            int i = 0;
            while (i < charDims.length) {
                if (i > 0) {
                    sbuf.append('x');
                }
                if (i == charDims.length - 1 && charDims[i] < 0) {
                    sbuf.append('*');
                } else {
                    sbuf.append(charDims[i]);
                }
                ++i;
            }
            int ns = 0;
            if (!isVariable) {
                ns = 1;
                int i2 = 0;
                while (i2 < dims.length) {
                    ns *= dims[i2];
                    ++i2;
                }
            }
            final String arraysize = sbuf.toString();
            final int nString = ns;
            return new Encoder(info, "char"){
                char[] cbuf;
                byte[] bbuf;
                byte[] padding;
                {
                    super(x0, x1);
                    this.cbuf = new char[nChar];
                    this.bbuf = new byte[nChar];
                    this.padding = new byte[nChar];
                    this.attMap.put("arraysize", arraysize);
                }

                public String encodeAsText(Object val) {
                    if (val != null) {
                        Object[] value = (Object[])val;
                        StringBuffer sbuf = new StringBuffer();
                        int i = 0;
                        while (i < value.length) {
                            Object el = value[i];
                            String str = el == null ? "" : el.toString();
                            int j = 0;
                            int limit = Math.min(str.length(), nChar);
                            while (j < limit) {
                                this.cbuf[j] = str.charAt(j);
                                ++j;
                            }
                            while (j < nChar) {
                                this.cbuf[j] = 32;
                                ++j;
                            }
                            sbuf.append(new String(this.cbuf));
                            ++i;
                        }
                        return sbuf.toString();
                    }
                    return null;
                }

                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    int slimit;
                    Object[] value;
                    Object[] objectArray = value = val == null ? new Object[]{} : (Object[])val;
                    if (isVariable) {
                        slimit = value.length;
                        out.writeInt(nChar * slimit);
                    } else {
                        slimit = Math.min(value.length, nString);
                    }
                    int is = 0;
                    while (is < slimit) {
                        Object v = value[is];
                        String str = v == null ? "" : v.toString();
                        int climit = Math.min(str.length(), nChar);
                        int ic = 0;
                        while (ic < climit) {
                            this.bbuf[ic] = (byte)str.charAt(ic);
                            ++ic;
                        }
                        while (ic < nChar) {
                            this.bbuf[ic] = 0;
                            ++ic;
                        }
                        out.write(this.bbuf);
                        ++is;
                    }
                    if (!isVariable) {
                        while (is < nString) {
                            out.write(this.padding);
                            ++is;
                        }
                    }
                }
            };
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface Encoder1 {
        public void encode1(Object var1, int var2, DataOutput var3) throws IOException;

        public void pad1(DataOutput var1) throws IOException;
    }

    private static class FixedArrayEncoder
    extends ArrayEncoder {
        final int nfixed;

        FixedArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype, dims, enc1);
            int nfixed = 1;
            int i = 0;
            while (i < dims.length) {
                nfixed *= dims[i];
                ++i;
            }
            this.nfixed = nfixed;
        }

        public void encodeToStream(Object val, DataOutput out) throws IOException {
            int i = 0;
            if (val != null) {
                int nel = Array.getLength(val);
                int limit = Math.min(nel, this.nfixed);
                while (i < limit) {
                    this.enc1.encode1(val, i, out);
                    ++i;
                }
            }
            while (i < this.nfixed) {
                this.enc1.pad1(out);
                ++i;
            }
        }
    }

    private static class VariableArrayEncoder
    extends ArrayEncoder {
        VariableArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype, dims, enc1);
        }

        public void encodeToStream(Object val, DataOutput out) throws IOException {
            if (val == null) {
                out.writeInt(0);
            } else {
                int nel = Array.getLength(val);
                out.writeInt(nel);
                int i = 0;
                while (i < nel) {
                    this.enc1.encode1(val, i, out);
                    ++i;
                }
            }
        }
    }

    private static abstract class ArrayEncoder
    extends Encoder {
        final Encoder1 enc1;

        ArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype);
            this.enc1 = enc1;
            StringBuffer sizeBuf = new StringBuffer();
            int i = 0;
            while (i < dims.length) {
                if (i > 0) {
                    sizeBuf.append('x');
                }
                if (i == dims.length - 1 && dims[i] < 0) {
                    sizeBuf.append('*');
                } else {
                    sizeBuf.append(dims[i]);
                }
                ++i;
            }
            this.attMap.put("arraysize", sizeBuf.toString());
        }

        public String encodeAsText(Object val) {
            if (val == null) {
                return "";
            }
            int nel = Array.getLength(val);
            StringBuffer sbuf = new StringBuffer();
            int i = 0;
            while (i < nel) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(Array.get(val, i).toString());
                ++i;
            }
            return sbuf.toString();
        }
    }

    private static abstract class ScalarEncoder
    extends Encoder {
        ScalarEncoder(ValueInfo info, String datatype, String nullString) {
            super(info, datatype);
            if (nullString != null) {
                if (this.content.length() > 0) {
                    this.content.append('\n');
                }
                this.content.append("<VALUES null='").append(nullString).append("'/>");
            }
        }

        public String encodeAsText(Object val) {
            return val == null ? "" : val.toString();
        }
    }
}

