/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.FieldRefElement;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.ParamRefElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;

public class GroupElement
extends VOElement {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    GroupElement(Element base, VODocument doc) {
        super(base, doc, "GROUP");
    }

    public ParamElement[] getParams() {
        ArrayList<Node> paramList = new ArrayList<Node>();
        Node ch = this.getFirstChild();
        while (ch != null) {
            if (ch instanceof ParamRefElement) {
                ParamElement pel = ((ParamRefElement)ch).getParam();
                if (pel == null) {
                    logger_.warning("Missing referent for PARAMref");
                } else {
                    paramList.add(pel);
                }
            } else if (ch instanceof ParamElement) {
                paramList.add(ch);
            }
            ch = ch.getNextSibling();
        }
        return paramList.toArray(new ParamElement[0]);
    }

    public FieldElement[] getFields() {
        ArrayList<FieldElement> fieldList = new ArrayList<FieldElement>();
        Node ch = this.getFirstChild();
        while (ch != null) {
            if (ch instanceof FieldRefElement) {
                FieldElement fel = ((FieldRefElement)ch).getField();
                if (fel == null) {
                    logger_.warning("Missing referent for FIELDref");
                } else {
                    fieldList.add(fel);
                }
            }
            ch = ch.getNextSibling();
        }
        return fieldList.toArray(new FieldElement[0]);
    }

    public GroupElement[] getGroups() {
        VOElement[] voels = this.getChildrenByName("GROUP");
        GroupElement[] gels = new GroupElement[voels.length];
        System.arraycopy(voels, 0, gels, 0, voels.length);
        return gels;
    }
}

