/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.BinaryRowStepper;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.RowStepper;
import uk.ac.starlink.votable.TabularData;

class TableBodies {
    TableBodies() {
    }

    static Class[] getClasses(Decoder[] decoders) {
        int ncol = decoders.length;
        Class[] classes = new Class[ncol];
        int icol = 0;
        while (icol < ncol) {
            classes[icol] = decoders[icol].getContentClass();
            ++icol;
        }
        return classes;
    }

    static class TabledataTabularData
    extends SequentialTabularData {
        final Decoder[] decoders;
        final Element tabledataEl;
        final int ncol;
        Element[] rows;

        TabledataTabularData(Decoder[] decoders, Element tabledataEl) {
            super(TableBodies.getClasses(decoders));
            this.decoders = decoders;
            this.tabledataEl = tabledataEl;
            this.ncol = decoders.length;
        }

        public long getRowCount() {
            if (this.rows == null) {
                long nrow = 0L;
                Node node = this.tabledataEl.getFirstChild();
                while (node != null) {
                    if (node instanceof Element && ((Element)node).getTagName().equals("TR")) {
                        ++nrow;
                    }
                    node = node.getNextSibling();
                }
                return nrow;
            }
            return this.rows.length;
        }

        public boolean isRandom() {
            return true;
        }

        private Element[] getRows() {
            ArrayList<Element> rowList = new ArrayList<Element>();
            if (this.rows == null) {
                Element trEl = TabledataTabularData.firstSibling("TR", this.tabledataEl.getFirstChild());
                while (trEl != null) {
                    rowList.add(trEl);
                    trEl = TabledataTabularData.firstSibling("TR", trEl.getNextSibling());
                }
                this.rows = rowList.toArray(new Element[0]);
            }
            return this.rows;
        }

        public Object[] getRow(long irow) {
            return this.getRow(this.getRows()[(int)irow]);
        }

        public Object getCell(long irow, int icol) {
            Element trEl = this.getRows()[(int)irow];
            int jcol = 0;
            Element tdEl = TabledataTabularData.firstSibling("TD", trEl.getFirstChild());
            while (tdEl != null && icol < this.ncol) {
                if (jcol == icol) {
                    String txt = DOMUtils.getTextContent(tdEl);
                    if (txt != null && txt.length() > 0) {
                        return this.decoders[icol].decodeString(txt);
                    }
                    return null;
                }
                ++jcol;
                tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
            }
            return null;
        }

        public RowStepper getRowStepper() {
            return new RowStepper(this){
                Element trEl;
                private final /* synthetic */ TabledataTabularData this$0;
                {
                    this.this$0 = this$0;
                    this.trEl = TabledataTabularData.access$100("TR", this.this$0.tabledataEl.getFirstChild());
                }

                public Object[] nextRow() {
                    if (this.trEl == null) {
                        return null;
                    }
                    Object[] row = TabledataTabularData.access$200(this.this$0, this.trEl);
                    this.trEl = TabledataTabularData.access$100("TR", this.trEl.getNextSibling());
                    return row;
                }
            };
        }

        private Object[] getRow(Element trEl) {
            Object[] row = new Object[this.ncol];
            int icol = 0;
            Element tdEl = TabledataTabularData.firstSibling("TD", trEl.getFirstChild());
            while (tdEl != null && icol < this.ncol) {
                String txt = DOMUtils.getTextContent(tdEl);
                if (txt != null && txt.length() > 0) {
                    row[icol] = this.decoders[icol].decodeString(txt);
                }
                ++icol;
                tdEl = TabledataTabularData.firstSibling("TD", tdEl.getNextSibling());
            }
            return row;
        }

        private static Element firstSibling(String tag, Node node) {
            if (node == null) {
                return null;
            }
            if (node instanceof Element && ((Element)node).getTagName().equals(tag)) {
                return (Element)node;
            }
            return TabledataTabularData.firstSibling(tag, node.getNextSibling());
        }

        static /* synthetic */ Element access$100(String x0, Node x1) {
            return TabledataTabularData.firstSibling(x0, x1);
        }

        static /* synthetic */ Object[] access$200(TabledataTabularData x0, Element x1) {
            return x0.getRow(x1);
        }
    }

    static class HrefBinaryTabularData
    extends SequentialTabularData {
        private final Decoder[] decoders;
        private final URL url;
        private final String encoding;

        public HrefBinaryTabularData(Decoder[] decoders, URL url, String encoding) {
            super(TableBodies.getClasses(decoders));
            this.decoders = decoders;
            this.url = url;
            this.encoding = encoding;
        }

        public RowStepper getRowStepper() throws IOException {
            BufferedInputStream istrm = new BufferedInputStream(this.url.openStream());
            return new BinaryRowStepper(this.decoders, istrm, this.encoding);
        }
    }

    static class StarTableTabularData
    implements TabularData {
        private final StarTable startab;

        public StarTableTabularData(StarTable startab) {
            this.startab = startab;
        }

        public int getColumnCount() {
            return this.startab.getColumnCount();
        }

        public long getRowCount() {
            return this.startab.getRowCount();
        }

        public Class getContentClass(int icol) {
            return this.startab.getColumnInfo(icol).getContentClass();
        }

        public RowStepper getRowStepper() throws IOException {
            return new RowStepper(this){
                RowSequence rseq;
                private final /* synthetic */ StarTableTabularData this$0;
                {
                    this.this$0 = this$0;
                    this.rseq = StarTableTabularData.access$000(this.this$0).getRowSequence();
                }

                public Object[] nextRow() throws IOException {
                    return this.rseq.next() ? this.rseq.getRow() : null;
                }
            };
        }

        public boolean isRandom() {
            return this.startab.isRandom();
        }

        public Object getCell(long irow, int icol) throws IOException {
            return this.startab.getCell(irow, icol);
        }

        public Object[] getRow(long irow) throws IOException {
            return this.startab.getRow(irow);
        }

        static /* synthetic */ StarTable access$000(StarTableTabularData x0) {
            return x0.startab;
        }
    }

    static class EmptyTabularData
    extends SequentialTabularData {
        public EmptyTabularData(Class[] classes) {
            super(classes);
        }

        public long getRowCount() {
            return 0L;
        }

        public RowStepper getRowStepper() {
            return new RowStepper(this){
                private final /* synthetic */ EmptyTabularData this$0;
                {
                    this.this$0 = this$0;
                }

                public Object[] nextRow() {
                    return null;
                }
            };
        }
    }

    static abstract class SequentialTabularData
    implements TabularData {
        final int ncol;
        final Class[] classes;

        public SequentialTabularData(Class[] classes) {
            this.classes = classes;
            this.ncol = classes.length;
        }

        public int getColumnCount() {
            return this.ncol;
        }

        public long getRowCount() {
            return -1L;
        }

        public Class getContentClass(int icol) {
            return this.classes[icol];
        }

        public abstract RowStepper getRowStepper() throws IOException;

        public boolean isRandom() {
            return false;
        }

        public Object getCell(long irow, int icol) {
            throw new UnsupportedOperationException("Not random");
        }

        public Object[] getRow(long irow) {
            throw new UnsupportedOperationException("Not random");
        }
    }
}

