/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.PipeReaderThread;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.Base64InputStream;
import uk.ac.starlink.votable.BinaryRowStepper;
import uk.ac.starlink.votable.CustomDOMBuilder;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

class TableStreamer
extends CustomDOMBuilder {
    private TableSink sink;
    private int skipTables;
    private String systemId;
    private ContentHandler basicHandler;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.ac.votable");
    static /* synthetic */ Class class$uk$ac$starlink$votable$TableStreamer;

    public TableStreamer(TableSink sink, int itable, boolean strict) {
        super(strict);
        this.sink = sink;
        this.skipTables = itable;
        this.basicHandler = new BasicContentHandler();
        this.setCustomHandler(this.basicHandler);
    }

    public static void streamStarTable(InputSource saxsrc, TableSink sink, int itable, boolean strict) throws IOException, SAXException {
        XMLReader parser;
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
        parser.setEntityResolver(StarEntityResolver.getInstance());
        parser.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException e) {
                logger.warning(e.toString());
            }

            public void warning(SAXParseException e) {
                logger.warning(e.toString());
            }

            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        parser.setContentHandler(new TableStreamer(sink, itable, strict));
        try {
            parser.parse(saxsrc);
        }
        catch (SuccessfulCompletionException e) {
            return;
        }
        catch (SAXException e) {
            throw VOElementFactory.fixStackTrace(e);
        }
        throw new IOException("No TABLE element found");
    }

    private void finished() throws SAXException {
        try {
            this.sink.endRows();
        }
        catch (IOException e) {
            throw new SAXParseException(e.getMessage(), this.getLocator(), e);
        }
        throw new SuccessfulCompletionException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SuccessfulCompletionException
    extends SAXException {
        SuccessfulCompletionException() {
            super("Table extraction complete");
        }
    }

    class CDATASinkHandler
    extends CustomDOMBuilder.NullContentHandler {
        final Writer out;
        final PipeReaderThread reader;

        CDATASinkHandler(Writer out, PipeReaderThread reader) {
            this.out = out;
            this.reader = reader;
            reader.start();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            throw new SAXParseException("Unwelcome child <" + tagName + "> of STREAM", TableStreamer.this.getLocator());
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.out.write(ch, start, length);
            }
            catch (IOException e) {}
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            if ("STREAM".equals(tagName)) {
                try {
                    this.out.close();
                    this.reader.finishReading();
                }
                catch (IOException e) {
                    throw (SAXException)new SAXParseException("Error closing", TableStreamer.this.getLocator(), e).initCause(e);
                }
            }
            TableStreamer.this.finished();
        }
    }

    class TabledataHandler
    extends CustomDOMBuilder.NullContentHandler {
        final Decoder[] decoders;
        final int ncol;
        int icol;
        Object[] row;
        StringBuffer cell;
        boolean inCell;

        TabledataHandler(Decoder[] decoders) {
            this.decoders = decoders;
            this.ncol = decoders.length;
            this.cell = new StringBuffer();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            if ("TD".equals(tagName)) {
                this.cell.setLength(0);
                this.inCell = true;
            } else if ("TR".equals(tagName)) {
                this.row = new Object[this.ncol];
                this.icol = 0;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.inCell) {
                this.cell.append(ch, start, length);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            if (this.inCell) {
                this.cell.append(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            if (this.inCell && "TD".equals(tagName) && this.icol < this.ncol) {
                this.row[this.icol] = this.cell.length() > 0 ? this.decoders[this.icol].decodeString(this.cell.toString()) : null;
                ++this.icol;
                this.inCell = false;
            } else if ("TR".equals(tagName)) {
                try {
                    TableStreamer.this.sink.acceptRow(this.row);
                }
                catch (IOException e) {
                    throw (SAXException)new SAXParseException(e.getMessage(), TableStreamer.this.getLocator(), e).initCause(e);
                }
            }
            if ("TABLEDATA".equals(tagName)) {
                TableStreamer.this.finished();
            }
        }
    }

    class DataContentHandler
    extends CustomDOMBuilder.DefaultContentHandler {
        FieldElement[] fields;
        Decoder[] decoders;
        String mode;
        String extnum;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DataContentHandler(TableElement tableEl) throws SAXException {
            VOStarTable meta;
            this.fields = tableEl.getFields();
            int ncol = this.fields.length;
            this.decoders = new Decoder[ncol];
            int i = 0;
            while (i < ncol) {
                this.decoders[i] = this.fields[i].getDecoder();
                ++i;
            }
            Node dataEl = TableStreamer.this.getNewestNode();
            if (!$assertionsDisabled && !dataEl.getNodeName().equals("DATA")) {
                throw new AssertionError();
            }
            tableEl.removeChild(dataEl);
            try {
                meta = new VOStarTable(this, tableEl){
                    private final /* synthetic */ DataContentHandler this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public long getRowCount() {
                        long nrow = super.getRowCount();
                        return nrow > 0L ? nrow : -1L;
                    }
                };
            }
            catch (IOException e) {
                throw new AssertionError();
            }
            try {
                TableStreamer.this.sink.acceptMetadata(meta);
            }
            catch (TableFormatException e) {
                throw new SAXParseException(e.getMessage(), TableStreamer.this.getLocator(), e);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            if ("FITS".equals(tagName)) {
                this.mode = "FITS";
                this.extnum = TableStreamer.this.getAttribute(atts, "extnum");
            } else if ("BINARY".equals(tagName)) {
                this.mode = "BINARY";
            } else if ("TABLEDATA".equals(tagName)) {
                TableStreamer.this.setCustomHandler(new TabledataHandler(this.decoders));
            } else if ("STREAM".equals(tagName)) {
                if (!"FITS".equals(this.mode) && !"BINARY".equals(this.mode)) {
                    throw new SAXParseException("STREAM is not BINARY or FITS!", TableStreamer.this.getLocator());
                }
                String href = TableStreamer.this.getAttribute(atts, "href");
                String encoding = TableStreamer.this.getAttribute(atts, "encoding");
                if (href != null) {
                    try {
                        URL url = URLUtils.makeURL(TableStreamer.this.systemId, href);
                        if (this.mode.equals("BINARY")) {
                            Object[] row;
                            BinaryRowStepper rstep = new BinaryRowStepper(this.decoders, url.openStream(), encoding);
                            while ((row = rstep.nextRow()) != null) {
                                void var10_14;
                                TableStreamer.this.sink.acceptRow((Object[])var10_14);
                            }
                        } else if (this.mode.equals("FITS")) {
                            new FitsTableBuilder().streamStarTable(url.openStream(), TableStreamer.this.sink, this.extnum);
                        } else if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    catch (IOException e) {
                        throw (SAXException)new SAXParseException(e.getMessage(), TableStreamer.this.getLocator(), e).initCause(e);
                    }
                    TableStreamer.this.finished();
                } else {
                    try {
                        PipeReaderThread reader;
                        if (this.mode.equals("BINARY")) {
                            reader = new PipeReaderThread(this){
                                private final /* synthetic */ DataContentHandler this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                protected void doReading(InputStream datain) throws IOException {
                                    Object[] row;
                                    BufferedInputStream in = new BufferedInputStream(datain);
                                    BinaryRowStepper rs = new BinaryRowStepper(this.this$1.decoders, in, "base64");
                                    while ((row = rs.nextRow()) != null) {
                                        void var4_4;
                                        TableStreamer.access$400(DataContentHandler.access$600(this.this$1)).acceptRow((Object[])var4_4);
                                    }
                                }
                            };
                        } else {
                            if (!$assertionsDisabled && !this.mode.equals("FITS")) {
                                throw new AssertionError();
                            }
                            reader = new PipeReaderThread(this){
                                private final /* synthetic */ DataContentHandler this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                protected void doReading(InputStream datain) throws IOException {
                                    BufferedInputStream in = new BufferedInputStream(new Base64InputStream(datain));
                                    new FitsTableBuilder().streamStarTable((InputStream)in, TableStreamer.access$400(DataContentHandler.access$600(this.this$1)), this.this$1.extnum);
                                }
                            };
                        }
                        OutputStream b64out = reader.getOutputStream();
                        OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(b64out));
                        TableStreamer.this.setCustomHandler(new CDATASinkHandler(out, reader));
                    }
                    catch (IOException e) {
                        throw (SAXException)new SAXParseException("Trouble setting up data handler", TableStreamer.this.getLocator(), e).initCause(e);
                    }
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            if ("FITS".equals(tagName)) {
                this.extnum = null;
                this.mode = null;
            } else if ("BINARY".equals(tagName)) {
                this.mode = null;
            } else if ("DATA".equals(tagName)) {
                TableStreamer.this.finished();
            }
        }

        static /* synthetic */ TableStreamer access$600(DataContentHandler x0) {
            return x0.TableStreamer.this;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$votable$TableStreamer == null ? (class$uk$ac$starlink$votable$TableStreamer = TableStreamer.class$("uk.ac.starlink.votable.TableStreamer")) : class$uk$ac$starlink$votable$TableStreamer).desiredAssertionStatus();
        }
    }

    class IgnoreContentHandler
    extends CustomDOMBuilder.NullContentHandler {
        int level;
        String tagName;
        static final /* synthetic */ boolean $assertionsDisabled;

        IgnoreContentHandler(String tagName) {
            this.tagName = tagName;
            this.level = 1;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            ++this.level;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (--this.level == 0) {
                if (!$assertionsDisabled && !this.tagName.equals(TableStreamer.this.getTagName(namespaceURI, localName, qName))) {
                    throw new AssertionError();
                }
                TableStreamer.this.basicHandler.endElement(namespaceURI, localName, qName);
                TableStreamer.this.setCustomHandler(TableStreamer.this.basicHandler);
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$votable$TableStreamer == null ? (class$uk$ac$starlink$votable$TableStreamer = TableStreamer.class$("uk.ac.starlink.votable.TableStreamer")) : class$uk$ac$starlink$votable$TableStreamer).desiredAssertionStatus();
        }
    }

    class BasicContentHandler
    extends CustomDOMBuilder.DefaultContentHandler {
        BasicContentHandler() {
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            TableStreamer.this.systemId = TableStreamer.this.getLocator().getSystemId();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            if ("DATA".equals(tagName)) {
                if (TableStreamer.this.skipTables != 0) {
                    TableStreamer.this.setCustomHandler(new IgnoreContentHandler(tagName));
                } else {
                    Node parent = TableStreamer.this.getNewestNode().getParentNode();
                    if (parent instanceof TableElement) {
                        TableElement tableEl = (TableElement)parent;
                        TableStreamer.this.setCustomHandler(new DataContentHandler(tableEl));
                    } else {
                        logger.warning("DATA element is not TABLE child");
                        TableStreamer.this.setCustomHandler(new IgnoreContentHandler(tagName));
                    }
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            String tagName = TableStreamer.this.getTagName(namespaceURI, localName, qName);
            if ("TABLE".equals(tagName)) {
                TableStreamer.this.skipTables--;
            }
        }

        public void endDocument() throws SAXException {
            throw new SAXException("TABLE element not found in document");
        }
    }
}

