/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.votable.SAXDocumentBuilder;
import uk.ac.starlink.votable.VODocument;

class VOSAXDocumentBuilder
implements SAXDocumentBuilder {
    private Locator locator_;
    private VODocument doc_;
    private NodeStack nodeStack_ = new NodeStack();
    private Map prefixMap_ = new HashMap();
    private boolean strict_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");
    private static final String[] ELEMENTS_WITH_ID = new String[]{"VOTABLE", "RESOURCE", "INFO", "PARAM", "TABLE", "FIELD", "GROUP", "VALUES", "LINK", "COOSYS"};

    public VOSAXDocumentBuilder(boolean strict) {
        this.strict_ = strict;
    }

    public Node getNewestNode() {
        return this.nodeStack_.top();
    }

    public Locator getLocator() {
        return this.locator_;
    }

    public Document getDocument() {
        return this.doc_;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    public void startDocument() throws SAXException {
        Document baseDoc;
        try {
            baseDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException("Cannot create empty DOM", e).initCause(e);
        }
        String systemId = this.locator_ == null ? null : this.locator_.getSystemId();
        this.doc_ = new VODocument(baseDoc, systemId, this.strict_);
        this.nodeStack_.push(this.doc_);
    }

    public void endDocument() {
        this.nodeStack_.pop().normalize();
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap_.put(uri, prefix);
    }

    public void endPrefixMapping(String prefix) {
        Iterator it = this.prefixMap_.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().equals(prefix)) continue;
            it.remove();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXParseException {
        try {
            Element el;
            if (localName != null && localName.length() > 0) {
                String prefix = (String)this.prefixMap_.get(namespaceURI);
                String qualifiedName = prefix == null ? localName : prefix + ":" + localName;
                el = this.doc_.createElementNS(namespaceURI, qualifiedName);
            } else {
                String tagName = qName;
                el = this.doc_.createElement(tagName);
            }
            int i = 0;
            while (i < atts.getLength()) {
                Attr att;
                String attURI = atts.getURI(i);
                String attLocalName = atts.getLocalName(i);
                String attQName = atts.getQName(i);
                String value = atts.getValue(i);
                String type = atts.getType(i);
                if (attURI != null && attURI.length() > 0 && attQName != null && attQName.length() > 0) {
                    att = this.doc_.createAttributeNS(attURI, attQName);
                    el.setAttributeNodeNS(att);
                } else if (attQName != null && attQName.length() > 0) {
                    att = this.doc_.createAttribute(attQName);
                    el.setAttributeNode(att);
                } else {
                    att = this.doc_.createAttribute(attLocalName);
                    el.setAttributeNode(att);
                }
                att.setValue(value);
                if (type.equals("ID") || this.isVotableID(att)) {
                    if (this.doc_.getElementById(value) != null) {
                        logger_.warning("Multiple elements with ID " + value);
                    }
                    this.doc_.setElementId(el, value);
                }
                ++i;
            }
            this.nodeStack_.top().appendChild(el);
            this.nodeStack_.push(el);
        }
        catch (DOMException e) {
            throw (SAXParseException)new SAXParseException("DOM building error", this.locator_, e).initCause(e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.nodeStack_.pop();
    }

    public void characters(char[] ch, int start, int length) throws SAXParseException {
        try {
            this.nodeStack_.top().appendChild(this.doc_.createTextNode(new String(ch, start, length)));
        }
        catch (DOMException e) {
            throw (SAXParseException)new SAXParseException("DOM building error", this.locator_, e).initCause(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
        logger_.info("Skipping entity " + name);
    }

    private boolean isVotableID(Attr att) {
        if (att.getName().equals("ID")) {
            String elName = att.getOwnerElement().getTagName();
            int i = 0;
            while (i < ELEMENTS_WITH_ID.length) {
                if (ELEMENTS_WITH_ID[i].equals(elName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static class NodeStack {
        private List stack_ = new ArrayList();

        private NodeStack() {
        }

        void push(Node node) {
            this.stack_.add(node);
        }

        Node pop() {
            return (Node)this.stack_.remove(this.stack_.size() - 1);
        }

        Node top() {
            return (Node)this.stack_.get(this.stack_.size() - 1);
        }
    }
}

